/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.client.dto.v1_0;

import com.liferay.headless.admin.site.client.function.UnsafeSupplier;
import com.liferay.headless.admin.site.client.serdes.v1_0.CollectionReferenceSerDes;
import java.io.Serializable;
import java.util.Objects;

public abstract class CollectionReference
implements Cloneable,
Serializable {
    protected CollectionType collectionType;

    public static CollectionReference toDTO(String json) {
        return CollectionReferenceSerDes.toDTO(json);
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public String getCollectionTypeAsString() {
        if (this.collectionType == null) {
            return null;
        }
        return this.collectionType.toString();
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public void setCollectionType(UnsafeSupplier<CollectionType, Exception> collectionTypeUnsafeSupplier) {
        try {
            this.collectionType = collectionTypeUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CollectionReference clone() throws CloneNotSupportedException {
        return (CollectionReference)super.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CollectionReference)) {
            return false;
        }
        CollectionReference collectionReference = (CollectionReference)object;
        return Objects.equals(this.toString(), collectionReference.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        return CollectionReferenceSerDes.toJSON(this);
    }

    public static enum CollectionType {
        COLLECTION("Collection"),
        COLLECTION_PROVIDER("CollectionProvider");

        private final String _value;

        public static CollectionType create(String value) {
            for (CollectionType collectionType : CollectionType.values()) {
                if (!Objects.equals(collectionType.getValue(), value) && !Objects.equals(collectionType.name(), value)) continue;
                return collectionType;
            }
            return null;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private CollectionType(String value) {
            this._value = value;
        }
    }
}

