/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.client.scope;

import com.liferay.headless.admin.site.client.function.UnsafeSupplier;
import com.liferay.headless.admin.site.client.json.BaseJSONParser;
import java.io.Serializable;
import java.util.Objects;

public class Scope
implements Cloneable,
Serializable {
    protected String externalReferenceCode;
    protected String key;
    protected String label;
    protected Type type;

    public static Scope toDTO(String json) {
        ScopeJSONParser scopeJSONParser = new ScopeJSONParser();
        return (Scope)scopeJSONParser.parseToDTO(json);
    }

    public Scope clone() throws CloneNotSupportedException {
        return (Scope)super.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Scope)) {
            return false;
        }
        Scope scope = (Scope)object;
        return Objects.equals(this.toString(), scope.toString());
    }

    public String getExternalReferenceCode() {
        return this.externalReferenceCode;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeAsString() {
        if (this.type == null) {
            return null;
        }
        return this.type.toString();
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
    }

    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        try {
            this.externalReferenceCode = externalReferenceCodeUnsafeSupplier.get();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setKey(UnsafeSupplier<String, Exception> keyUnsafeSupplier) {
        try {
            this.key = keyUnsafeSupplier.get();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLabel(UnsafeSupplier<String, Exception> labelUnsafeSupplier) {
        try {
            this.label = labelUnsafeSupplier.get();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setType(UnsafeSupplier<Type, Exception> typeUnsafeSupplier) {
        try {
            this.type = typeUnsafeSupplier.get();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String toString() {
        return ScopeJSONParser.toJSON(this);
    }

    private static class ScopeJSONParser
    extends BaseJSONParser<Scope> {
        private ScopeJSONParser() {
        }

        public static String toJSON(Scope scope) {
            if (scope == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            if (scope.getExternalReferenceCode() != null) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append("\"externalReferenceCode\": \"");
                sb.append(ScopeJSONParser._escape(scope.getExternalReferenceCode()));
                sb.append("\"");
            }
            if (scope.getKey() != null) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append("\"key\": \"");
                sb.append(ScopeJSONParser._escape(scope.getKey()));
                sb.append("\"");
            }
            if (scope.getLabel() != null) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append("\"label\": \"");
                sb.append(ScopeJSONParser._escape(scope.getLabel()));
                sb.append("\"");
            }
            if (scope.getType() != null) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append("\"type\": \"");
                sb.append((Object)scope.getType());
                sb.append("\"");
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        protected Scope createDTO() {
            return new Scope();
        }

        protected Scope[] createDTOArray(int size) {
            return new Scope[size];
        }

        @Override
        protected boolean parseMaps(String jsonParserFieldName) {
            if (Objects.equals(jsonParserFieldName, "externalReferenceCode")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "key")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "label")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "type")) {
                return false;
            }
            return false;
        }

        @Override
        protected void setField(Scope scope, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "externalReferenceCode")) {
                if (jsonParserFieldValue != null) {
                    scope.setExternalReferenceCode((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "key")) {
                if (jsonParserFieldValue != null) {
                    scope.setKey((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "label")) {
                if (jsonParserFieldValue != null) {
                    scope.setLabel((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "type")) {
                if (jsonParserFieldValue != null) {
                    scope.setType(Type.create((String)jsonParserFieldValue));
                }
            } else {
                throw new IllegalArgumentException("Unsupported field name " + jsonParserFieldName);
            }
        }

        private static String _escape(Object object) {
            String string = String.valueOf(object);
            for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
                string = string.replace(strings[0], strings[1]);
            }
            return string;
        }
    }

    public static enum Type {
        ASSET_LIBRARY("AssetLibrary"),
        SITE("Site"),
        SPACE("Space");

        private final String _value;

        public static Type create(String value) {
            for (Type type : Type.values()) {
                if (!Objects.equals(type.getValue(), value) && !Objects.equals(type.name(), value)) continue;
                return type;
            }
            return null;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Type(String value) {
            this._value = value;
        }
    }
}

