/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.client.dto.v1_0;

import com.liferay.headless.admin.site.client.function.UnsafeSupplier;
import com.liferay.headless.admin.site.client.serdes.v1_0.URLValueSerDes;
import java.io.Serializable;
import java.util.Objects;

public abstract class URLValue
implements Cloneable,
Serializable {
    protected UrlType urlType;

    public static URLValue toDTO(String json) {
        return URLValueSerDes.toDTO(json);
    }

    public UrlType getUrlType() {
        return this.urlType;
    }

    public String getUrlTypeAsString() {
        if (this.urlType == null) {
            return null;
        }
        return this.urlType.toString();
    }

    public void setUrlType(UrlType urlType) {
        this.urlType = urlType;
    }

    public void setUrlType(UnsafeSupplier<UrlType, Exception> urlTypeUnsafeSupplier) {
        try {
            this.urlType = urlTypeUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public URLValue clone() throws CloneNotSupportedException {
        return (URLValue)super.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof URLValue)) {
            return false;
        }
        URLValue urlValue = (URLValue)object;
        return Objects.equals(this.toString(), urlValue.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        return URLValueSerDes.toJSON(this);
    }

    public static enum UrlType {
        HREF("Href"),
        SITE_PAGE("SitePage");

        private final String _value;

        public static UrlType create(String value) {
            for (UrlType urlType : UrlType.values()) {
                if (!Objects.equals(urlType.getValue(), value) && !Objects.equals(urlType.name(), value)) continue;
                return urlType;
            }
            return null;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private UrlType(String value) {
            this._value = value;
        }
    }
}

