/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.client.custom.field;

import com.liferay.headless.admin.site.client.function.UnsafeSupplier;
import com.liferay.headless.admin.site.client.json.BaseJSONParser;
import java.util.Objects;

public class Geo {
    protected Double latitude;
    protected Double longitude;

    public static Geo toDTO(String json) {
        GeoJSONParser geoJSONParser = new GeoJSONParser();
        return (Geo)geoJSONParser.parseToDTO(json);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Geo)) {
            return false;
        }
        Geo geo = (Geo)object;
        return Objects.equals(this.toString(), geo.toString());
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setLatitude(UnsafeSupplier<Double, Exception> latitudeUnsafeSupplier) {
        try {
            this.latitude = latitudeUnsafeSupplier.get();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setLongitude(UnsafeSupplier<Double, Exception> longitudeUnsafeSupplier) {
        try {
            this.longitude = longitudeUnsafeSupplier.get();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String toString() {
        return GeoJSONParser.toJSON(this);
    }

    private static class GeoJSONParser
    extends BaseJSONParser<Geo> {
        private GeoJSONParser() {
        }

        public static String toJSON(Geo geo) {
            if (geo == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            if (geo.getLatitude() != null) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append("\"latitude\": ");
                sb.append(geo.getLatitude());
            }
            if (geo.getLongitude() != null) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append("\"longitude\": ");
                sb.append(geo.getLongitude());
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        protected Geo createDTO() {
            return new Geo();
        }

        protected Geo[] createDTOArray(int size) {
            return new Geo[size];
        }

        @Override
        protected boolean parseMaps(String jsonParserFieldName) {
            if (Objects.equals(jsonParserFieldName, "latitude")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "longitude")) {
                return false;
            }
            return false;
        }

        @Override
        protected void setField(Geo geo, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "latitude")) {
                if (jsonParserFieldValue != null) {
                    geo.setLatitude(Double.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "longitude") && jsonParserFieldValue != null) {
                geo.setLongitude(Double.valueOf((String)jsonParserFieldValue));
            }
        }
    }
}

