/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.headless.admin.site.client.serdes.v1_0;

import com.liferay.headless.admin.site.client.dto.v1_0.ImageValue;
import com.liferay.headless.admin.site.client.dto.v1_0.ItemImageValue;
import com.liferay.headless.admin.site.client.dto.v1_0.URLImageValue;
import com.liferay.headless.admin.site.client.json.BaseJSONParser;

import jakarta.annotation.Generated;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

/**
 * @author Rubén Pulido
 * @generated
 */
@Generated("")
public class ImageValueSerDes {

	public static ImageValue toDTO(String json) {
		ImageValueJSONParser imageValueJSONParser = new ImageValueJSONParser();

		return imageValueJSONParser.parseToDTO(json);
	}

	public static ImageValue[] toDTOs(String json) {
		ImageValueJSONParser imageValueJSONParser = new ImageValueJSONParser();

		return imageValueJSONParser.parseToDTOs(json);
	}

	public static String toJSON(ImageValue imageValue) {
		if (imageValue == null) {
			return "null";
		}

		ImageValue.Type type = imageValue.getType();

		if (type != null) {
			String typeString = type.toString();

			if (typeString.equals("Item")) {
				return ItemImageValueSerDes.toJSON((ItemImageValue)imageValue);
			}

			if (typeString.equals("URL")) {
				return URLImageValueSerDes.toJSON((URLImageValue)imageValue);
			}

			throw new IllegalArgumentException("Unknown type " + typeString);
		}
		else {
			throw new IllegalArgumentException("Missing type parameter");
		}
	}

	public static Map<String, Object> toMap(String json) {
		ImageValueJSONParser imageValueJSONParser = new ImageValueJSONParser();

		return imageValueJSONParser.parseToMap(json);
	}

	public static Map<String, String> toMap(ImageValue imageValue) {
		if (imageValue == null) {
			return null;
		}

		Map<String, String> map = new TreeMap<>();

		if (imageValue.getType() == null) {
			map.put("type", null);
		}
		else {
			map.put("type", String.valueOf(imageValue.getType()));
		}

		return map;
	}

	public static class ImageValueJSONParser
		extends BaseJSONParser<ImageValue> {

		@Override
		protected ImageValue createDTO() {
			return null;
		}

		@Override
		protected ImageValue[] createDTOArray(int size) {
			return new ImageValue[size];
		}

		@Override
		protected boolean parseMaps(String jsonParserFieldName) {
			if (Objects.equals(jsonParserFieldName, "type")) {
				return false;
			}

			return false;
		}

		@Override
		public ImageValue parseToDTO(String json) {
			Map<String, Object> jsonMap = parseToMap(json);

			Object type = jsonMap.get("type");

			if (type != null) {
				String typeString = type.toString();

				if (typeString.equals("Item")) {
					return ItemImageValue.toDTO(json);
				}

				if (typeString.equals("URL")) {
					return URLImageValue.toDTO(json);
				}

				throw new IllegalArgumentException(
					"Unknown type " + typeString);
			}
			else {
				throw new IllegalArgumentException("Missing type parameter");
			}
		}

		@Override
		protected void setField(
			ImageValue imageValue, String jsonParserFieldName,
			Object jsonParserFieldValue) {

			if (Objects.equals(jsonParserFieldName, "type")) {
				if (jsonParserFieldValue != null) {
					imageValue.setType(
						ImageValue.Type.create((String)jsonParserFieldValue));
				}
			}
		}

	}

	private static String _escape(Object object) {
		String string = String.valueOf(object);

		for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
			string = string.replace(strings[0], strings[1]);
		}

		return string;
	}

	private static String _toJSON(Map<String, ?> map) {
		StringBuilder sb = new StringBuilder("{");

		@SuppressWarnings("unchecked")
		Set set = map.entrySet();

		@SuppressWarnings("unchecked")
		Iterator<Map.Entry<String, ?>> iterator = set.iterator();

		while (iterator.hasNext()) {
			Map.Entry<String, ?> entry = iterator.next();

			sb.append("\"");
			sb.append(entry.getKey());
			sb.append("\": ");

			Object value = entry.getValue();

			sb.append(_toJSON(value));

			if (iterator.hasNext()) {
				sb.append(", ");
			}
		}

		sb.append("}");

		return sb.toString();
	}

	private static String _toJSON(Object value) {
		if (value == null) {
			return "null";
		}

		if (value instanceof Map) {
			return _toJSON((Map)value);
		}

		Class<?> clazz = value.getClass();

		if (clazz.isArray()) {
			StringBuilder sb = new StringBuilder("[");

			Object[] values = (Object[])value;

			for (int i = 0; i < values.length; i++) {
				sb.append(_toJSON(values[i]));

				if ((i + 1) < values.length) {
					sb.append(", ");
				}
			}

			sb.append("]");

			return sb.toString();
		}

		if (value instanceof String) {
			return "\"" + _escape(value) + "\"";
		}

		return String.valueOf(value);
	}

}