/**
 * SPDX-FileCopyrightText: (c) 2024 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.headless.admin.site.client.serdes.v1_0;

import com.liferay.headless.admin.site.client.dto.v1_0.Mapping;
import com.liferay.headless.admin.site.client.json.BaseJSONParser;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

import javax.annotation.Generated;

/**
 * @author Rubén Pulido
 * @generated
 */
@Generated("")
public class MappingSerDes {

	public static Mapping toDTO(String json) {
		MappingJSONParser mappingJSONParser = new MappingJSONParser();

		return mappingJSONParser.parseToDTO(json);
	}

	public static Mapping[] toDTOs(String json) {
		MappingJSONParser mappingJSONParser = new MappingJSONParser();

		return mappingJSONParser.parseToDTOs(json);
	}

	public static String toJSON(Mapping mapping) {
		if (mapping == null) {
			return "null";
		}

		StringBuilder sb = new StringBuilder();

		sb.append("{");

		if (mapping.getFieldKey() != null) {
			if (sb.length() > 1) {
				sb.append(", ");
			}

			sb.append("\"fieldKey\": ");

			sb.append("\"");

			sb.append(_escape(mapping.getFieldKey()));

			sb.append("\"");
		}

		if (mapping.getItemReference() != null) {
			if (sb.length() > 1) {
				sb.append(", ");
			}

			sb.append("\"itemReference\": ");

			if (mapping.getItemReference() instanceof String) {
				sb.append("\"");
				sb.append((String)mapping.getItemReference());
				sb.append("\"");
			}
			else {
				sb.append(mapping.getItemReference());
			}
		}

		sb.append("}");

		return sb.toString();
	}

	public static Map<String, Object> toMap(String json) {
		MappingJSONParser mappingJSONParser = new MappingJSONParser();

		return mappingJSONParser.parseToMap(json);
	}

	public static Map<String, String> toMap(Mapping mapping) {
		if (mapping == null) {
			return null;
		}

		Map<String, String> map = new TreeMap<>();

		if (mapping.getFieldKey() == null) {
			map.put("fieldKey", null);
		}
		else {
			map.put("fieldKey", String.valueOf(mapping.getFieldKey()));
		}

		if (mapping.getItemReference() == null) {
			map.put("itemReference", null);
		}
		else {
			map.put(
				"itemReference", String.valueOf(mapping.getItemReference()));
		}

		return map;
	}

	public static class MappingJSONParser extends BaseJSONParser<Mapping> {

		@Override
		protected Mapping createDTO() {
			return new Mapping();
		}

		@Override
		protected Mapping[] createDTOArray(int size) {
			return new Mapping[size];
		}

		@Override
		protected boolean parseMaps(String jsonParserFieldName) {
			if (Objects.equals(jsonParserFieldName, "fieldKey")) {
				return false;
			}
			else if (Objects.equals(jsonParserFieldName, "itemReference")) {
				return false;
			}

			return false;
		}

		@Override
		protected void setField(
			Mapping mapping, String jsonParserFieldName,
			Object jsonParserFieldValue) {

			if (Objects.equals(jsonParserFieldName, "fieldKey")) {
				if (jsonParserFieldValue != null) {
					mapping.setFieldKey((String)jsonParserFieldValue);
				}
			}
			else if (Objects.equals(jsonParserFieldName, "itemReference")) {
				if (jsonParserFieldValue != null) {
					mapping.setItemReference((Object)jsonParserFieldValue);
				}
			}
		}

	}

	private static String _escape(Object object) {
		String string = String.valueOf(object);

		for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
			string = string.replace(strings[0], strings[1]);
		}

		return string;
	}

	private static String _toJSON(Map<String, ?> map) {
		StringBuilder sb = new StringBuilder("{");

		@SuppressWarnings("unchecked")
		Set set = map.entrySet();

		@SuppressWarnings("unchecked")
		Iterator<Map.Entry<String, ?>> iterator = set.iterator();

		while (iterator.hasNext()) {
			Map.Entry<String, ?> entry = iterator.next();

			sb.append("\"");
			sb.append(entry.getKey());
			sb.append("\": ");

			Object value = entry.getValue();

			sb.append(_toJSON(value));

			if (iterator.hasNext()) {
				sb.append(", ");
			}
		}

		sb.append("}");

		return sb.toString();
	}

	private static String _toJSON(Object value) {
		if (value instanceof Map) {
			return _toJSON((Map)value);
		}

		Class<?> clazz = value.getClass();

		if (clazz.isArray()) {
			StringBuilder sb = new StringBuilder("[");

			Object[] values = (Object[])value;

			for (int i = 0; i < values.length; i++) {
				sb.append(_toJSON(values[i]));

				if ((i + 1) < values.length) {
					sb.append(", ");
				}
			}

			sb.append("]");

			return sb.toString();
		}

		if (value instanceof String) {
			return "\"" + _escape(value) + "\"";
		}

		return String.valueOf(value);
	}

}