/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.headless.admin.site.client.serdes.v1_0;

import com.liferay.headless.admin.site.client.dto.v1_0.FormStepPageElementDefinition;
import com.liferay.headless.admin.site.client.json.BaseJSONParser;

import jakarta.annotation.Generated;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

/**
 * @author Rubén Pulido
 * @generated
 */
@Generated("")
public class FormStepPageElementDefinitionSerDes {

	public static FormStepPageElementDefinition toDTO(String json) {
		FormStepPageElementDefinitionJSONParser
			formStepPageElementDefinitionJSONParser =
				new FormStepPageElementDefinitionJSONParser();

		return formStepPageElementDefinitionJSONParser.parseToDTO(json);
	}

	public static FormStepPageElementDefinition[] toDTOs(String json) {
		FormStepPageElementDefinitionJSONParser
			formStepPageElementDefinitionJSONParser =
				new FormStepPageElementDefinitionJSONParser();

		return formStepPageElementDefinitionJSONParser.parseToDTOs(json);
	}

	public static String toJSON(
		FormStepPageElementDefinition formStepPageElementDefinition) {

		if (formStepPageElementDefinition == null) {
			return "null";
		}

		StringBuilder sb = new StringBuilder();

		sb.append("{");

		if (formStepPageElementDefinition.getFormStepConfig() != null) {
			if (sb.length() > 1) {
				sb.append(", ");
			}

			sb.append("\"formStepConfig\": ");

			if (formStepPageElementDefinition.getFormStepConfig() instanceof
					String) {

				sb.append("\"");
				sb.append(
					(String)formStepPageElementDefinition.getFormStepConfig());
				sb.append("\"");
			}
			else {
				sb.append(formStepPageElementDefinition.getFormStepConfig());
			}
		}

		if (formStepPageElementDefinition.getType() != null) {
			if (sb.length() > 1) {
				sb.append(", ");
			}

			sb.append("\"type\": ");

			sb.append("\"");
			sb.append(formStepPageElementDefinition.getType());
			sb.append("\"");
		}

		sb.append("}");

		return sb.toString();
	}

	public static Map<String, Object> toMap(String json) {
		FormStepPageElementDefinitionJSONParser
			formStepPageElementDefinitionJSONParser =
				new FormStepPageElementDefinitionJSONParser();

		return formStepPageElementDefinitionJSONParser.parseToMap(json);
	}

	public static Map<String, String> toMap(
		FormStepPageElementDefinition formStepPageElementDefinition) {

		if (formStepPageElementDefinition == null) {
			return null;
		}

		Map<String, String> map = new TreeMap<>();

		if (formStepPageElementDefinition.getFormStepConfig() == null) {
			map.put("formStepConfig", null);
		}
		else {
			map.put(
				"formStepConfig",
				String.valueOf(
					formStepPageElementDefinition.getFormStepConfig()));
		}

		if (formStepPageElementDefinition.getType() == null) {
			map.put("type", null);
		}
		else {
			map.put(
				"type",
				String.valueOf(formStepPageElementDefinition.getType()));
		}

		return map;
	}

	public static class FormStepPageElementDefinitionJSONParser
		extends BaseJSONParser<FormStepPageElementDefinition> {

		@Override
		protected FormStepPageElementDefinition createDTO() {
			return new FormStepPageElementDefinition();
		}

		@Override
		protected FormStepPageElementDefinition[] createDTOArray(int size) {
			return new FormStepPageElementDefinition[size];
		}

		@Override
		protected boolean parseMaps(String jsonParserFieldName) {
			if (Objects.equals(jsonParserFieldName, "formStepConfig")) {
				return false;
			}
			else if (Objects.equals(jsonParserFieldName, "type")) {
				return false;
			}

			return false;
		}

		@Override
		protected void setField(
			FormStepPageElementDefinition formStepPageElementDefinition,
			String jsonParserFieldName, Object jsonParserFieldValue) {

			if (Objects.equals(jsonParserFieldName, "formStepConfig")) {
				if (jsonParserFieldValue != null) {
					formStepPageElementDefinition.setFormStepConfig(
						(Object)jsonParserFieldValue);
				}
			}
			else if (Objects.equals(jsonParserFieldName, "type")) {
				if (jsonParserFieldValue != null) {
					formStepPageElementDefinition.setType(
						FormStepPageElementDefinition.Type.create(
							(String)jsonParserFieldValue));
				}
			}
		}

	}

	private static String _escape(Object object) {
		String string = String.valueOf(object);

		for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
			string = string.replace(strings[0], strings[1]);
		}

		return string;
	}

	private static String _toJSON(Map<String, ?> map) {
		StringBuilder sb = new StringBuilder("{");

		@SuppressWarnings("unchecked")
		Set set = map.entrySet();

		@SuppressWarnings("unchecked")
		Iterator<Map.Entry<String, ?>> iterator = set.iterator();

		while (iterator.hasNext()) {
			Map.Entry<String, ?> entry = iterator.next();

			sb.append("\"");
			sb.append(entry.getKey());
			sb.append("\": ");

			Object value = entry.getValue();

			sb.append(_toJSON(value));

			if (iterator.hasNext()) {
				sb.append(", ");
			}
		}

		sb.append("}");

		return sb.toString();
	}

	private static String _toJSON(Object value) {
		if (value == null) {
			return "null";
		}

		if (value instanceof Map) {
			return _toJSON((Map)value);
		}

		Class<?> clazz = value.getClass();

		if (clazz.isArray()) {
			StringBuilder sb = new StringBuilder("[");

			Object[] values = (Object[])value;

			for (int i = 0; i < values.length; i++) {
				sb.append(_toJSON(values[i]));

				if ((i + 1) < values.length) {
					sb.append(", ");
				}
			}

			sb.append("]");

			return sb.toString();
		}

		if (value instanceof String) {
			return "\"" + _escape(value) + "\"";
		}

		return String.valueOf(value);
	}

}