/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.headless.admin.site.client.dto.v1_0;

import com.liferay.headless.admin.site.client.function.UnsafeSupplier;
import com.liferay.headless.admin.site.client.serdes.v1_0.CheckboxFragmentConfigurationFieldValueSerDes;

import jakarta.annotation.Generated;

import java.io.Serializable;

import java.util.Map;
import java.util.Objects;

/**
 * @author Rubén Pulido
 * @generated
 */
@Generated("")
public class CheckboxFragmentConfigurationFieldValue
	extends FragmentConfigurationFieldValue implements Cloneable, Serializable {

	public static CheckboxFragmentConfigurationFieldValue toDTO(String json) {
		return CheckboxFragmentConfigurationFieldValueSerDes.toDTO(json);
	}

	public Boolean getValue() {
		return value;
	}

	public void setValue(Boolean value) {
		this.value = value;
	}

	public void setValue(
		UnsafeSupplier<Boolean, Exception> valueUnsafeSupplier) {

		try {
			value = valueUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected Boolean value;

	public Map<String, Boolean> getValue_i18n() {
		return value_i18n;
	}

	public void setValue_i18n(Map<String, Boolean> value_i18n) {
		this.value_i18n = value_i18n;
	}

	public void setValue_i18n(
		UnsafeSupplier<Map<String, Boolean>, Exception>
			value_i18nUnsafeSupplier) {

		try {
			value_i18n = value_i18nUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected Map<String, Boolean> value_i18n;

	@Override
	public CheckboxFragmentConfigurationFieldValue clone()
		throws CloneNotSupportedException {

		return (CheckboxFragmentConfigurationFieldValue)super.clone();
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CheckboxFragmentConfigurationFieldValue)) {
			return false;
		}

		CheckboxFragmentConfigurationFieldValue
			checkboxFragmentConfigurationFieldValue =
				(CheckboxFragmentConfigurationFieldValue)object;

		return Objects.equals(
			toString(), checkboxFragmentConfigurationFieldValue.toString());
	}

	@Override
	public int hashCode() {
		String string = toString();

		return string.hashCode();
	}

	public String toString() {
		return CheckboxFragmentConfigurationFieldValueSerDes.toJSON(this);
	}

}