/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.headless.admin.site.client.serdes.v1_0;

import com.liferay.headless.admin.site.client.dto.v1_0.HrefURLValue;
import com.liferay.headless.admin.site.client.json.BaseJSONParser;

import jakarta.annotation.Generated;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

/**
 * @author Rubén Pulido
 * @generated
 */
@Generated("")
public class HrefURLValueSerDes {

	public static HrefURLValue toDTO(String json) {
		HrefURLValueJSONParser hrefURLValueJSONParser =
			new HrefURLValueJSONParser();

		return hrefURLValueJSONParser.parseToDTO(json);
	}

	public static HrefURLValue[] toDTOs(String json) {
		HrefURLValueJSONParser hrefURLValueJSONParser =
			new HrefURLValueJSONParser();

		return hrefURLValueJSONParser.parseToDTOs(json);
	}

	public static String toJSON(HrefURLValue hrefURLValue) {
		if (hrefURLValue == null) {
			return "null";
		}

		StringBuilder sb = new StringBuilder();

		sb.append("{");

		if (hrefURLValue.getHref() != null) {
			if (sb.length() > 1) {
				sb.append(", ");
			}

			sb.append("\"href\": ");

			sb.append("\"");

			sb.append(_escape(hrefURLValue.getHref()));

			sb.append("\"");
		}

		if (hrefURLValue.getUrlType() != null) {
			if (sb.length() > 1) {
				sb.append(", ");
			}

			sb.append("\"urlType\": ");

			sb.append("\"");

			sb.append(hrefURLValue.getUrlType());

			sb.append("\"");
		}

		sb.append("}");

		return sb.toString();
	}

	public static Map<String, Object> toMap(String json) {
		HrefURLValueJSONParser hrefURLValueJSONParser =
			new HrefURLValueJSONParser();

		return hrefURLValueJSONParser.parseToMap(json);
	}

	public static Map<String, String> toMap(HrefURLValue hrefURLValue) {
		if (hrefURLValue == null) {
			return null;
		}

		Map<String, String> map = new TreeMap<>();

		if (hrefURLValue.getHref() == null) {
			map.put("href", null);
		}
		else {
			map.put("href", String.valueOf(hrefURLValue.getHref()));
		}

		if (hrefURLValue.getUrlType() == null) {
			map.put("urlType", null);
		}
		else {
			map.put("urlType", String.valueOf(hrefURLValue.getUrlType()));
		}

		return map;
	}

	public static class HrefURLValueJSONParser
		extends BaseJSONParser<HrefURLValue> {

		@Override
		protected HrefURLValue createDTO() {
			return new HrefURLValue();
		}

		@Override
		protected HrefURLValue[] createDTOArray(int size) {
			return new HrefURLValue[size];
		}

		@Override
		protected boolean parseMaps(String jsonParserFieldName) {
			if (Objects.equals(jsonParserFieldName, "href")) {
				return false;
			}
			else if (Objects.equals(jsonParserFieldName, "urlType")) {
				return false;
			}

			return false;
		}

		@Override
		protected void setField(
			HrefURLValue hrefURLValue, String jsonParserFieldName,
			Object jsonParserFieldValue) {

			if (Objects.equals(jsonParserFieldName, "href")) {
				if (jsonParserFieldValue != null) {
					hrefURLValue.setHref((String)jsonParserFieldValue);
				}
			}
			else if (Objects.equals(jsonParserFieldName, "urlType")) {
				if (jsonParserFieldValue != null) {
					hrefURLValue.setUrlType(
						HrefURLValue.UrlType.create(
							(String)jsonParserFieldValue));
				}
			}
		}

	}

	private static String _escape(Object object) {
		String string = String.valueOf(object);

		for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
			string = string.replace(strings[0], strings[1]);
		}

		return string;
	}

	private static String _toJSON(Map<String, ?> map) {
		StringBuilder sb = new StringBuilder("{");

		@SuppressWarnings("unchecked")
		Set set = map.entrySet();

		@SuppressWarnings("unchecked")
		Iterator<Map.Entry<String, ?>> iterator = set.iterator();

		while (iterator.hasNext()) {
			Map.Entry<String, ?> entry = iterator.next();

			sb.append("\"");
			sb.append(entry.getKey());
			sb.append("\": ");

			Object value = entry.getValue();

			sb.append(_toJSON(value));

			if (iterator.hasNext()) {
				sb.append(", ");
			}
		}

		sb.append("}");

		return sb.toString();
	}

	private static String _toJSON(Object value) {
		if (value == null) {
			return "null";
		}

		if (value instanceof Map) {
			return _toJSON((Map)value);
		}

		Class<?> clazz = value.getClass();

		if (clazz.isArray()) {
			StringBuilder sb = new StringBuilder("[");

			Object[] values = (Object[])value;

			for (int i = 0; i < values.length; i++) {
				sb.append(_toJSON(values[i]));

				if ((i + 1) < values.length) {
					sb.append(", ");
				}
			}

			sb.append("]");

			return sb.toString();
		}

		if (value instanceof String) {
			return "\"" + _escape(value) + "\"";
		}

		return String.valueOf(value);
	}

}