/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.PageTemplateSet;
import com.liferay.headless.admin.site.dto.v1_0.PageTemplateSettings;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageTemplate;
import com.liferay.headless.admin.taxonomy.dto.v1_0.Keyword;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(value="PageTemplate")
@JsonFilter(value="Liferay.Vulcan")
@JsonSubTypes(value={@JsonSubTypes.Type(name="ContentPageTemplate", value=ContentPageTemplate.class), @JsonSubTypes.Type(name="WidgetPageTemplate", value=WidgetPageTemplate.class)})
@JsonTypeInfo(include=JsonTypeInfo.As.PROPERTY, property="type", use=JsonTypeInfo.Id.NAME, visible=true)
@XmlRootElement(name="PageTemplate")
public abstract class PageTemplate
implements Serializable {
    @GraphQLField(description="The page template's creator. It is not returned by default. It can be embedded via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The page template's creator. It is not returned by default. It can be embedded via nestedFields.") Creator creator;
    @JsonIgnore
    private Supplier<Creator> _creatorSupplier;
    @GraphQLField(description="The page's creator external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page's creator external reference code.") String creatorExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _creatorExternalReferenceCodeSupplier;
    @GraphQLField(description="The page template's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page template's creation date.") Date dateCreated;
    @JsonIgnore
    private Supplier<Date> _dateCreatedSupplier;
    @GraphQLField(description="The last time the page template changed.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The last time the page template changed.") Date dateModified;
    @JsonIgnore
    private Supplier<Date> _dateModifiedSupplier;
    @GraphQLField(description="The last time the page template was published.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The last time the page template was published.") Date datePublished;
    @JsonIgnore
    private Supplier<Date> _datePublishedSupplier;
    @GraphQLField(description="The page template's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page template's external reference code.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="The page template's key.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page template's key.") String key;
    @JsonIgnore
    private Supplier<String> _keySupplier;
    @GraphQLField(description="The external references to the associated keywords.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The external references to the associated keywords.") ItemExternalReference[] keywordItemExternalReferences;
    @JsonIgnore
    private Supplier<ItemExternalReference[]> _keywordItemExternalReferencesSupplier;
    @GraphQLField(description="The associated keywords. They are not returned by default. They can be embedded via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The associated keywords. They are not returned by default. They can be embedded via nestedFields.") Keyword[] keywords;
    @JsonIgnore
    private Supplier<Keyword[]> _keywordsSupplier;
    @GraphQLField(description="The page template's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page template's name.") String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField(description="The page template's specifications. A page template of type content will contain 1 page specifications for its draft layout and 1 page specifications for its published layout. A page template of type widget contains only 1 page specification for its published layout. This field is not returned by default. It can be requested via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page template's specifications. A page template of type content will contain 1 page specifications for its draft layout and 1 page specifications for its published layout. A page template of type widget contains only 1 page specification for its published layout. This field is not returned by default. It can be requested via nestedFields.") PageSpecification[] pageSpecifications;
    @JsonIgnore
    private Supplier<PageSpecification[]> _pageSpecificationsSupplier;
    @GraphQLField(description="The page template's set.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page template's set.") PageTemplateSet pageTemplateSet;
    @JsonIgnore
    private Supplier<PageTemplateSet> _pageTemplateSetSupplier;
    @GraphQLField(description="The settings of the page template.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The settings of the page template.") PageTemplateSettings pageTemplateSettings;
    @JsonIgnore
    private Supplier<PageTemplateSettings> _pageTemplateSettingsSupplier;
    @GraphQLField(description="The associated categories. They are not returned by default. They can be embedded via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The associated categories. They are not returned by default. They can be embedded via nestedFields.") TaxonomyCategory[] taxonomyCategories;
    @JsonIgnore
    private Supplier<TaxonomyCategory[]> _taxonomyCategoriesSupplier;
    @GraphQLField(description="The external references to the associated categories.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The external references to the associated categories.") ItemExternalReference[] taxonomyCategoryItemExternalReferences;
    @JsonIgnore
    private Supplier<ItemExternalReference[]> _taxonomyCategoryItemExternalReferencesSupplier;
    @GraphQLField(description="The type of the page template.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The type of the page template.") Type type;
    @JsonIgnore
    private Supplier<Type> _typeSupplier;
    @GraphQLField(description="A valid external identifier to reference this page template.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A valid external identifier to reference this page template.") String uuid;
    @JsonIgnore
    private Supplier<String> _uuidSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.PageTemplate", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static PageTemplate toDTO(String json) {
        return (PageTemplate)ObjectMapperUtil.readValue(PageTemplate.class, (String)json);
    }

    public static PageTemplate unsafeToDTO(String json) {
        return (PageTemplate)ObjectMapperUtil.unsafeReadValue(PageTemplate.class, (String)json);
    }

    @Schema(description="The page template's creator. It is not returned by default. It can be embedded via nestedFields.")
    @Valid
    public Creator getCreator() {
        if (this._creatorSupplier != null) {
            this.creator = this._creatorSupplier.get();
            this._creatorSupplier = null;
        }
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
        this._creatorSupplier = null;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        this._creatorSupplier = () -> {
            try {
                return (Creator)creatorUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page's creator external reference code.")
    public String getCreatorExternalReferenceCode() {
        if (this._creatorExternalReferenceCodeSupplier != null) {
            this.creatorExternalReferenceCode = this._creatorExternalReferenceCodeSupplier.get();
            this._creatorExternalReferenceCodeSupplier = null;
        }
        return this.creatorExternalReferenceCode;
    }

    public void setCreatorExternalReferenceCode(String creatorExternalReferenceCode) {
        this.creatorExternalReferenceCode = creatorExternalReferenceCode;
        this._creatorExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setCreatorExternalReferenceCode(UnsafeSupplier<String, Exception> creatorExternalReferenceCodeUnsafeSupplier) {
        this._creatorExternalReferenceCodeSupplier = () -> {
            try {
                return (String)creatorExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page template's creation date.")
    public Date getDateCreated() {
        if (this._dateCreatedSupplier != null) {
            this.dateCreated = this._dateCreatedSupplier.get();
            this._dateCreatedSupplier = null;
        }
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this._dateCreatedSupplier = null;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        this._dateCreatedSupplier = () -> {
            try {
                return (Date)dateCreatedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The last time the page template changed.")
    public Date getDateModified() {
        if (this._dateModifiedSupplier != null) {
            this.dateModified = this._dateModifiedSupplier.get();
            this._dateModifiedSupplier = null;
        }
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
        this._dateModifiedSupplier = null;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        this._dateModifiedSupplier = () -> {
            try {
                return (Date)dateModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The last time the page template was published.")
    public Date getDatePublished() {
        if (this._datePublishedSupplier != null) {
            this.datePublished = this._datePublishedSupplier.get();
            this._datePublishedSupplier = null;
        }
        return this.datePublished;
    }

    public void setDatePublished(Date datePublished) {
        this.datePublished = datePublished;
        this._datePublishedSupplier = null;
    }

    @JsonIgnore
    public void setDatePublished(UnsafeSupplier<Date, Exception> datePublishedUnsafeSupplier) {
        this._datePublishedSupplier = () -> {
            try {
                return (Date)datePublishedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page template's external reference code.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page template's key.")
    public String getKey() {
        if (this._keySupplier != null) {
            this.key = this._keySupplier.get();
            this._keySupplier = null;
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this._keySupplier = null;
    }

    @JsonIgnore
    public void setKey(UnsafeSupplier<String, Exception> keyUnsafeSupplier) {
        this._keySupplier = () -> {
            try {
                return (String)keyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The external references to the associated keywords.")
    @Valid
    public ItemExternalReference[] getKeywordItemExternalReferences() {
        if (this._keywordItemExternalReferencesSupplier != null) {
            this.keywordItemExternalReferences = this._keywordItemExternalReferencesSupplier.get();
            this._keywordItemExternalReferencesSupplier = null;
        }
        return this.keywordItemExternalReferences;
    }

    public void setKeywordItemExternalReferences(ItemExternalReference[] keywordItemExternalReferences) {
        this.keywordItemExternalReferences = keywordItemExternalReferences;
        this._keywordItemExternalReferencesSupplier = null;
    }

    @JsonIgnore
    public void setKeywordItemExternalReferences(UnsafeSupplier<ItemExternalReference[], Exception> keywordItemExternalReferencesUnsafeSupplier) {
        this._keywordItemExternalReferencesSupplier = () -> {
            try {
                return (ItemExternalReference[])keywordItemExternalReferencesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The associated keywords. They are not returned by default. They can be embedded via nestedFields.")
    @Valid
    public Keyword[] getKeywords() {
        if (this._keywordsSupplier != null) {
            this.keywords = this._keywordsSupplier.get();
            this._keywordsSupplier = null;
        }
        return this.keywords;
    }

    public void setKeywords(Keyword[] keywords) {
        this.keywords = keywords;
        this._keywordsSupplier = null;
    }

    @JsonIgnore
    public void setKeywords(UnsafeSupplier<Keyword[], Exception> keywordsUnsafeSupplier) {
        this._keywordsSupplier = () -> {
            try {
                return (Keyword[])keywordsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page template's name.")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page template's specifications. A page template of type content will contain 1 page specifications for its draft layout and 1 page specifications for its published layout. A page template of type widget contains only 1 page specification for its published layout. This field is not returned by default. It can be requested via nestedFields.")
    @Valid
    public PageSpecification[] getPageSpecifications() {
        if (this._pageSpecificationsSupplier != null) {
            this.pageSpecifications = this._pageSpecificationsSupplier.get();
            this._pageSpecificationsSupplier = null;
        }
        return this.pageSpecifications;
    }

    public void setPageSpecifications(PageSpecification[] pageSpecifications) {
        this.pageSpecifications = pageSpecifications;
        this._pageSpecificationsSupplier = null;
    }

    @JsonIgnore
    public void setPageSpecifications(UnsafeSupplier<PageSpecification[], Exception> pageSpecificationsUnsafeSupplier) {
        this._pageSpecificationsSupplier = () -> {
            try {
                return (PageSpecification[])pageSpecificationsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page template's set.")
    @Valid
    public PageTemplateSet getPageTemplateSet() {
        if (this._pageTemplateSetSupplier != null) {
            this.pageTemplateSet = this._pageTemplateSetSupplier.get();
            this._pageTemplateSetSupplier = null;
        }
        return this.pageTemplateSet;
    }

    public void setPageTemplateSet(PageTemplateSet pageTemplateSet) {
        this.pageTemplateSet = pageTemplateSet;
        this._pageTemplateSetSupplier = null;
    }

    @JsonIgnore
    public void setPageTemplateSet(UnsafeSupplier<PageTemplateSet, Exception> pageTemplateSetUnsafeSupplier) {
        this._pageTemplateSetSupplier = () -> {
            try {
                return (PageTemplateSet)pageTemplateSetUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The settings of the page template.")
    @Valid
    public PageTemplateSettings getPageTemplateSettings() {
        if (this._pageTemplateSettingsSupplier != null) {
            this.pageTemplateSettings = this._pageTemplateSettingsSupplier.get();
            this._pageTemplateSettingsSupplier = null;
        }
        return this.pageTemplateSettings;
    }

    public void setPageTemplateSettings(PageTemplateSettings pageTemplateSettings) {
        this.pageTemplateSettings = pageTemplateSettings;
        this._pageTemplateSettingsSupplier = null;
    }

    @JsonIgnore
    public void setPageTemplateSettings(UnsafeSupplier<PageTemplateSettings, Exception> pageTemplateSettingsUnsafeSupplier) {
        this._pageTemplateSettingsSupplier = () -> {
            try {
                return (PageTemplateSettings)pageTemplateSettingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The associated categories. They are not returned by default. They can be embedded via nestedFields.")
    @Valid
    public TaxonomyCategory[] getTaxonomyCategories() {
        if (this._taxonomyCategoriesSupplier != null) {
            this.taxonomyCategories = this._taxonomyCategoriesSupplier.get();
            this._taxonomyCategoriesSupplier = null;
        }
        return this.taxonomyCategories;
    }

    public void setTaxonomyCategories(TaxonomyCategory[] taxonomyCategories) {
        this.taxonomyCategories = taxonomyCategories;
        this._taxonomyCategoriesSupplier = null;
    }

    @JsonIgnore
    public void setTaxonomyCategories(UnsafeSupplier<TaxonomyCategory[], Exception> taxonomyCategoriesUnsafeSupplier) {
        this._taxonomyCategoriesSupplier = () -> {
            try {
                return (TaxonomyCategory[])taxonomyCategoriesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The external references to the associated categories.")
    @Valid
    public ItemExternalReference[] getTaxonomyCategoryItemExternalReferences() {
        if (this._taxonomyCategoryItemExternalReferencesSupplier != null) {
            this.taxonomyCategoryItemExternalReferences = this._taxonomyCategoryItemExternalReferencesSupplier.get();
            this._taxonomyCategoryItemExternalReferencesSupplier = null;
        }
        return this.taxonomyCategoryItemExternalReferences;
    }

    public void setTaxonomyCategoryItemExternalReferences(ItemExternalReference[] taxonomyCategoryItemExternalReferences) {
        this.taxonomyCategoryItemExternalReferences = taxonomyCategoryItemExternalReferences;
        this._taxonomyCategoryItemExternalReferencesSupplier = null;
    }

    @JsonIgnore
    public void setTaxonomyCategoryItemExternalReferences(UnsafeSupplier<ItemExternalReference[], Exception> taxonomyCategoryItemExternalReferencesUnsafeSupplier) {
        this._taxonomyCategoryItemExternalReferencesSupplier = () -> {
            try {
                return (ItemExternalReference[])taxonomyCategoryItemExternalReferencesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The type of the page template.")
    @JsonGetter(value="type")
    @Valid
    public Type getType() {
        if (this._typeSupplier != null) {
            this.type = this._typeSupplier.get();
            this._typeSupplier = null;
        }
        return this.type;
    }

    @JsonIgnore
    public String getTypeAsString() {
        Type type = this.getType();
        if (type == null) {
            return null;
        }
        return type.toString();
    }

    public void setType(Type type) {
        this.type = type;
        this._typeSupplier = null;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<Type, Exception> typeUnsafeSupplier) {
        this._typeSupplier = () -> {
            try {
                return (Type)((Object)((Object)typeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A valid external identifier to reference this page template.")
    public String getUuid() {
        if (this._uuidSupplier != null) {
            this.uuid = this._uuidSupplier.get();
            this._uuidSupplier = null;
        }
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
        this._uuidSupplier = null;
    }

    @JsonIgnore
    public void setUuid(UnsafeSupplier<String, Exception> uuidUnsafeSupplier) {
        this._uuidSupplier = () -> {
            try {
                return (String)uuidUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PageTemplate)) {
            return false;
        }
        PageTemplate pageTemplate = (PageTemplate)object;
        return Objects.equals(this.toString(), pageTemplate.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String uuid;
        Type type;
        ItemExternalReference[] taxonomyCategoryItemExternalReferences;
        TaxonomyCategory[] taxonomyCategories;
        PageTemplateSettings pageTemplateSettings;
        PageTemplateSet pageTemplateSet;
        PageSpecification[] pageSpecifications;
        String name;
        Keyword[] keywords;
        ItemExternalReference[] keywordItemExternalReferences;
        String key;
        String externalReferenceCode;
        Date datePublished;
        Date dateModified;
        Date dateCreated;
        String creatorExternalReferenceCode;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Creator creator = this.getCreator();
        if (creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append((Object)creator);
        }
        if ((creatorExternalReferenceCode = this.getCreatorExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creatorExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(PageTemplate._escape(creatorExternalReferenceCode));
            sb.append("\"");
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((datePublished = this.getDatePublished()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"datePublished\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(datePublished));
            sb.append("\"");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(PageTemplate._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((key = this.getKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"key\": ");
            sb.append("\"");
            sb.append(PageTemplate._escape(key));
            sb.append("\"");
        }
        if ((keywordItemExternalReferences = this.getKeywordItemExternalReferences()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywordItemExternalReferences\": ");
            sb.append("[");
            for (int i = 0; i < keywordItemExternalReferences.length; ++i) {
                sb.append(String.valueOf(keywordItemExternalReferences[i]));
                if (i + 1 >= keywordItemExternalReferences.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((keywords = this.getKeywords()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywords\": ");
            sb.append("[");
            for (int i = 0; i < keywords.length; ++i) {
                sb.append((Object)keywords[i]);
                if (i + 1 >= keywords.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(PageTemplate._escape(name));
            sb.append("\"");
        }
        if ((pageSpecifications = this.getPageSpecifications()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageSpecifications\": ");
            sb.append("[");
            for (int i = 0; i < pageSpecifications.length; ++i) {
                sb.append(String.valueOf(pageSpecifications[i]));
                if (i + 1 >= pageSpecifications.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((pageTemplateSet = this.getPageTemplateSet()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageTemplateSet\": ");
            sb.append(String.valueOf(pageTemplateSet));
        }
        if ((pageTemplateSettings = this.getPageTemplateSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageTemplateSettings\": ");
            sb.append(String.valueOf(pageTemplateSettings));
        }
        if ((taxonomyCategories = this.getTaxonomyCategories()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategories\": ");
            sb.append("[");
            for (int i = 0; i < taxonomyCategories.length; ++i) {
                sb.append((Object)taxonomyCategories[i]);
                if (i + 1 >= taxonomyCategories.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((taxonomyCategoryItemExternalReferences = this.getTaxonomyCategoryItemExternalReferences()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryItemExternalReferences\": ");
            sb.append("[");
            for (int i = 0; i < taxonomyCategoryItemExternalReferences.length; ++i) {
                sb.append(String.valueOf(taxonomyCategoryItemExternalReferences[i]));
                if (i + 1 >= taxonomyCategoryItemExternalReferences.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((type = this.getType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append((Object)type);
            sb.append("\"");
        }
        if ((uuid = this.getUuid()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"uuid\": ");
            sb.append("\"");
            sb.append(PageTemplate._escape(uuid));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(PageTemplate._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (PageTemplate._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(PageTemplate._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(PageTemplate._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(PageTemplate._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="Type")
    public static enum Type {
        CONTENT_PAGE_TEMPLATE("ContentPageTemplate"),
        WIDGET_PAGE_TEMPLATE("WidgetPageTemplate");

        private final String _value;

        @JsonCreator
        public static Type create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Type type : Type.values()) {
                if (!Objects.equals(type.getValue(), value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Type(String value) {
            this._value = value;
        }
    }
}

