/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="The widget page template's site navigation menu settings.", value="NavigationMenuSettings")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="NavigationMenuSettings")
public class NavigationMenuSettings
implements Serializable {
    @GraphQLField(description="The page's description to be used as summary for search engines.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page's description to be used as summary for search engines.") String target;
    @JsonIgnore
    private Supplier<String> _targetSupplier;
    @GraphQLField(description="The target's type (specific frame or new tab).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The target's type (specific frame or new tab).") TargetType targetType;
    @JsonIgnore
    private Supplier<TargetType> _targetTypeSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.NavigationMenuSettings", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static NavigationMenuSettings toDTO(String json) {
        return (NavigationMenuSettings)ObjectMapperUtil.readValue(NavigationMenuSettings.class, (String)json);
    }

    public static NavigationMenuSettings unsafeToDTO(String json) {
        return (NavigationMenuSettings)ObjectMapperUtil.unsafeReadValue(NavigationMenuSettings.class, (String)json);
    }

    @Schema(description="The page's description to be used as summary for search engines.")
    public String getTarget() {
        if (this._targetSupplier != null) {
            this.target = this._targetSupplier.get();
            this._targetSupplier = null;
        }
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        this._targetSupplier = null;
    }

    @JsonIgnore
    public void setTarget(UnsafeSupplier<String, Exception> targetUnsafeSupplier) {
        this._targetSupplier = () -> {
            try {
                return (String)targetUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @JsonGetter(value="targetType")
    @Schema(description="The target's type (specific frame or new tab).")
    @Valid
    public TargetType getTargetType() {
        if (this._targetTypeSupplier != null) {
            this.targetType = this._targetTypeSupplier.get();
            this._targetTypeSupplier = null;
        }
        return this.targetType;
    }

    @JsonIgnore
    public String getTargetTypeAsString() {
        TargetType targetType = this.getTargetType();
        if (targetType == null) {
            return null;
        }
        return targetType.toString();
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
        this._targetTypeSupplier = null;
    }

    @JsonIgnore
    public void setTargetType(UnsafeSupplier<TargetType, Exception> targetTypeUnsafeSupplier) {
        this._targetTypeSupplier = () -> {
            try {
                return (TargetType)((Object)((Object)targetTypeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NavigationMenuSettings)) {
            return false;
        }
        NavigationMenuSettings navigationMenuSettings = (NavigationMenuSettings)object;
        return Objects.equals(this.toString(), navigationMenuSettings.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        TargetType targetType;
        StringBundler sb = new StringBundler();
        sb.append("{");
        String target = this.getTarget();
        if (target != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"target\": ");
            sb.append("\"");
            sb.append(NavigationMenuSettings._escape(target));
            sb.append("\"");
        }
        if ((targetType = this.getTargetType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"targetType\": ");
            sb.append("\"");
            sb.append((Object)targetType);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(NavigationMenuSettings._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (NavigationMenuSettings._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(NavigationMenuSettings._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(NavigationMenuSettings._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(NavigationMenuSettings._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="TargetType")
    public static enum TargetType {
        SPECIFIC_FRAME("SpecificFrame"),
        NEW_TAB("NewTab");

        private final String _value;

        @JsonCreator
        public static TargetType create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (TargetType targetType : TargetType.values()) {
                if (!Objects.equals(targetType.getValue(), value)) continue;
                return targetType;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private TargetType(String value) {
            this._value = value;
        }
    }
}

