/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.UtilityPageSettings;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="The definition of a Utility Page.", value="UtilityPage")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="UtilityPage")
public class UtilityPage
implements Serializable {
    @GraphQLField(description="The utility page's creator. It is not returned by default. It can be embedded via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The utility page's creator. It is not returned by default. It can be embedded via nestedFields.") Creator creator;
    @JsonIgnore
    private Supplier<Creator> _creatorSupplier;
    @GraphQLField(description="The utility page's creator external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The utility page's creator external reference code.") String creatorExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _creatorExternalReferenceCodeSupplier;
    @GraphQLField(description="The utility page's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The utility page's creation date.") Date dateCreated;
    @JsonIgnore
    private Supplier<Date> _dateCreatedSupplier;
    @GraphQLField(description="The last time the utility page changed.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The last time the utility page changed.") Date dateModified;
    @JsonIgnore
    private Supplier<Date> _dateModifiedSupplier;
    @GraphQLField(description="The last time the utility page changed.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The last time the utility page changed.") Date datePublished;
    @JsonIgnore
    private Supplier<Date> _datePublishedSupplier;
    @GraphQLField(description="The utility page's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The utility page's external reference code.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="Specifies if the utility page should be the default for the given type.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Specifies if the utility page should be the default for the given type.") Boolean markedAsDefault;
    @JsonIgnore
    private Supplier<Boolean> _markedAsDefaultSupplier;
    @GraphQLField(description="The utility page's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The utility page's name.") String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField(description="The utility page's specifications. A utility page may contain 0 or 1 page specifications in draft status and 0 or 1 page specifications in published status.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The utility page's specifications. A utility page may contain 0 or 1 page specifications in draft status and 0 or 1 page specifications in published status.") PageSpecification[] pageSpecifications;
    @JsonIgnore
    private Supplier<PageSpecification[]> _pageSpecificationsSupplier;
    @GraphQLField(description="The utility page's thumbnail.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The utility page's thumbnail.") ItemExternalReference thumbnail;
    @JsonIgnore
    private Supplier<ItemExternalReference> _thumbnailSupplier;
    @GraphQLField(description="The utility page's type.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The utility page's type.") Type type;
    @JsonIgnore
    private Supplier<Type> _typeSupplier;
    @GraphQLField(description="Settings of the utility page.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Settings of the utility page.") UtilityPageSettings utilityPageSettings;
    @JsonIgnore
    private Supplier<UtilityPageSettings> _utilityPageSettingsSupplier;
    @GraphQLField(description="A valid external identifier to reference this utility page.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A valid external identifier to reference this utility page.") String uuid;
    @JsonIgnore
    private Supplier<String> _uuidSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.UtilityPage", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static UtilityPage toDTO(String json) {
        return (UtilityPage)ObjectMapperUtil.readValue(UtilityPage.class, (String)json);
    }

    public static UtilityPage unsafeToDTO(String json) {
        return (UtilityPage)ObjectMapperUtil.unsafeReadValue(UtilityPage.class, (String)json);
    }

    @Schema(description="The utility page's creator. It is not returned by default. It can be embedded via nestedFields.")
    @Valid
    public Creator getCreator() {
        if (this._creatorSupplier != null) {
            this.creator = this._creatorSupplier.get();
            this._creatorSupplier = null;
        }
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
        this._creatorSupplier = null;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        this._creatorSupplier = () -> {
            try {
                return (Creator)creatorUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The utility page's creator external reference code.")
    public String getCreatorExternalReferenceCode() {
        if (this._creatorExternalReferenceCodeSupplier != null) {
            this.creatorExternalReferenceCode = this._creatorExternalReferenceCodeSupplier.get();
            this._creatorExternalReferenceCodeSupplier = null;
        }
        return this.creatorExternalReferenceCode;
    }

    public void setCreatorExternalReferenceCode(String creatorExternalReferenceCode) {
        this.creatorExternalReferenceCode = creatorExternalReferenceCode;
        this._creatorExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setCreatorExternalReferenceCode(UnsafeSupplier<String, Exception> creatorExternalReferenceCodeUnsafeSupplier) {
        this._creatorExternalReferenceCodeSupplier = () -> {
            try {
                return (String)creatorExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The utility page's creation date.")
    public Date getDateCreated() {
        if (this._dateCreatedSupplier != null) {
            this.dateCreated = this._dateCreatedSupplier.get();
            this._dateCreatedSupplier = null;
        }
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this._dateCreatedSupplier = null;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        this._dateCreatedSupplier = () -> {
            try {
                return (Date)dateCreatedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The last time the utility page changed.")
    public Date getDateModified() {
        if (this._dateModifiedSupplier != null) {
            this.dateModified = this._dateModifiedSupplier.get();
            this._dateModifiedSupplier = null;
        }
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
        this._dateModifiedSupplier = null;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        this._dateModifiedSupplier = () -> {
            try {
                return (Date)dateModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The last time the utility page changed.")
    public Date getDatePublished() {
        if (this._datePublishedSupplier != null) {
            this.datePublished = this._datePublishedSupplier.get();
            this._datePublishedSupplier = null;
        }
        return this.datePublished;
    }

    public void setDatePublished(Date datePublished) {
        this.datePublished = datePublished;
        this._datePublishedSupplier = null;
    }

    @JsonIgnore
    public void setDatePublished(UnsafeSupplier<Date, Exception> datePublishedUnsafeSupplier) {
        this._datePublishedSupplier = () -> {
            try {
                return (Date)datePublishedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The utility page's external reference code.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Specifies if the utility page should be the default for the given type.")
    public Boolean getMarkedAsDefault() {
        if (this._markedAsDefaultSupplier != null) {
            this.markedAsDefault = this._markedAsDefaultSupplier.get();
            this._markedAsDefaultSupplier = null;
        }
        return this.markedAsDefault;
    }

    public void setMarkedAsDefault(Boolean markedAsDefault) {
        this.markedAsDefault = markedAsDefault;
        this._markedAsDefaultSupplier = null;
    }

    @JsonIgnore
    public void setMarkedAsDefault(UnsafeSupplier<Boolean, Exception> markedAsDefaultUnsafeSupplier) {
        this._markedAsDefaultSupplier = () -> {
            try {
                return (Boolean)markedAsDefaultUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The utility page's name.")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The utility page's specifications. A utility page may contain 0 or 1 page specifications in draft status and 0 or 1 page specifications in published status.")
    @Valid
    public PageSpecification[] getPageSpecifications() {
        if (this._pageSpecificationsSupplier != null) {
            this.pageSpecifications = this._pageSpecificationsSupplier.get();
            this._pageSpecificationsSupplier = null;
        }
        return this.pageSpecifications;
    }

    public void setPageSpecifications(PageSpecification[] pageSpecifications) {
        this.pageSpecifications = pageSpecifications;
        this._pageSpecificationsSupplier = null;
    }

    @JsonIgnore
    public void setPageSpecifications(UnsafeSupplier<PageSpecification[], Exception> pageSpecificationsUnsafeSupplier) {
        this._pageSpecificationsSupplier = () -> {
            try {
                return (PageSpecification[])pageSpecificationsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The utility page's thumbnail.")
    @Valid
    public ItemExternalReference getThumbnail() {
        if (this._thumbnailSupplier != null) {
            this.thumbnail = this._thumbnailSupplier.get();
            this._thumbnailSupplier = null;
        }
        return this.thumbnail;
    }

    public void setThumbnail(ItemExternalReference thumbnail) {
        this.thumbnail = thumbnail;
        this._thumbnailSupplier = null;
    }

    @JsonIgnore
    public void setThumbnail(UnsafeSupplier<ItemExternalReference, Exception> thumbnailUnsafeSupplier) {
        this._thumbnailSupplier = () -> {
            try {
                return (ItemExternalReference)thumbnailUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @JsonGetter(value="type")
    @Schema(description="The utility page's type.")
    @Valid
    public Type getType() {
        if (this._typeSupplier != null) {
            this.type = this._typeSupplier.get();
            this._typeSupplier = null;
        }
        return this.type;
    }

    @JsonIgnore
    public String getTypeAsString() {
        Type type = this.getType();
        if (type == null) {
            return null;
        }
        return type.toString();
    }

    public void setType(Type type) {
        this.type = type;
        this._typeSupplier = null;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<Type, Exception> typeUnsafeSupplier) {
        this._typeSupplier = () -> {
            try {
                return (Type)((Object)((Object)typeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Settings of the utility page.")
    @Valid
    public UtilityPageSettings getUtilityPageSettings() {
        if (this._utilityPageSettingsSupplier != null) {
            this.utilityPageSettings = this._utilityPageSettingsSupplier.get();
            this._utilityPageSettingsSupplier = null;
        }
        return this.utilityPageSettings;
    }

    public void setUtilityPageSettings(UtilityPageSettings utilityPageSettings) {
        this.utilityPageSettings = utilityPageSettings;
        this._utilityPageSettingsSupplier = null;
    }

    @JsonIgnore
    public void setUtilityPageSettings(UnsafeSupplier<UtilityPageSettings, Exception> utilityPageSettingsUnsafeSupplier) {
        this._utilityPageSettingsSupplier = () -> {
            try {
                return (UtilityPageSettings)utilityPageSettingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A valid external identifier to reference this utility page.")
    public String getUuid() {
        if (this._uuidSupplier != null) {
            this.uuid = this._uuidSupplier.get();
            this._uuidSupplier = null;
        }
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
        this._uuidSupplier = null;
    }

    @JsonIgnore
    public void setUuid(UnsafeSupplier<String, Exception> uuidUnsafeSupplier) {
        this._uuidSupplier = () -> {
            try {
                return (String)uuidUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UtilityPage)) {
            return false;
        }
        UtilityPage utilityPage = (UtilityPage)object;
        return Objects.equals(this.toString(), utilityPage.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String uuid;
        UtilityPageSettings utilityPageSettings;
        Type type;
        ItemExternalReference thumbnail;
        PageSpecification[] pageSpecifications;
        String name;
        Boolean markedAsDefault;
        String externalReferenceCode;
        Date datePublished;
        Date dateModified;
        Date dateCreated;
        String creatorExternalReferenceCode;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Creator creator = this.getCreator();
        if (creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append((Object)creator);
        }
        if ((creatorExternalReferenceCode = this.getCreatorExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creatorExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(UtilityPage._escape(creatorExternalReferenceCode));
            sb.append("\"");
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((datePublished = this.getDatePublished()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"datePublished\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(datePublished));
            sb.append("\"");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(UtilityPage._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((markedAsDefault = this.getMarkedAsDefault()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"markedAsDefault\": ");
            sb.append((Object)markedAsDefault);
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(UtilityPage._escape(name));
            sb.append("\"");
        }
        if ((pageSpecifications = this.getPageSpecifications()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageSpecifications\": ");
            sb.append("[");
            for (int i = 0; i < pageSpecifications.length; ++i) {
                sb.append(String.valueOf(pageSpecifications[i]));
                if (i + 1 >= pageSpecifications.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((thumbnail = this.getThumbnail()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"thumbnail\": ");
            sb.append(String.valueOf(thumbnail));
        }
        if ((type = this.getType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append((Object)type);
            sb.append("\"");
        }
        if ((utilityPageSettings = this.getUtilityPageSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"utilityPageSettings\": ");
            sb.append(String.valueOf(utilityPageSettings));
        }
        if ((uuid = this.getUuid()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"uuid\": ");
            sb.append("\"");
            sb.append(UtilityPage._escape(uuid));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(UtilityPage._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (UtilityPage._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(UtilityPage._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(UtilityPage._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(UtilityPage._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="Type")
    public static enum Type {
        COOKIE_POLICY("CookiePolicy"),
        CREATE_ACCOUNT("CreateAccount"),
        ERROR("Error"),
        ERROR_CODE404("ErrorCode404"),
        ERROR_CODE500("ErrorCode500"),
        FORGOT_PASSWORD("ForgotPassword"),
        LOGIN("Login"),
        TERMS_OF_USE("TermsOfUse");

        private final String _value;

        @JsonCreator
        public static Type create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Type type : Type.values()) {
                if (!Objects.equals(type.getValue(), value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Type(String value) {
            this._value = value;
        }
    }
}

