/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.PageRule;
import com.liferay.headless.admin.site.dto.v1_0.Settings;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represent a definition of a Page.", value="PageDefinition")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="PageDefinition")
public class PageDefinition
implements Serializable {
    @GraphQLField(description="The page's page element.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page's page element.") PageElement pageElement;
    @JsonIgnore
    private Supplier<PageElement> _pageElementSupplier;
    @GraphQLField(description="A list of the page rules this page has.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of the page rules this page has.") PageRule[] pageRules;
    @JsonIgnore
    private Supplier<PageRule[]> _pageRulesSupplier;
    @GraphQLField(description="The page's settings.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page's settings.") Settings settings;
    @JsonIgnore
    private Supplier<Settings> _settingsSupplier;
    @GraphQLField(description="The version of the JSON generated by page definition.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The version of the JSON generated by page definition.") Double version;
    @JsonIgnore
    private Supplier<Double> _versionSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.PageDefinition", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static PageDefinition toDTO(String json) {
        return (PageDefinition)ObjectMapperUtil.readValue(PageDefinition.class, (String)json);
    }

    public static PageDefinition unsafeToDTO(String json) {
        return (PageDefinition)ObjectMapperUtil.unsafeReadValue(PageDefinition.class, (String)json);
    }

    @Schema(description="The page's page element.")
    @Valid
    public PageElement getPageElement() {
        if (this._pageElementSupplier != null) {
            this.pageElement = this._pageElementSupplier.get();
            this._pageElementSupplier = null;
        }
        return this.pageElement;
    }

    public void setPageElement(PageElement pageElement) {
        this.pageElement = pageElement;
        this._pageElementSupplier = null;
    }

    @JsonIgnore
    public void setPageElement(UnsafeSupplier<PageElement, Exception> pageElementUnsafeSupplier) {
        this._pageElementSupplier = () -> {
            try {
                return (PageElement)pageElementUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A list of the page rules this page has.")
    @Valid
    public PageRule[] getPageRules() {
        if (this._pageRulesSupplier != null) {
            this.pageRules = this._pageRulesSupplier.get();
            this._pageRulesSupplier = null;
        }
        return this.pageRules;
    }

    public void setPageRules(PageRule[] pageRules) {
        this.pageRules = pageRules;
        this._pageRulesSupplier = null;
    }

    @JsonIgnore
    public void setPageRules(UnsafeSupplier<PageRule[], Exception> pageRulesUnsafeSupplier) {
        this._pageRulesSupplier = () -> {
            try {
                return (PageRule[])pageRulesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page's settings.")
    @Valid
    public Settings getSettings() {
        if (this._settingsSupplier != null) {
            this.settings = this._settingsSupplier.get();
            this._settingsSupplier = null;
        }
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this._settingsSupplier = null;
    }

    @JsonIgnore
    public void setSettings(UnsafeSupplier<Settings, Exception> settingsUnsafeSupplier) {
        this._settingsSupplier = () -> {
            try {
                return (Settings)settingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The version of the JSON generated by page definition.")
    public Double getVersion() {
        if (this._versionSupplier != null) {
            this.version = this._versionSupplier.get();
            this._versionSupplier = null;
        }
        return this.version;
    }

    public void setVersion(Double version) {
        this.version = version;
        this._versionSupplier = null;
    }

    @JsonIgnore
    public void setVersion(UnsafeSupplier<Double, Exception> versionUnsafeSupplier) {
        this._versionSupplier = () -> {
            try {
                return (Double)versionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PageDefinition)) {
            return false;
        }
        PageDefinition pageDefinition = (PageDefinition)object;
        return Objects.equals(this.toString(), pageDefinition.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Double version;
        Settings settings;
        PageRule[] pageRules;
        StringBundler sb = new StringBundler();
        sb.append("{");
        PageElement pageElement = this.getPageElement();
        if (pageElement != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageElement\": ");
            sb.append(String.valueOf(pageElement));
        }
        if ((pageRules = this.getPageRules()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageRules\": ");
            sb.append("[");
            for (int i = 0; i < pageRules.length; ++i) {
                sb.append(String.valueOf(pageRules[i]));
                if (i + 1 >= pageRules.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((settings = this.getSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"settings\": ");
            sb.append(String.valueOf(settings));
        }
        if ((version = this.getVersion()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"version\": ");
            sb.append((Object)version);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(PageDefinition._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (PageDefinition._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(PageDefinition._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(PageDefinition._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(PageDefinition._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

