/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(value="TextStylesConfig")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="TextStylesConfig")
public class TextStylesConfig
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Alignment alignment;
    @JsonIgnore
    private Supplier<Alignment> _alignmentSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean bold;
    @JsonIgnore
    private Supplier<Boolean> _boldSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String color;
    @JsonIgnore
    private Supplier<String> _colorSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Font font;
    @JsonIgnore
    private Supplier<Font> _fontSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean italic;
    @JsonIgnore
    private Supplier<Boolean> _italicSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String letterSpacing;
    @JsonIgnore
    private Supplier<String> _letterSpacingSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String lineHeight;
    @JsonIgnore
    private Supplier<String> _lineHeightSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String size;
    @JsonIgnore
    private Supplier<String> _sizeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected TextDecoration textDecoration;
    @JsonIgnore
    private Supplier<TextDecoration> _textDecorationSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String wordSpacing;
    @JsonIgnore
    private Supplier<String> _wordSpacingSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.TextStylesConfig", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static TextStylesConfig toDTO(String json) {
        return (TextStylesConfig)ObjectMapperUtil.readValue(TextStylesConfig.class, (String)json);
    }

    public static TextStylesConfig unsafeToDTO(String json) {
        return (TextStylesConfig)ObjectMapperUtil.unsafeReadValue(TextStylesConfig.class, (String)json);
    }

    @Schema
    @JsonGetter(value="alignment")
    @Valid
    public Alignment getAlignment() {
        if (this._alignmentSupplier != null) {
            this.alignment = this._alignmentSupplier.get();
            this._alignmentSupplier = null;
        }
        return this.alignment;
    }

    @JsonIgnore
    public String getAlignmentAsString() {
        Alignment alignment = this.getAlignment();
        if (alignment == null) {
            return null;
        }
        return alignment.toString();
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
        this._alignmentSupplier = null;
    }

    @JsonIgnore
    public void setAlignment(UnsafeSupplier<Alignment, Exception> alignmentUnsafeSupplier) {
        this._alignmentSupplier = () -> {
            try {
                return (Alignment)((Object)((Object)alignmentUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Boolean getBold() {
        if (this._boldSupplier != null) {
            this.bold = this._boldSupplier.get();
            this._boldSupplier = null;
        }
        return this.bold;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
        this._boldSupplier = null;
    }

    @JsonIgnore
    public void setBold(UnsafeSupplier<Boolean, Exception> boldUnsafeSupplier) {
        this._boldSupplier = () -> {
            try {
                return (Boolean)boldUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="#FF0D0D")
    public String getColor() {
        if (this._colorSupplier != null) {
            this.color = this._colorSupplier.get();
            this._colorSupplier = null;
        }
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
        this._colorSupplier = null;
    }

    @JsonIgnore
    public void setColor(UnsafeSupplier<String, Exception> colorUnsafeSupplier) {
        this._colorSupplier = () -> {
            try {
                return (String)colorUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @JsonGetter(value="font")
    @Valid
    public Font getFont() {
        if (this._fontSupplier != null) {
            this.font = this._fontSupplier.get();
            this._fontSupplier = null;
        }
        return this.font;
    }

    @JsonIgnore
    public String getFontAsString() {
        Font font = this.getFont();
        if (font == null) {
            return null;
        }
        return font.toString();
    }

    public void setFont(Font font) {
        this.font = font;
        this._fontSupplier = null;
    }

    @JsonIgnore
    public void setFont(UnsafeSupplier<Font, Exception> fontUnsafeSupplier) {
        this._fontSupplier = () -> {
            try {
                return (Font)((Object)((Object)fontUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Boolean getItalic() {
        if (this._italicSupplier != null) {
            this.italic = this._italicSupplier.get();
            this._italicSupplier = null;
        }
        return this.italic;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
        this._italicSupplier = null;
    }

    @JsonIgnore
    public void setItalic(UnsafeSupplier<Boolean, Exception> italicUnsafeSupplier) {
        this._italicSupplier = () -> {
            try {
                return (Boolean)italicUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getLetterSpacing() {
        if (this._letterSpacingSupplier != null) {
            this.letterSpacing = this._letterSpacingSupplier.get();
            this._letterSpacingSupplier = null;
        }
        return this.letterSpacing;
    }

    public void setLetterSpacing(String letterSpacing) {
        this.letterSpacing = letterSpacing;
        this._letterSpacingSupplier = null;
    }

    @JsonIgnore
    public void setLetterSpacing(UnsafeSupplier<String, Exception> letterSpacingUnsafeSupplier) {
        this._letterSpacingSupplier = () -> {
            try {
                return (String)letterSpacingUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getLineHeight() {
        if (this._lineHeightSupplier != null) {
            this.lineHeight = this._lineHeightSupplier.get();
            this._lineHeightSupplier = null;
        }
        return this.lineHeight;
    }

    public void setLineHeight(String lineHeight) {
        this.lineHeight = lineHeight;
        this._lineHeightSupplier = null;
    }

    @JsonIgnore
    public void setLineHeight(UnsafeSupplier<String, Exception> lineHeightUnsafeSupplier) {
        this._lineHeightSupplier = () -> {
            try {
                return (String)lineHeightUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getSize() {
        if (this._sizeSupplier != null) {
            this.size = this._sizeSupplier.get();
            this._sizeSupplier = null;
        }
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
        this._sizeSupplier = null;
    }

    @JsonIgnore
    public void setSize(UnsafeSupplier<String, Exception> sizeUnsafeSupplier) {
        this._sizeSupplier = () -> {
            try {
                return (String)sizeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @JsonGetter(value="textDecoration")
    @Valid
    public TextDecoration getTextDecoration() {
        if (this._textDecorationSupplier != null) {
            this.textDecoration = this._textDecorationSupplier.get();
            this._textDecorationSupplier = null;
        }
        return this.textDecoration;
    }

    @JsonIgnore
    public String getTextDecorationAsString() {
        TextDecoration textDecoration = this.getTextDecoration();
        if (textDecoration == null) {
            return null;
        }
        return textDecoration.toString();
    }

    public void setTextDecoration(TextDecoration textDecoration) {
        this.textDecoration = textDecoration;
        this._textDecorationSupplier = null;
    }

    @JsonIgnore
    public void setTextDecoration(UnsafeSupplier<TextDecoration, Exception> textDecorationUnsafeSupplier) {
        this._textDecorationSupplier = () -> {
            try {
                return (TextDecoration)((Object)((Object)textDecorationUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getWordSpacing() {
        if (this._wordSpacingSupplier != null) {
            this.wordSpacing = this._wordSpacingSupplier.get();
            this._wordSpacingSupplier = null;
        }
        return this.wordSpacing;
    }

    public void setWordSpacing(String wordSpacing) {
        this.wordSpacing = wordSpacing;
        this._wordSpacingSupplier = null;
    }

    @JsonIgnore
    public void setWordSpacing(UnsafeSupplier<String, Exception> wordSpacingUnsafeSupplier) {
        this._wordSpacingSupplier = () -> {
            try {
                return (String)wordSpacingUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextStylesConfig)) {
            return false;
        }
        TextStylesConfig textStylesConfig = (TextStylesConfig)object;
        return Objects.equals(this.toString(), textStylesConfig.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String wordSpacing;
        TextDecoration textDecoration;
        String size;
        String lineHeight;
        String letterSpacing;
        Boolean italic;
        Font font;
        String color;
        Boolean bold;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Alignment alignment = this.getAlignment();
        if (alignment != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"alignment\": ");
            sb.append("\"");
            sb.append((Object)alignment);
            sb.append("\"");
        }
        if ((bold = this.getBold()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"bold\": ");
            sb.append((Object)bold);
        }
        if ((color = this.getColor()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"color\": ");
            sb.append("\"");
            sb.append(TextStylesConfig._escape(color));
            sb.append("\"");
        }
        if ((font = this.getFont()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"font\": ");
            sb.append("\"");
            sb.append((Object)font);
            sb.append("\"");
        }
        if ((italic = this.getItalic()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"italic\": ");
            sb.append((Object)italic);
        }
        if ((letterSpacing = this.getLetterSpacing()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"letterSpacing\": ");
            sb.append("\"");
            sb.append(TextStylesConfig._escape(letterSpacing));
            sb.append("\"");
        }
        if ((lineHeight = this.getLineHeight()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"lineHeight\": ");
            sb.append("\"");
            sb.append(TextStylesConfig._escape(lineHeight));
            sb.append("\"");
        }
        if ((size = this.getSize()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"size\": ");
            sb.append("\"");
            sb.append(TextStylesConfig._escape(size));
            sb.append("\"");
        }
        if ((textDecoration = this.getTextDecoration()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"textDecoration\": ");
            sb.append("\"");
            sb.append((Object)textDecoration);
            sb.append("\"");
        }
        if ((wordSpacing = this.getWordSpacing()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"wordSpacing\": ");
            sb.append("\"");
            sb.append(TextStylesConfig._escape(wordSpacing));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(TextStylesConfig._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (TextStylesConfig._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(TextStylesConfig._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(TextStylesConfig._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(TextStylesConfig._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="Alignment")
    public static enum Alignment {
        CENTER("Center"),
        JUSTIFY("Justify"),
        LEFT("Left"),
        RIGHT("Right");

        private final String _value;

        @JsonCreator
        public static Alignment create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Alignment alignment : Alignment.values()) {
                if (!Objects.equals(alignment.getValue(), value)) continue;
                return alignment;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Alignment(String value) {
            this._value = value;
        }
    }

    @GraphQLName(value="Font")
    public static enum Font {
        ARIAL("Arial"),
        GEORGIA("Georgia"),
        TAHOMA("Tahoma"),
        TIMES_NEW_ROMAN("TimesNewRoman"),
        TREBUCHET_MS("TrebuchetMS"),
        VERDANA("Verdana");

        private final String _value;

        @JsonCreator
        public static Font create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Font font : Font.values()) {
                if (!Objects.equals(font.getValue(), value)) continue;
                return font;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Font(String value) {
            this._value = value;
        }
    }

    @GraphQLName(value="TextDecoration")
    public static enum TextDecoration {
        NONE("None"),
        OVERLINE("Overline"),
        STRIKETHROUGH("Strikethrough"),
        UNDERLINE("Underline");

        private final String _value;

        @JsonCreator
        public static TextDecoration create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (TextDecoration textDecoration : TextDecoration.values()) {
                if (!Objects.equals(textDecoration.getValue(), value)) continue;
                return textDecoration;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private TextDecoration(String value) {
            this._value = value;
        }
    }
}

