/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.admin.site.dto.v1_0.FragmentViewportStyle;
import com.liferay.headless.admin.site.dto.v1_0.GridViewportDefinition;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="A grid viewport.", value="GridViewport")
@Schema(description="A grid viewport.", requiredProperties={"gridViewportDefinition", "id"})
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="GridViewport")
public class GridViewport
implements Serializable {
    @GraphQLField(description="Custom CSS that is applied on the container viewport's page element.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Custom CSS that is applied on the container viewport's page element.") String customCSS;
    @JsonIgnore
    private Supplier<String> _customCSSSupplier;
    @GraphQLField(description="The fragment's viewport style.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The fragment's viewport style.") FragmentViewportStyle fragmentViewportStyle;
    @JsonIgnore
    private Supplier<FragmentViewportStyle> _fragmentViewportStyleSupplier;
    @GraphQLField(description="The definition of the grid viewport.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected @GraphQLField(description="The definition of the grid viewport.") @NotNull GridViewportDefinition gridViewportDefinition;
    @JsonIgnore
    private Supplier<GridViewportDefinition> _gridViewportDefinitionSupplier;
    @GraphQLField(description="The grid viewport's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected @GraphQLField(description="The grid viewport's ID.") @NotNull Id id;
    @JsonIgnore
    private Supplier<Id> _idSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.GridViewport", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static GridViewport toDTO(String json) {
        return (GridViewport)ObjectMapperUtil.readValue(GridViewport.class, (String)json);
    }

    public static GridViewport unsafeToDTO(String json) {
        return (GridViewport)ObjectMapperUtil.unsafeReadValue(GridViewport.class, (String)json);
    }

    @Schema(description="Custom CSS that is applied on the container viewport's page element.")
    public String getCustomCSS() {
        if (this._customCSSSupplier != null) {
            this.customCSS = this._customCSSSupplier.get();
            this._customCSSSupplier = null;
        }
        return this.customCSS;
    }

    public void setCustomCSS(String customCSS) {
        this.customCSS = customCSS;
        this._customCSSSupplier = null;
    }

    @JsonIgnore
    public void setCustomCSS(UnsafeSupplier<String, Exception> customCSSUnsafeSupplier) {
        this._customCSSSupplier = () -> {
            try {
                return (String)customCSSUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The fragment's viewport style.")
    @Valid
    public FragmentViewportStyle getFragmentViewportStyle() {
        if (this._fragmentViewportStyleSupplier != null) {
            this.fragmentViewportStyle = this._fragmentViewportStyleSupplier.get();
            this._fragmentViewportStyleSupplier = null;
        }
        return this.fragmentViewportStyle;
    }

    public void setFragmentViewportStyle(FragmentViewportStyle fragmentViewportStyle) {
        this.fragmentViewportStyle = fragmentViewportStyle;
        this._fragmentViewportStyleSupplier = null;
    }

    @JsonIgnore
    public void setFragmentViewportStyle(UnsafeSupplier<FragmentViewportStyle, Exception> fragmentViewportStyleUnsafeSupplier) {
        this._fragmentViewportStyleSupplier = () -> {
            try {
                return (FragmentViewportStyle)fragmentViewportStyleUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The definition of the grid viewport.")
    @Valid
    public GridViewportDefinition getGridViewportDefinition() {
        if (this._gridViewportDefinitionSupplier != null) {
            this.gridViewportDefinition = this._gridViewportDefinitionSupplier.get();
            this._gridViewportDefinitionSupplier = null;
        }
        return this.gridViewportDefinition;
    }

    public void setGridViewportDefinition(GridViewportDefinition gridViewportDefinition) {
        this.gridViewportDefinition = gridViewportDefinition;
        this._gridViewportDefinitionSupplier = null;
    }

    @JsonIgnore
    public void setGridViewportDefinition(UnsafeSupplier<GridViewportDefinition, Exception> gridViewportDefinitionUnsafeSupplier) {
        this._gridViewportDefinitionSupplier = () -> {
            try {
                return (GridViewportDefinition)gridViewportDefinitionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The grid viewport's ID.")
    @JsonGetter(value="id")
    @Valid
    public Id getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    @JsonIgnore
    public String getIdAsString() {
        Id id = this.getId();
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    public void setId(Id id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Id, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Id)((Object)((Object)idUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GridViewport)) {
            return false;
        }
        GridViewport gridViewport = (GridViewport)object;
        return Objects.equals(this.toString(), gridViewport.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Id id;
        GridViewportDefinition gridViewportDefinition;
        FragmentViewportStyle fragmentViewportStyle;
        StringBundler sb = new StringBundler();
        sb.append("{");
        String customCSS = this.getCustomCSS();
        if (customCSS != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customCSS\": ");
            sb.append("\"");
            sb.append(GridViewport._escape(customCSS));
            sb.append("\"");
        }
        if ((fragmentViewportStyle = this.getFragmentViewportStyle()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fragmentViewportStyle\": ");
            sb.append(String.valueOf(fragmentViewportStyle));
        }
        if ((gridViewportDefinition = this.getGridViewportDefinition()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"gridViewportDefinition\": ");
            sb.append(String.valueOf(gridViewportDefinition));
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append("\"");
            sb.append((Object)id);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(GridViewport._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (GridViewport._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(GridViewport._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(GridViewport._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(GridViewport._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="Id")
    public static enum Id {
        DESKTOP("Desktop"),
        LANDSCAPE_MOBILE("LandscapeMobile"),
        PORTRAIT_MOBILE("PortraitMobile"),
        TABLET("Tablet");

        private final String _value;

        @JsonCreator
        public static Id create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Id id : Id.values()) {
                if (!Objects.equals(id.getValue(), value)) continue;
                return id;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Id(String value) {
            this._value = value;
        }
    }
}

