/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="Represents the site being created.", value="Site")
@Schema(description="Represents the site being created.", requiredProperties={"name"})
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Site")
public class Site
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean active;
    @JsonIgnore
    private Supplier<Boolean> _activeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String description;
    @JsonIgnore
    private Supplier<String> _descriptionSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, String> description_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _description_i18nSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String descriptiveName;
    @JsonIgnore
    private Supplier<String> _descriptiveNameSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Map<String, String> descriptiveName_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _descriptiveName_i18nSupplier;
    @GraphQLField(description="The site's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The site's external reference code.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String friendlyUrlPath;
    @JsonIgnore
    private Supplier<String> _friendlyUrlPathSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String key;
    @JsonIgnore
    private Supplier<String> _keySupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean manualMembership;
    @JsonIgnore
    private Supplier<Boolean> _manualMembershipSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Integer membershipRestriction;
    @JsonIgnore
    private Supplier<Integer> _membershipRestrictionSupplier;
    @GraphQLField(description="The default value is open.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The default value is open.") MembershipType membershipType;
    @JsonIgnore
    private Supplier<MembershipType> _membershipTypeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, String> name_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _name_i18nSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String parentSiteExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _parentSiteExternalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected String templateKey;
    @JsonIgnore
    private Supplier<String> _templateKeySupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected TemplateType templateType;
    @JsonIgnore
    private Supplier<TemplateType> _templateTypeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, String> typeSettings;
    @JsonIgnore
    private Supplier<Map<String, String>> _typeSettingsSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.Site", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Site toDTO(String json) {
        return (Site)ObjectMapperUtil.readValue(Site.class, (String)json);
    }

    public static Site unsafeToDTO(String json) {
        return (Site)ObjectMapperUtil.unsafeReadValue(Site.class, (String)json);
    }

    @Schema
    public Boolean getActive() {
        if (this._activeSupplier != null) {
            this.active = this._activeSupplier.get();
            this._activeSupplier = null;
        }
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
        this._activeSupplier = null;
    }

    @JsonIgnore
    public void setActive(UnsafeSupplier<Boolean, Exception> activeUnsafeSupplier) {
        this._activeSupplier = () -> {
            try {
                return (Boolean)activeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getDescription() {
        if (this._descriptionSupplier != null) {
            this.description = this._descriptionSupplier.get();
            this._descriptionSupplier = null;
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this._descriptionSupplier = null;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        this._descriptionSupplier = () -> {
            try {
                return (String)descriptionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Map<String, String> getDescription_i18n() {
        if (this._description_i18nSupplier != null) {
            this.description_i18n = this._description_i18nSupplier.get();
            this._description_i18nSupplier = null;
        }
        return this.description_i18n;
    }

    public void setDescription_i18n(Map<String, String> description_i18n) {
        this.description_i18n = description_i18n;
        this._description_i18nSupplier = null;
    }

    @JsonIgnore
    public void setDescription_i18n(UnsafeSupplier<Map<String, String>, Exception> description_i18nUnsafeSupplier) {
        this._description_i18nSupplier = () -> {
            try {
                return (Map)description_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getDescriptiveName() {
        if (this._descriptiveNameSupplier != null) {
            this.descriptiveName = this._descriptiveNameSupplier.get();
            this._descriptiveNameSupplier = null;
        }
        return this.descriptiveName;
    }

    public void setDescriptiveName(String descriptiveName) {
        this.descriptiveName = descriptiveName;
        this._descriptiveNameSupplier = null;
    }

    @JsonIgnore
    public void setDescriptiveName(UnsafeSupplier<String, Exception> descriptiveNameUnsafeSupplier) {
        this._descriptiveNameSupplier = () -> {
            try {
                return (String)descriptiveNameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Map<String, String> getDescriptiveName_i18n() {
        if (this._descriptiveName_i18nSupplier != null) {
            this.descriptiveName_i18n = this._descriptiveName_i18nSupplier.get();
            this._descriptiveName_i18nSupplier = null;
        }
        return this.descriptiveName_i18n;
    }

    public void setDescriptiveName_i18n(Map<String, String> descriptiveName_i18n) {
        this.descriptiveName_i18n = descriptiveName_i18n;
        this._descriptiveName_i18nSupplier = null;
    }

    @JsonIgnore
    public void setDescriptiveName_i18n(UnsafeSupplier<Map<String, String>, Exception> descriptiveName_i18nUnsafeSupplier) {
        this._descriptiveName_i18nSupplier = () -> {
            try {
                return (Map)descriptiveName_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The site's external reference code.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getFriendlyUrlPath() {
        if (this._friendlyUrlPathSupplier != null) {
            this.friendlyUrlPath = this._friendlyUrlPathSupplier.get();
            this._friendlyUrlPathSupplier = null;
        }
        return this.friendlyUrlPath;
    }

    public void setFriendlyUrlPath(String friendlyUrlPath) {
        this.friendlyUrlPath = friendlyUrlPath;
        this._friendlyUrlPathSupplier = null;
    }

    @JsonIgnore
    public void setFriendlyUrlPath(UnsafeSupplier<String, Exception> friendlyUrlPathUnsafeSupplier) {
        this._friendlyUrlPathSupplier = () -> {
            try {
                return (String)friendlyUrlPathUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getKey() {
        if (this._keySupplier != null) {
            this.key = this._keySupplier.get();
            this._keySupplier = null;
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this._keySupplier = null;
    }

    @JsonIgnore
    public void setKey(UnsafeSupplier<String, Exception> keyUnsafeSupplier) {
        this._keySupplier = () -> {
            try {
                return (String)keyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Boolean getManualMembership() {
        if (this._manualMembershipSupplier != null) {
            this.manualMembership = this._manualMembershipSupplier.get();
            this._manualMembershipSupplier = null;
        }
        return this.manualMembership;
    }

    public void setManualMembership(Boolean manualMembership) {
        this.manualMembership = manualMembership;
        this._manualMembershipSupplier = null;
    }

    @JsonIgnore
    public void setManualMembership(UnsafeSupplier<Boolean, Exception> manualMembershipUnsafeSupplier) {
        this._manualMembershipSupplier = () -> {
            try {
                return (Boolean)manualMembershipUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Integer getMembershipRestriction() {
        if (this._membershipRestrictionSupplier != null) {
            this.membershipRestriction = this._membershipRestrictionSupplier.get();
            this._membershipRestrictionSupplier = null;
        }
        return this.membershipRestriction;
    }

    public void setMembershipRestriction(Integer membershipRestriction) {
        this.membershipRestriction = membershipRestriction;
        this._membershipRestrictionSupplier = null;
    }

    @JsonIgnore
    public void setMembershipRestriction(UnsafeSupplier<Integer, Exception> membershipRestrictionUnsafeSupplier) {
        this._membershipRestrictionSupplier = () -> {
            try {
                return (Integer)membershipRestrictionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The default value is open.")
    @JsonGetter(value="membershipType")
    @Valid
    public MembershipType getMembershipType() {
        if (this._membershipTypeSupplier != null) {
            this.membershipType = this._membershipTypeSupplier.get();
            this._membershipTypeSupplier = null;
        }
        return this.membershipType;
    }

    @JsonIgnore
    public String getMembershipTypeAsString() {
        MembershipType membershipType = this.getMembershipType();
        if (membershipType == null) {
            return null;
        }
        return membershipType.toString();
    }

    public void setMembershipType(MembershipType membershipType) {
        this.membershipType = membershipType;
        this._membershipTypeSupplier = null;
    }

    @JsonIgnore
    public void setMembershipType(UnsafeSupplier<MembershipType, Exception> membershipTypeUnsafeSupplier) {
        this._membershipTypeSupplier = () -> {
            try {
                return (MembershipType)((Object)((Object)membershipTypeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Map<String, String> getName_i18n() {
        if (this._name_i18nSupplier != null) {
            this.name_i18n = this._name_i18nSupplier.get();
            this._name_i18nSupplier = null;
        }
        return this.name_i18n;
    }

    public void setName_i18n(Map<String, String> name_i18n) {
        this.name_i18n = name_i18n;
        this._name_i18nSupplier = null;
    }

    @JsonIgnore
    public void setName_i18n(UnsafeSupplier<Map<String, String>, Exception> name_i18nUnsafeSupplier) {
        this._name_i18nSupplier = () -> {
            try {
                return (Map)name_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getParentSiteExternalReferenceCode() {
        if (this._parentSiteExternalReferenceCodeSupplier != null) {
            this.parentSiteExternalReferenceCode = this._parentSiteExternalReferenceCodeSupplier.get();
            this._parentSiteExternalReferenceCodeSupplier = null;
        }
        return this.parentSiteExternalReferenceCode;
    }

    public void setParentSiteExternalReferenceCode(String parentSiteExternalReferenceCode) {
        this.parentSiteExternalReferenceCode = parentSiteExternalReferenceCode;
        this._parentSiteExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setParentSiteExternalReferenceCode(UnsafeSupplier<String, Exception> parentSiteExternalReferenceCodeUnsafeSupplier) {
        this._parentSiteExternalReferenceCodeSupplier = () -> {
            try {
                return (String)parentSiteExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getTemplateKey() {
        if (this._templateKeySupplier != null) {
            this.templateKey = this._templateKeySupplier.get();
            this._templateKeySupplier = null;
        }
        return this.templateKey;
    }

    public void setTemplateKey(String templateKey) {
        this.templateKey = templateKey;
        this._templateKeySupplier = null;
    }

    @JsonIgnore
    public void setTemplateKey(UnsafeSupplier<String, Exception> templateKeyUnsafeSupplier) {
        this._templateKeySupplier = () -> {
            try {
                return (String)templateKeyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @JsonGetter(value="templateType")
    @Valid
    public TemplateType getTemplateType() {
        if (this._templateTypeSupplier != null) {
            this.templateType = this._templateTypeSupplier.get();
            this._templateTypeSupplier = null;
        }
        return this.templateType;
    }

    @JsonIgnore
    public String getTemplateTypeAsString() {
        TemplateType templateType = this.getTemplateType();
        if (templateType == null) {
            return null;
        }
        return templateType.toString();
    }

    public void setTemplateType(TemplateType templateType) {
        this.templateType = templateType;
        this._templateTypeSupplier = null;
    }

    @JsonIgnore
    public void setTemplateType(UnsafeSupplier<TemplateType, Exception> templateTypeUnsafeSupplier) {
        this._templateTypeSupplier = () -> {
            try {
                return (TemplateType)((Object)((Object)templateTypeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Map<String, String> getTypeSettings() {
        if (this._typeSettingsSupplier != null) {
            this.typeSettings = this._typeSettingsSupplier.get();
            this._typeSettingsSupplier = null;
        }
        return this.typeSettings;
    }

    public void setTypeSettings(Map<String, String> typeSettings) {
        this.typeSettings = typeSettings;
        this._typeSettingsSupplier = null;
    }

    @JsonIgnore
    public void setTypeSettings(UnsafeSupplier<Map<String, String>, Exception> typeSettingsUnsafeSupplier) {
        this._typeSettingsSupplier = () -> {
            try {
                return (Map)typeSettingsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Site)) {
            return false;
        }
        Site site = (Site)object;
        return Objects.equals(this.toString(), site.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Map<String, String> typeSettings;
        TemplateType templateType;
        String templateKey;
        String parentSiteExternalReferenceCode;
        Map<String, String> name_i18n;
        String name;
        MembershipType membershipType;
        Integer membershipRestriction;
        Boolean manualMembership;
        String key;
        Long id;
        String friendlyUrlPath;
        String externalReferenceCode;
        Map<String, String> descriptiveName_i18n;
        String descriptiveName;
        Map<String, String> description_i18n;
        String description;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Boolean active = this.getActive();
        if (active != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"active\": ");
            sb.append((Object)active);
        }
        if ((description = this.getDescription()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(Site._escape(description));
            sb.append("\"");
        }
        if ((description_i18n = this.getDescription_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description_i18n\": ");
            sb.append(Site._toJSON(description_i18n));
        }
        if ((descriptiveName = this.getDescriptiveName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"descriptiveName\": ");
            sb.append("\"");
            sb.append(Site._escape(descriptiveName));
            sb.append("\"");
        }
        if ((descriptiveName_i18n = this.getDescriptiveName_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"descriptiveName_i18n\": ");
            sb.append(Site._toJSON(descriptiveName_i18n));
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Site._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((friendlyUrlPath = this.getFriendlyUrlPath()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"friendlyUrlPath\": ");
            sb.append("\"");
            sb.append(Site._escape(friendlyUrlPath));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((key = this.getKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"key\": ");
            sb.append("\"");
            sb.append(Site._escape(key));
            sb.append("\"");
        }
        if ((manualMembership = this.getManualMembership()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"manualMembership\": ");
            sb.append((Object)manualMembership);
        }
        if ((membershipRestriction = this.getMembershipRestriction()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"membershipRestriction\": ");
            sb.append((Object)membershipRestriction);
        }
        if ((membershipType = this.getMembershipType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"membershipType\": ");
            sb.append("\"");
            sb.append((Object)membershipType);
            sb.append("\"");
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(Site._escape(name));
            sb.append("\"");
        }
        if ((name_i18n = this.getName_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name_i18n\": ");
            sb.append(Site._toJSON(name_i18n));
        }
        if ((parentSiteExternalReferenceCode = this.getParentSiteExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentSiteExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(Site._escape(parentSiteExternalReferenceCode));
            sb.append("\"");
        }
        if ((templateKey = this.getTemplateKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"templateKey\": ");
            sb.append("\"");
            sb.append(Site._escape(templateKey));
            sb.append("\"");
        }
        if ((templateType = this.getTemplateType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"templateType\": ");
            sb.append("\"");
            sb.append((Object)templateType);
            sb.append("\"");
        }
        if ((typeSettings = this.getTypeSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"typeSettings\": ");
            sb.append(Site._toJSON(typeSettings));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Site._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Site._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Site._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Site._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Site._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="MembershipType")
    public static enum MembershipType {
        OPEN("open"),
        PRIVATE("private"),
        RESTRICTED("restricted");

        private final String _value;

        @JsonCreator
        public static MembershipType create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (MembershipType membershipType : MembershipType.values()) {
                if (!Objects.equals(membershipType.getValue(), value)) continue;
                return membershipType;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private MembershipType(String value) {
            this._value = value;
        }
    }

    @GraphQLName(value="TemplateType")
    public static enum TemplateType {
        SITE_INITIALIZER("site-initializer"),
        SITE_TEMPLATE("site-template");

        private final String _value;

        @JsonCreator
        public static TemplateType create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (TemplateType templateType : TemplateType.values()) {
                if (!Objects.equals(templateType.getValue(), value)) continue;
                return templateType;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private TemplateType(String value) {
            this._value = value;
        }
    }
}

