/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.PageRule;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="A customized experience for a given page specification.", value="PageExperience")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="PageExperience")
public class PageExperience
implements Serializable {
    @GraphQLField(description="The experience's external reference code, unique per site.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The experience's external reference code, unique per site.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="The experience's key.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The experience's key.") String key;
    @JsonIgnore
    private Supplier<String> _keySupplier;
    @GraphQLField(description="The localized experience's names.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized experience's names.") Map<String, String> name_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _name_i18nSupplier;
    @GraphQLField(description="The page elements in the experience.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page elements in the experience.") PageElement[] pageElements;
    @JsonIgnore
    private Supplier<PageElement[]> _pageElementsSupplier;
    @GraphQLField(description="The page rules in the experience.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page rules in the experience.") PageRule[] pageRules;
    @JsonIgnore
    private Supplier<PageRule[]> _pageRulesSupplier;
    @GraphQLField(description="The page specification's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page specification's external reference code.") String pageSpecificationExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _pageSpecificationExternalReferenceCodeSupplier;
    @GraphQLField(description="The experience's priority. It must be a unique value within the page specification. The default experience will always be assigned priority 0. A priority higher than 0 will result in an experience being active and a priority lower than 0 will result in an experience being inactive.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The experience's priority. It must be a unique value within the page specification. The default experience will always be assigned priority 0. A priority higher than 0 will result in an experience being active and a priority lower than 0 will result in an experience being inactive.") Integer priority;
    @JsonIgnore
    private Supplier<Integer> _prioritySupplier;
    @GraphQLField(description="The segment's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The segment's external reference code.") String segmentExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _segmentExternalReferenceCodeSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.PageExperience", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static PageExperience toDTO(String json) {
        return (PageExperience)ObjectMapperUtil.readValue(PageExperience.class, (String)json);
    }

    public static PageExperience unsafeToDTO(String json) {
        return (PageExperience)ObjectMapperUtil.unsafeReadValue(PageExperience.class, (String)json);
    }

    @Schema(description="The experience's external reference code, unique per site.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The experience's key.")
    public String getKey() {
        if (this._keySupplier != null) {
            this.key = this._keySupplier.get();
            this._keySupplier = null;
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this._keySupplier = null;
    }

    @JsonIgnore
    public void setKey(UnsafeSupplier<String, Exception> keyUnsafeSupplier) {
        this._keySupplier = () -> {
            try {
                return (String)keyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized experience's names.")
    @Valid
    public Map<String, String> getName_i18n() {
        if (this._name_i18nSupplier != null) {
            this.name_i18n = this._name_i18nSupplier.get();
            this._name_i18nSupplier = null;
        }
        return this.name_i18n;
    }

    public void setName_i18n(Map<String, String> name_i18n) {
        this.name_i18n = name_i18n;
        this._name_i18nSupplier = null;
    }

    @JsonIgnore
    public void setName_i18n(UnsafeSupplier<Map<String, String>, Exception> name_i18nUnsafeSupplier) {
        this._name_i18nSupplier = () -> {
            try {
                return (Map)name_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page elements in the experience.")
    @Valid
    public PageElement[] getPageElements() {
        if (this._pageElementsSupplier != null) {
            this.pageElements = this._pageElementsSupplier.get();
            this._pageElementsSupplier = null;
        }
        return this.pageElements;
    }

    public void setPageElements(PageElement[] pageElements) {
        this.pageElements = pageElements;
        this._pageElementsSupplier = null;
    }

    @JsonIgnore
    public void setPageElements(UnsafeSupplier<PageElement[], Exception> pageElementsUnsafeSupplier) {
        this._pageElementsSupplier = () -> {
            try {
                return (PageElement[])pageElementsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page rules in the experience.")
    @Valid
    public PageRule[] getPageRules() {
        if (this._pageRulesSupplier != null) {
            this.pageRules = this._pageRulesSupplier.get();
            this._pageRulesSupplier = null;
        }
        return this.pageRules;
    }

    public void setPageRules(PageRule[] pageRules) {
        this.pageRules = pageRules;
        this._pageRulesSupplier = null;
    }

    @JsonIgnore
    public void setPageRules(UnsafeSupplier<PageRule[], Exception> pageRulesUnsafeSupplier) {
        this._pageRulesSupplier = () -> {
            try {
                return (PageRule[])pageRulesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page specification's external reference code.")
    public String getPageSpecificationExternalReferenceCode() {
        if (this._pageSpecificationExternalReferenceCodeSupplier != null) {
            this.pageSpecificationExternalReferenceCode = this._pageSpecificationExternalReferenceCodeSupplier.get();
            this._pageSpecificationExternalReferenceCodeSupplier = null;
        }
        return this.pageSpecificationExternalReferenceCode;
    }

    public void setPageSpecificationExternalReferenceCode(String pageSpecificationExternalReferenceCode) {
        this.pageSpecificationExternalReferenceCode = pageSpecificationExternalReferenceCode;
        this._pageSpecificationExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setPageSpecificationExternalReferenceCode(UnsafeSupplier<String, Exception> pageSpecificationExternalReferenceCodeUnsafeSupplier) {
        this._pageSpecificationExternalReferenceCodeSupplier = () -> {
            try {
                return (String)pageSpecificationExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The experience's priority. It must be a unique value within the page specification. The default experience will always be assigned priority 0. A priority higher than 0 will result in an experience being active and a priority lower than 0 will result in an experience being inactive.")
    public Integer getPriority() {
        if (this._prioritySupplier != null) {
            this.priority = this._prioritySupplier.get();
            this._prioritySupplier = null;
        }
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
        this._prioritySupplier = null;
    }

    @JsonIgnore
    public void setPriority(UnsafeSupplier<Integer, Exception> priorityUnsafeSupplier) {
        this._prioritySupplier = () -> {
            try {
                return (Integer)priorityUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The segment's external reference code.")
    public String getSegmentExternalReferenceCode() {
        if (this._segmentExternalReferenceCodeSupplier != null) {
            this.segmentExternalReferenceCode = this._segmentExternalReferenceCodeSupplier.get();
            this._segmentExternalReferenceCodeSupplier = null;
        }
        return this.segmentExternalReferenceCode;
    }

    public void setSegmentExternalReferenceCode(String segmentExternalReferenceCode) {
        this.segmentExternalReferenceCode = segmentExternalReferenceCode;
        this._segmentExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setSegmentExternalReferenceCode(UnsafeSupplier<String, Exception> segmentExternalReferenceCodeUnsafeSupplier) {
        this._segmentExternalReferenceCodeSupplier = () -> {
            try {
                return (String)segmentExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PageExperience)) {
            return false;
        }
        PageExperience pageExperience = (PageExperience)object;
        return Objects.equals(this.toString(), pageExperience.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String segmentExternalReferenceCode;
        Integer priority;
        String pageSpecificationExternalReferenceCode;
        PageRule[] pageRules;
        PageElement[] pageElements;
        Map<String, String> name_i18n;
        String key;
        StringBundler sb = new StringBundler();
        sb.append("{");
        String externalReferenceCode = this.getExternalReferenceCode();
        if (externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(PageExperience._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((key = this.getKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"key\": ");
            sb.append("\"");
            sb.append(PageExperience._escape(key));
            sb.append("\"");
        }
        if ((name_i18n = this.getName_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name_i18n\": ");
            sb.append(PageExperience._toJSON(name_i18n));
        }
        if ((pageElements = this.getPageElements()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageElements\": ");
            sb.append("[");
            for (int i = 0; i < pageElements.length; ++i) {
                sb.append(String.valueOf(pageElements[i]));
                if (i + 1 >= pageElements.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((pageRules = this.getPageRules()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageRules\": ");
            sb.append("[");
            for (int i = 0; i < pageRules.length; ++i) {
                sb.append(String.valueOf(pageRules[i]));
                if (i + 1 >= pageRules.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((pageSpecificationExternalReferenceCode = this.getPageSpecificationExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageSpecificationExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(PageExperience._escape(pageSpecificationExternalReferenceCode));
            sb.append("\"");
        }
        if ((priority = this.getPriority()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"priority\": ");
            sb.append((Object)priority);
        }
        if ((segmentExternalReferenceCode = this.getSegmentExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"segmentExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(PageExperience._escape(segmentExternalReferenceCode));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(PageExperience._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (PageExperience._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(PageExperience._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(PageExperience._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(PageExperience._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

