/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="A fragment image viewport.", value="FragmentImageViewport")
@Schema(description="A fragment image viewport.", requiredProperties={"id", "resolution"})
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="FragmentImageViewport")
public class FragmentImageViewport
implements Serializable {
    @GraphQLField(description="The fragment image viewport's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected @GraphQLField(description="The fragment image viewport's ID.") @NotNull Id id;
    @JsonIgnore
    private Supplier<Id> _idSupplier;
    @GraphQLField(description="The resolution of the fragment image viewport.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected @GraphQLField(description="The resolution of the fragment image viewport.") @NotNull Resolution resolution;
    @JsonIgnore
    private Supplier<Resolution> _resolutionSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.FragmentImageViewport", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static FragmentImageViewport toDTO(String json) {
        return (FragmentImageViewport)ObjectMapperUtil.readValue(FragmentImageViewport.class, (String)json);
    }

    public static FragmentImageViewport unsafeToDTO(String json) {
        return (FragmentImageViewport)ObjectMapperUtil.unsafeReadValue(FragmentImageViewport.class, (String)json);
    }

    @Schema(description="The fragment image viewport's ID.")
    @JsonGetter(value="id")
    @Valid
    public Id getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    @JsonIgnore
    public String getIdAsString() {
        Id id = this.getId();
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    public void setId(Id id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Id, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Id)((Object)((Object)idUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The resolution of the fragment image viewport.")
    @JsonGetter(value="resolution")
    @Valid
    public Resolution getResolution() {
        if (this._resolutionSupplier != null) {
            this.resolution = this._resolutionSupplier.get();
            this._resolutionSupplier = null;
        }
        return this.resolution;
    }

    @JsonIgnore
    public String getResolutionAsString() {
        Resolution resolution = this.getResolution();
        if (resolution == null) {
            return null;
        }
        return resolution.toString();
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
        this._resolutionSupplier = null;
    }

    @JsonIgnore
    public void setResolution(UnsafeSupplier<Resolution, Exception> resolutionUnsafeSupplier) {
        this._resolutionSupplier = () -> {
            try {
                return (Resolution)((Object)((Object)resolutionUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FragmentImageViewport)) {
            return false;
        }
        FragmentImageViewport fragmentImageViewport = (FragmentImageViewport)object;
        return Objects.equals(this.toString(), fragmentImageViewport.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Resolution resolution;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Id id = this.getId();
        if (id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append("\"");
            sb.append((Object)id);
            sb.append("\"");
        }
        if ((resolution = this.getResolution()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"resolution\": ");
            sb.append("\"");
            sb.append((Object)resolution);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(FragmentImageViewport._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (FragmentImageViewport._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(FragmentImageViewport._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(FragmentImageViewport._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(FragmentImageViewport._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="Id")
    public static enum Id {
        LANDSCAPE_MOBILE("LandscapeMobile"),
        PORTRAIT_MOBILE("PortraitMobile"),
        TABLET("Tablet");

        private final String _value;

        @JsonCreator
        public static Id create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Id id : Id.values()) {
                if (!Objects.equals(id.getValue(), value)) continue;
                return id;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Id(String value) {
            this._value = value;
        }
    }

    @GraphQLName(value="Resolution")
    public static enum Resolution {
        AUTO("Auto"),
        PREVIEW("Preview"),
        THUMBNAIL("Thumbnail");

        private final String _value;

        @JsonCreator
        public static Resolution create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Resolution resolution : Resolution.values()) {
                if (!Objects.equals(resolution.getValue(), value)) continue;
                return resolution;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Resolution(String value) {
            this._value = value;
        }
    }
}

