/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.admin.site.dto.v1_0.FragmentImageValue;
import com.liferay.headless.admin.site.dto.v1_0.FragmentImageViewport;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="A fragment image.", value="FragmentImage")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="FragmentImage")
public class FragmentImage
implements Serializable {
    @GraphQLField(description="The localized fragment image's descriptions.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized fragment image's descriptions.") Map<String, String> description_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _description_i18nSupplier;
    @GraphQLField(description="The fragment image's value.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The fragment image's value.") FragmentImageValue fragmentImageValue;
    @JsonIgnore
    private Supplier<FragmentImageValue> _fragmentImageValueSupplier;
    @GraphQLField(description="A list of viewports configuration of the fragment image.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of viewports configuration of the fragment image.") FragmentImageViewport[] fragmentImageViewports;
    @JsonIgnore
    private Supplier<FragmentImageViewport[]> _fragmentImageViewportsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean lazyLoading;
    @JsonIgnore
    private Supplier<Boolean> _lazyLoadingSupplier;
    @GraphQLField(description="The fragment image's resolution.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The fragment image's resolution.") Resolution resolution;
    @JsonIgnore
    private Supplier<Resolution> _resolutionSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.FragmentImage", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static FragmentImage toDTO(String json) {
        return (FragmentImage)ObjectMapperUtil.readValue(FragmentImage.class, (String)json);
    }

    public static FragmentImage unsafeToDTO(String json) {
        return (FragmentImage)ObjectMapperUtil.unsafeReadValue(FragmentImage.class, (String)json);
    }

    @Schema(description="The localized fragment image's descriptions.")
    @Valid
    public Map<String, String> getDescription_i18n() {
        if (this._description_i18nSupplier != null) {
            this.description_i18n = this._description_i18nSupplier.get();
            this._description_i18nSupplier = null;
        }
        return this.description_i18n;
    }

    public void setDescription_i18n(Map<String, String> description_i18n) {
        this.description_i18n = description_i18n;
        this._description_i18nSupplier = null;
    }

    @JsonIgnore
    public void setDescription_i18n(UnsafeSupplier<Map<String, String>, Exception> description_i18nUnsafeSupplier) {
        this._description_i18nSupplier = () -> {
            try {
                return (Map)description_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The fragment image's value.")
    @Valid
    public FragmentImageValue getFragmentImageValue() {
        if (this._fragmentImageValueSupplier != null) {
            this.fragmentImageValue = this._fragmentImageValueSupplier.get();
            this._fragmentImageValueSupplier = null;
        }
        return this.fragmentImageValue;
    }

    public void setFragmentImageValue(FragmentImageValue fragmentImageValue) {
        this.fragmentImageValue = fragmentImageValue;
        this._fragmentImageValueSupplier = null;
    }

    @JsonIgnore
    public void setFragmentImageValue(UnsafeSupplier<FragmentImageValue, Exception> fragmentImageValueUnsafeSupplier) {
        this._fragmentImageValueSupplier = () -> {
            try {
                return (FragmentImageValue)fragmentImageValueUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A list of viewports configuration of the fragment image.")
    @Valid
    public FragmentImageViewport[] getFragmentImageViewports() {
        if (this._fragmentImageViewportsSupplier != null) {
            this.fragmentImageViewports = this._fragmentImageViewportsSupplier.get();
            this._fragmentImageViewportsSupplier = null;
        }
        return this.fragmentImageViewports;
    }

    public void setFragmentImageViewports(FragmentImageViewport[] fragmentImageViewports) {
        this.fragmentImageViewports = fragmentImageViewports;
        this._fragmentImageViewportsSupplier = null;
    }

    @JsonIgnore
    public void setFragmentImageViewports(UnsafeSupplier<FragmentImageViewport[], Exception> fragmentImageViewportsUnsafeSupplier) {
        this._fragmentImageViewportsSupplier = () -> {
            try {
                return (FragmentImageViewport[])fragmentImageViewportsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Boolean getLazyLoading() {
        if (this._lazyLoadingSupplier != null) {
            this.lazyLoading = this._lazyLoadingSupplier.get();
            this._lazyLoadingSupplier = null;
        }
        return this.lazyLoading;
    }

    public void setLazyLoading(Boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
        this._lazyLoadingSupplier = null;
    }

    @JsonIgnore
    public void setLazyLoading(UnsafeSupplier<Boolean, Exception> lazyLoadingUnsafeSupplier) {
        this._lazyLoadingSupplier = () -> {
            try {
                return (Boolean)lazyLoadingUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The fragment image's resolution.")
    @JsonGetter(value="resolution")
    @Valid
    public Resolution getResolution() {
        if (this._resolutionSupplier != null) {
            this.resolution = this._resolutionSupplier.get();
            this._resolutionSupplier = null;
        }
        return this.resolution;
    }

    @JsonIgnore
    public String getResolutionAsString() {
        Resolution resolution = this.getResolution();
        if (resolution == null) {
            return null;
        }
        return resolution.toString();
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
        this._resolutionSupplier = null;
    }

    @JsonIgnore
    public void setResolution(UnsafeSupplier<Resolution, Exception> resolutionUnsafeSupplier) {
        this._resolutionSupplier = () -> {
            try {
                return (Resolution)((Object)((Object)resolutionUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FragmentImage)) {
            return false;
        }
        FragmentImage fragmentImage = (FragmentImage)object;
        return Objects.equals(this.toString(), fragmentImage.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Resolution resolution;
        Boolean lazyLoading;
        FragmentImageViewport[] fragmentImageViewports;
        FragmentImageValue fragmentImageValue;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Map<String, String> description_i18n = this.getDescription_i18n();
        if (description_i18n != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description_i18n\": ");
            sb.append(FragmentImage._toJSON(description_i18n));
        }
        if ((fragmentImageValue = this.getFragmentImageValue()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fragmentImageValue\": ");
            sb.append(String.valueOf(fragmentImageValue));
        }
        if ((fragmentImageViewports = this.getFragmentImageViewports()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fragmentImageViewports\": ");
            sb.append("[");
            for (int i = 0; i < fragmentImageViewports.length; ++i) {
                sb.append(String.valueOf(fragmentImageViewports[i]));
                if (i + 1 >= fragmentImageViewports.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((lazyLoading = this.getLazyLoading()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"lazyLoading\": ");
            sb.append((Object)lazyLoading);
        }
        if ((resolution = this.getResolution()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"resolution\": ");
            sb.append("\"");
            sb.append((Object)resolution);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(FragmentImage._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (FragmentImage._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(FragmentImage._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(FragmentImage._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(FragmentImage._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="Resolution")
    public static enum Resolution {
        AUTO("Auto"),
        PREVIEW("Preview"),
        THUMBNAIL("Thumbnail");

        private final String _value;

        @JsonCreator
        public static Resolution create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Resolution resolution : Resolution.values()) {
                if (!Objects.equals(resolution.getValue(), value)) continue;
                return resolution;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Resolution(String value) {
            this._value = value;
        }
    }
}

