/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="Represents settings related with Open Graph protocol.", value="OpenGraphSettings")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="OpenGraphSettings")
public class OpenGraphSettings
implements Serializable {
    @GraphQLField(description="The localized Open Graph's descriptions.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized Open Graph's descriptions.") Map<String, String> description_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _description_i18nSupplier;
    @GraphQLField(description="The Open Graph's image.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The Open Graph's image.") ItemExternalReference image;
    @JsonIgnore
    private Supplier<ItemExternalReference> _imageSupplier;
    @GraphQLField(description="The localized Open Graph's image alts.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized Open Graph's image alts.") Map<String, String> imageAlt_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _imageAlt_i18nSupplier;
    @GraphQLField(description="The localized Open Graph's titles.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized Open Graph's titles.") Map<String, String> title_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _title_i18nSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.OpenGraphSettings", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static OpenGraphSettings toDTO(String json) {
        return (OpenGraphSettings)ObjectMapperUtil.readValue(OpenGraphSettings.class, (String)json);
    }

    public static OpenGraphSettings unsafeToDTO(String json) {
        return (OpenGraphSettings)ObjectMapperUtil.unsafeReadValue(OpenGraphSettings.class, (String)json);
    }

    @Schema(description="The localized Open Graph's descriptions.")
    @Valid
    public Map<String, String> getDescription_i18n() {
        if (this._description_i18nSupplier != null) {
            this.description_i18n = this._description_i18nSupplier.get();
            this._description_i18nSupplier = null;
        }
        return this.description_i18n;
    }

    public void setDescription_i18n(Map<String, String> description_i18n) {
        this.description_i18n = description_i18n;
        this._description_i18nSupplier = null;
    }

    @JsonIgnore
    public void setDescription_i18n(UnsafeSupplier<Map<String, String>, Exception> description_i18nUnsafeSupplier) {
        this._description_i18nSupplier = () -> {
            try {
                return (Map)description_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The Open Graph's image.")
    @Valid
    public ItemExternalReference getImage() {
        if (this._imageSupplier != null) {
            this.image = this._imageSupplier.get();
            this._imageSupplier = null;
        }
        return this.image;
    }

    public void setImage(ItemExternalReference image) {
        this.image = image;
        this._imageSupplier = null;
    }

    @JsonIgnore
    public void setImage(UnsafeSupplier<ItemExternalReference, Exception> imageUnsafeSupplier) {
        this._imageSupplier = () -> {
            try {
                return (ItemExternalReference)imageUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized Open Graph's image alts.")
    @Valid
    public Map<String, String> getImageAlt_i18n() {
        if (this._imageAlt_i18nSupplier != null) {
            this.imageAlt_i18n = this._imageAlt_i18nSupplier.get();
            this._imageAlt_i18nSupplier = null;
        }
        return this.imageAlt_i18n;
    }

    public void setImageAlt_i18n(Map<String, String> imageAlt_i18n) {
        this.imageAlt_i18n = imageAlt_i18n;
        this._imageAlt_i18nSupplier = null;
    }

    @JsonIgnore
    public void setImageAlt_i18n(UnsafeSupplier<Map<String, String>, Exception> imageAlt_i18nUnsafeSupplier) {
        this._imageAlt_i18nSupplier = () -> {
            try {
                return (Map)imageAlt_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized Open Graph's titles.")
    @Valid
    public Map<String, String> getTitle_i18n() {
        if (this._title_i18nSupplier != null) {
            this.title_i18n = this._title_i18nSupplier.get();
            this._title_i18nSupplier = null;
        }
        return this.title_i18n;
    }

    public void setTitle_i18n(Map<String, String> title_i18n) {
        this.title_i18n = title_i18n;
        this._title_i18nSupplier = null;
    }

    @JsonIgnore
    public void setTitle_i18n(UnsafeSupplier<Map<String, String>, Exception> title_i18nUnsafeSupplier) {
        this._title_i18nSupplier = () -> {
            try {
                return (Map)title_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OpenGraphSettings)) {
            return false;
        }
        OpenGraphSettings openGraphSettings = (OpenGraphSettings)object;
        return Objects.equals(this.toString(), openGraphSettings.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Map<String, String> title_i18n;
        Map<String, String> imageAlt_i18n;
        ItemExternalReference image;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Map<String, String> description_i18n = this.getDescription_i18n();
        if (description_i18n != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description_i18n\": ");
            sb.append(OpenGraphSettings._toJSON(description_i18n));
        }
        if ((image = this.getImage()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"image\": ");
            sb.append(String.valueOf(image));
        }
        if ((imageAlt_i18n = this.getImageAlt_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"imageAlt_i18n\": ");
            sb.append(OpenGraphSettings._toJSON(imageAlt_i18n));
        }
        if ((title_i18n = this.getTitle_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"title_i18n\": ");
            sb.append(OpenGraphSettings._toJSON(title_i18n));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(OpenGraphSettings._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (OpenGraphSettings._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(OpenGraphSettings._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(OpenGraphSettings._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(OpenGraphSettings._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

