/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.admin.site.dto.v1_0.NavigationMenuItem;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="Represents a navigation menu.", value="NavigationMenu")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="NavigationMenu")
public class NavigationMenu
implements Serializable {
    @GraphQLField(description="Block of actions allowed by the user making the request.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="Block of actions allowed by the user making the request.") Map<String, Map<String, String>> actions;
    @JsonIgnore
    private Supplier<Map<String, Map<String, String>>> _actionsSupplier;
    @GraphQLField(description="The navigation menu's creator. It is not returned by default. It can be embedded via nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The navigation menu's creator. It is not returned by default. It can be embedded via nestedFields.") Creator creator;
    @JsonIgnore
    private Supplier<Creator> _creatorSupplier;
    @GraphQLField(description="The navigation menu's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The navigation menu's creation date.") Date dateCreated;
    @JsonIgnore
    private Supplier<Date> _dateCreatedSupplier;
    @GraphQLField(description="The last time the navigation menu changed.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The last time the navigation menu changed.") Date dateModified;
    @JsonIgnore
    private Supplier<Date> _dateModifiedSupplier;
    @GraphQLField(description="The navigation menu's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The navigation menu's external reference code.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="The navigation menu's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The navigation menu's ID.") Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField(description="The navigation menu's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The navigation menu's name.") String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField(description="The list of navigation menu items this navigation menu has.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The list of navigation menu items this navigation menu has.") NavigationMenuItem[] navigationMenuItems;
    @JsonIgnore
    private Supplier<NavigationMenuItem[]> _navigationMenuItemsSupplier;
    @GraphQLField(description="The navigation menu's type (primary, secondary, social).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The navigation menu's type (primary, secondary, social).") NavigationType navigationType;
    @JsonIgnore
    private Supplier<NavigationType> _navigationTypeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Permission[] permissions;
    @JsonIgnore
    private Supplier<Permission[]> _permissionsSupplier;
    @GraphQLField(description="The ID of the site to which this navigation menu is scoped.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The ID of the site to which this navigation menu is scoped.") Long siteId;
    @JsonIgnore
    private Supplier<Long> _siteIdSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.NavigationMenu", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static NavigationMenu toDTO(String json) {
        return (NavigationMenu)ObjectMapperUtil.readValue(NavigationMenu.class, (String)json);
    }

    public static NavigationMenu unsafeToDTO(String json) {
        return (NavigationMenu)ObjectMapperUtil.unsafeReadValue(NavigationMenu.class, (String)json);
    }

    @Schema(description="Block of actions allowed by the user making the request.")
    @Valid
    public Map<String, Map<String, String>> getActions() {
        if (this._actionsSupplier != null) {
            this.actions = this._actionsSupplier.get();
            this._actionsSupplier = null;
        }
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
        this._actionsSupplier = null;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        this._actionsSupplier = () -> {
            try {
                return (Map)actionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The navigation menu's creator. It is not returned by default. It can be embedded via nestedFields.")
    @Valid
    public Creator getCreator() {
        if (this._creatorSupplier != null) {
            this.creator = this._creatorSupplier.get();
            this._creatorSupplier = null;
        }
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
        this._creatorSupplier = null;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        this._creatorSupplier = () -> {
            try {
                return (Creator)creatorUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The navigation menu's creation date.")
    public Date getDateCreated() {
        if (this._dateCreatedSupplier != null) {
            this.dateCreated = this._dateCreatedSupplier.get();
            this._dateCreatedSupplier = null;
        }
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this._dateCreatedSupplier = null;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        this._dateCreatedSupplier = () -> {
            try {
                return (Date)dateCreatedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The last time the navigation menu changed.")
    public Date getDateModified() {
        if (this._dateModifiedSupplier != null) {
            this.dateModified = this._dateModifiedSupplier.get();
            this._dateModifiedSupplier = null;
        }
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
        this._dateModifiedSupplier = null;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        this._dateModifiedSupplier = () -> {
            try {
                return (Date)dateModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The navigation menu's external reference code.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The navigation menu's ID.")
    public Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The navigation menu's name.")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The list of navigation menu items this navigation menu has.")
    @Valid
    public NavigationMenuItem[] getNavigationMenuItems() {
        if (this._navigationMenuItemsSupplier != null) {
            this.navigationMenuItems = this._navigationMenuItemsSupplier.get();
            this._navigationMenuItemsSupplier = null;
        }
        return this.navigationMenuItems;
    }

    public void setNavigationMenuItems(NavigationMenuItem[] navigationMenuItems) {
        this.navigationMenuItems = navigationMenuItems;
        this._navigationMenuItemsSupplier = null;
    }

    @JsonIgnore
    public void setNavigationMenuItems(UnsafeSupplier<NavigationMenuItem[], Exception> navigationMenuItemsUnsafeSupplier) {
        this._navigationMenuItemsSupplier = () -> {
            try {
                return (NavigationMenuItem[])navigationMenuItemsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The navigation menu's type (primary, secondary, social).")
    @JsonGetter(value="navigationType")
    @Valid
    public NavigationType getNavigationType() {
        if (this._navigationTypeSupplier != null) {
            this.navigationType = this._navigationTypeSupplier.get();
            this._navigationTypeSupplier = null;
        }
        return this.navigationType;
    }

    @JsonIgnore
    public String getNavigationTypeAsString() {
        NavigationType navigationType = this.getNavigationType();
        if (navigationType == null) {
            return null;
        }
        return navigationType.toString();
    }

    public void setNavigationType(NavigationType navigationType) {
        this.navigationType = navigationType;
        this._navigationTypeSupplier = null;
    }

    @JsonIgnore
    public void setNavigationType(UnsafeSupplier<NavigationType, Exception> navigationTypeUnsafeSupplier) {
        this._navigationTypeSupplier = () -> {
            try {
                return (NavigationType)((Object)((Object)navigationTypeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Permission[] getPermissions() {
        if (this._permissionsSupplier != null) {
            this.permissions = this._permissionsSupplier.get();
            this._permissionsSupplier = null;
        }
        return this.permissions;
    }

    public void setPermissions(Permission[] permissions) {
        this.permissions = permissions;
        this._permissionsSupplier = null;
    }

    @JsonIgnore
    public void setPermissions(UnsafeSupplier<Permission[], Exception> permissionsUnsafeSupplier) {
        this._permissionsSupplier = () -> {
            try {
                return (Permission[])permissionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The ID of the site to which this navigation menu is scoped.")
    public Long getSiteId() {
        if (this._siteIdSupplier != null) {
            this.siteId = this._siteIdSupplier.get();
            this._siteIdSupplier = null;
        }
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
        this._siteIdSupplier = null;
    }

    @JsonIgnore
    public void setSiteId(UnsafeSupplier<Long, Exception> siteIdUnsafeSupplier) {
        this._siteIdSupplier = () -> {
            try {
                return (Long)siteIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NavigationMenu)) {
            return false;
        }
        NavigationMenu navigationMenu = (NavigationMenu)object;
        return Objects.equals(this.toString(), navigationMenu.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Long siteId;
        Permission[] permissions;
        NavigationType navigationType;
        NavigationMenuItem[] navigationMenuItems;
        String name;
        Long id;
        String externalReferenceCode;
        Date dateModified;
        Date dateCreated;
        Creator creator;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Map<String, Map<String, String>> actions = this.getActions();
        if (actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(NavigationMenu._toJSON(actions));
        }
        if ((creator = this.getCreator()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append((Object)creator);
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(NavigationMenu._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(NavigationMenu._escape(name));
            sb.append("\"");
        }
        if ((navigationMenuItems = this.getNavigationMenuItems()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"navigationMenuItems\": ");
            sb.append("[");
            for (int i = 0; i < navigationMenuItems.length; ++i) {
                sb.append(String.valueOf(navigationMenuItems[i]));
                if (i + 1 >= navigationMenuItems.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((navigationType = this.getNavigationType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"navigationType\": ");
            sb.append("\"");
            sb.append((Object)navigationType);
            sb.append("\"");
        }
        if ((permissions = this.getPermissions()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"permissions\": ");
            sb.append("[");
            for (int i = 0; i < permissions.length; ++i) {
                sb.append((Object)permissions[i]);
                if (i + 1 >= permissions.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((siteId = this.getSiteId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append((Object)siteId);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(NavigationMenu._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (NavigationMenu._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(NavigationMenu._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(NavigationMenu._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(NavigationMenu._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="NavigationType")
    public static enum NavigationType {
        PRIMARY("Primary"),
        SECONDARY("Secondary"),
        SOCIAL("Social");

        private final String _value;

        @JsonCreator
        public static NavigationType create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (NavigationType navigationType : NavigationType.values()) {
                if (!Objects.equals(navigationType.getValue(), value)) continue;
                return navigationType;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private NavigationType(String value) {
            this._value = value;
        }
    }
}

