/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.site.dto.v1_0.Config;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="A fragment image.", value="FragmentImage")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="FragmentImage")
public class FragmentImage
implements Serializable {
    @GraphQLField(description="Represents the Adaptive Media fragment image configuration for different viewports.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Represents the Adaptive Media fragment image configuration for different viewports.") Config config;
    @JsonIgnore
    private Supplier<Config> _configSupplier;
    @GraphQLField(description="The fragment image's description.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The fragment image's description.") Object description;
    @JsonIgnore
    private Supplier<Object> _descriptionSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected ItemExternalReference itemExternalReference;
    @JsonIgnore
    private Supplier<ItemExternalReference> _itemExternalReferenceSupplier;
    @GraphQLField(description="The fragment image's title.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The fragment image's title.") Object title;
    @JsonIgnore
    private Supplier<Object> _titleSupplier;
    @GraphQLField(description="The fragment image's url. Can be inline or mapped to an external value.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The fragment image's url. Can be inline or mapped to an external value.") Object url;
    @JsonIgnore
    private Supplier<Object> _urlSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.FragmentImage", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static FragmentImage toDTO(String json) {
        return (FragmentImage)ObjectMapperUtil.readValue(FragmentImage.class, (String)json);
    }

    public static FragmentImage unsafeToDTO(String json) {
        return (FragmentImage)ObjectMapperUtil.unsafeReadValue(FragmentImage.class, (String)json);
    }

    @Schema(description="Represents the Adaptive Media fragment image configuration for different viewports.")
    @Valid
    public Config getConfig() {
        if (this._configSupplier != null) {
            this.config = this._configSupplier.get();
            this._configSupplier = null;
        }
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
        this._configSupplier = null;
    }

    @JsonIgnore
    public void setConfig(UnsafeSupplier<Config, Exception> configUnsafeSupplier) {
        this._configSupplier = () -> {
            try {
                return (Config)configUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The fragment image's description.")
    @Valid
    public Object getDescription() {
        if (this._descriptionSupplier != null) {
            this.description = this._descriptionSupplier.get();
            this._descriptionSupplier = null;
        }
        return this.description;
    }

    public void setDescription(Object description) {
        this.description = description;
        this._descriptionSupplier = null;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<Object, Exception> descriptionUnsafeSupplier) {
        this._descriptionSupplier = () -> {
            try {
                return descriptionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public ItemExternalReference getItemExternalReference() {
        if (this._itemExternalReferenceSupplier != null) {
            this.itemExternalReference = this._itemExternalReferenceSupplier.get();
            this._itemExternalReferenceSupplier = null;
        }
        return this.itemExternalReference;
    }

    public void setItemExternalReference(ItemExternalReference itemExternalReference) {
        this.itemExternalReference = itemExternalReference;
        this._itemExternalReferenceSupplier = null;
    }

    @JsonIgnore
    public void setItemExternalReference(UnsafeSupplier<ItemExternalReference, Exception> itemExternalReferenceUnsafeSupplier) {
        this._itemExternalReferenceSupplier = () -> {
            try {
                return (ItemExternalReference)itemExternalReferenceUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The fragment image's title.")
    @Valid
    public Object getTitle() {
        if (this._titleSupplier != null) {
            this.title = this._titleSupplier.get();
            this._titleSupplier = null;
        }
        return this.title;
    }

    public void setTitle(Object title) {
        this.title = title;
        this._titleSupplier = null;
    }

    @JsonIgnore
    public void setTitle(UnsafeSupplier<Object, Exception> titleUnsafeSupplier) {
        this._titleSupplier = () -> {
            try {
                return titleUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The fragment image's url. Can be inline or mapped to an external value.")
    @Valid
    public Object getUrl() {
        if (this._urlSupplier != null) {
            this.url = this._urlSupplier.get();
            this._urlSupplier = null;
        }
        return this.url;
    }

    public void setUrl(Object url) {
        this.url = url;
        this._urlSupplier = null;
    }

    @JsonIgnore
    public void setUrl(UnsafeSupplier<Object, Exception> urlUnsafeSupplier) {
        this._urlSupplier = () -> {
            try {
                return urlUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FragmentImage)) {
            return false;
        }
        FragmentImage fragmentImage = (FragmentImage)object;
        return Objects.equals(this.toString(), fragmentImage.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Object url;
        Object title;
        ItemExternalReference itemExternalReference;
        Object description;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Config config = this.getConfig();
        if (config != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"config\": ");
            sb.append(String.valueOf(config));
        }
        if ((description = this.getDescription()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            if (description instanceof Map) {
                sb.append((Object)JSONFactoryUtil.createJSONObject((Map)((Map)description)));
            } else if (description instanceof String) {
                sb.append("\"");
                sb.append(FragmentImage._escape((String)description));
                sb.append("\"");
            } else {
                sb.append(description);
            }
        }
        if ((itemExternalReference = this.getItemExternalReference()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"itemExternalReference\": ");
            sb.append(String.valueOf(itemExternalReference));
        }
        if ((title = this.getTitle()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"title\": ");
            if (title instanceof Map) {
                sb.append((Object)JSONFactoryUtil.createJSONObject((Map)((Map)title)));
            } else if (title instanceof String) {
                sb.append("\"");
                sb.append(FragmentImage._escape((String)title));
                sb.append("\"");
            } else {
                sb.append(title);
            }
        }
        if ((url = this.getUrl()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"url\": ");
            if (url instanceof Map) {
                sb.append((Object)JSONFactoryUtil.createJSONObject((Map)((Map)url)));
            } else if (url instanceof String) {
                sb.append("\"");
                sb.append(FragmentImage._escape((String)url));
                sb.append("\"");
            } else {
                sb.append(url);
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(FragmentImage._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (FragmentImage._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(FragmentImage._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(FragmentImage._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(FragmentImage._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

