/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.liferay.headless.admin.site.dto.v1_0.CustomMetaTag;
import com.liferay.headless.admin.site.dto.v1_0.OpenGraphSettings;
import com.liferay.headless.admin.site.dto.v1_0.PageSettings;
import com.liferay.headless.admin.site.dto.v1_0.SEOSettings;
import com.liferay.headless.admin.site.dto.v1_0.SitePageNavigationSettings;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@GraphQLName(description="The settings of a content page.", value="ContentPageSettings")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="ContentPageSettings")
public class ContentPageSettings
extends PageSettings
implements Serializable {
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.ContentPageSettings", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static ContentPageSettings toDTO(String json) {
        return (ContentPageSettings)ObjectMapperUtil.readValue(ContentPageSettings.class, (String)json);
    }

    public static ContentPageSettings unsafeToDTO(String json) {
        return (ContentPageSettings)ObjectMapperUtil.unsafeReadValue(ContentPageSettings.class, (String)json);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ContentPageSettings)) {
            return false;
        }
        ContentPageSettings contentPageSettings = (ContentPageSettings)object;
        return Objects.equals(this.toString(), contentPageSettings.toString());
    }

    @Override
    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    @Override
    public String toString() {
        PageSettings.Type type;
        SEOSettings seoSettings;
        Integer priority;
        OpenGraphSettings openGraphSettings;
        SitePageNavigationSettings navigationSettings;
        Boolean hiddenFromNavigation;
        StringBundler sb = new StringBundler();
        sb.append("{");
        CustomMetaTag[] customMetaTags = this.getCustomMetaTags();
        if (customMetaTags != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customMetaTags\": ");
            sb.append("[");
            for (int i = 0; i < customMetaTags.length; ++i) {
                sb.append(String.valueOf(customMetaTags[i]));
                if (i + 1 >= customMetaTags.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((hiddenFromNavigation = this.getHiddenFromNavigation()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"hiddenFromNavigation\": ");
            sb.append((Object)hiddenFromNavigation);
        }
        if ((navigationSettings = this.getNavigationSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"navigationSettings\": ");
            sb.append(String.valueOf(navigationSettings));
        }
        if ((openGraphSettings = this.getOpenGraphSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"openGraphSettings\": ");
            sb.append(String.valueOf(openGraphSettings));
        }
        if ((priority = this.getPriority()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"priority\": ");
            sb.append((Object)priority);
        }
        if ((seoSettings = this.getSeoSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"seoSettings\": ");
            sb.append(String.valueOf(seoSettings));
        }
        if ((type = this.getType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append((Object)type);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(ContentPageSettings._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (ContentPageSettings._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(ContentPageSettings._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(ContentPageSettings._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(ContentPageSettings._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

