/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="The widget page template's site navigation settings.", value="NavigationSettings")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="NavigationSettings")
public class NavigationSettings
implements Serializable {
    @GraphQLField(description="The ID of the target specific frame.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The ID of the target specific frame.") String target;
    @JsonIgnore
    private Supplier<String> _targetSupplier;
    @GraphQLField(description="The target's type (specific frame or new tab).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The target's type (specific frame or new tab).") TargetType targetType;
    @JsonIgnore
    private Supplier<TargetType> _targetTypeSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.NavigationSettings", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static NavigationSettings toDTO(String json) {
        return (NavigationSettings)ObjectMapperUtil.readValue(NavigationSettings.class, (String)json);
    }

    public static NavigationSettings unsafeToDTO(String json) {
        return (NavigationSettings)ObjectMapperUtil.unsafeReadValue(NavigationSettings.class, (String)json);
    }

    @Schema(description="The ID of the target specific frame.")
    public String getTarget() {
        if (this._targetSupplier != null) {
            this.target = this._targetSupplier.get();
            this._targetSupplier = null;
        }
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        this._targetSupplier = null;
    }

    @JsonIgnore
    public void setTarget(UnsafeSupplier<String, Exception> targetUnsafeSupplier) {
        this._targetSupplier = () -> {
            try {
                return (String)targetUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The target's type (specific frame or new tab).")
    @JsonGetter(value="targetType")
    @Valid
    public TargetType getTargetType() {
        if (this._targetTypeSupplier != null) {
            this.targetType = this._targetTypeSupplier.get();
            this._targetTypeSupplier = null;
        }
        return this.targetType;
    }

    @JsonIgnore
    public String getTargetTypeAsString() {
        TargetType targetType = this.getTargetType();
        if (targetType == null) {
            return null;
        }
        return targetType.toString();
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
        this._targetTypeSupplier = null;
    }

    @JsonIgnore
    public void setTargetType(UnsafeSupplier<TargetType, Exception> targetTypeUnsafeSupplier) {
        this._targetTypeSupplier = () -> {
            try {
                return (TargetType)((Object)((Object)targetTypeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NavigationSettings)) {
            return false;
        }
        NavigationSettings navigationSettings = (NavigationSettings)object;
        return Objects.equals(this.toString(), navigationSettings.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        TargetType targetType;
        StringBundler sb = new StringBundler();
        sb.append("{");
        String target = this.getTarget();
        if (target != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"target\": ");
            sb.append("\"");
            sb.append(NavigationSettings._escape(target));
            sb.append("\"");
        }
        if ((targetType = this.getTargetType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"targetType\": ");
            sb.append("\"");
            sb.append((Object)targetType);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(NavigationSettings._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (NavigationSettings._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(NavigationSettings._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(NavigationSettings._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(NavigationSettings._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="TargetType")
    public static enum TargetType {
        SPECIFIC_FRAME("SpecificFrame"),
        NEW_TAB("NewTab");

        private final String _value;

        @JsonCreator
        public static TargetType create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (TargetType targetType : TargetType.values()) {
                if (!Objects.equals(targetType.getValue(), value)) continue;
                return targetType;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private TargetType(String value) {
            this._value = value;
        }
    }
}

