/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="The widget instance's permissions.", value="WidgetPermission")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="WidgetPermission")
public class WidgetPermission
implements Serializable {
    @GraphQLField(description="The IDs of the actions the role has permission for.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The IDs of the actions the role has permission for.") String[] actionIds;
    @JsonIgnore
    private Supplier<String[]> _actionIdsSupplier;
    @GraphQLField(description="The role's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The role's name.") String roleName;
    @JsonIgnore
    private Supplier<String> _roleNameSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.WidgetPermission", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static WidgetPermission toDTO(String json) {
        return (WidgetPermission)ObjectMapperUtil.readValue(WidgetPermission.class, (String)json);
    }

    public static WidgetPermission unsafeToDTO(String json) {
        return (WidgetPermission)ObjectMapperUtil.unsafeReadValue(WidgetPermission.class, (String)json);
    }

    @Schema(description="The IDs of the actions the role has permission for.")
    public String[] getActionIds() {
        if (this._actionIdsSupplier != null) {
            this.actionIds = this._actionIdsSupplier.get();
            this._actionIdsSupplier = null;
        }
        return this.actionIds;
    }

    public void setActionIds(String[] actionIds) {
        this.actionIds = actionIds;
        this._actionIdsSupplier = null;
    }

    @JsonIgnore
    public void setActionIds(UnsafeSupplier<String[], Exception> actionIdsUnsafeSupplier) {
        this._actionIdsSupplier = () -> {
            try {
                return (String[])actionIdsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The role's name.")
    public String getRoleName() {
        if (this._roleNameSupplier != null) {
            this.roleName = this._roleNameSupplier.get();
            this._roleNameSupplier = null;
        }
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
        this._roleNameSupplier = null;
    }

    @JsonIgnore
    public void setRoleName(UnsafeSupplier<String, Exception> roleNameUnsafeSupplier) {
        this._roleNameSupplier = () -> {
            try {
                return (String)roleNameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WidgetPermission)) {
            return false;
        }
        WidgetPermission widgetPermission = (WidgetPermission)object;
        return Objects.equals(this.toString(), widgetPermission.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String roleName;
        StringBundler sb = new StringBundler();
        sb.append("{");
        String[] actionIds = this.getActionIds();
        if (actionIds != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actionIds\": ");
            sb.append("[");
            for (int i = 0; i < actionIds.length; ++i) {
                sb.append("\"");
                sb.append(WidgetPermission._escape(actionIds[i]));
                sb.append("\"");
                if (i + 1 >= actionIds.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((roleName = this.getRoleName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"roleName\": ");
            sb.append("\"");
            sb.append(WidgetPermission._escape(roleName));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(WidgetPermission._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (WidgetPermission._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(WidgetPermission._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WidgetPermission._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(WidgetPermission._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

