/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.site.dto.v1_0.CustomMetaTag;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.NavigationSettings;
import com.liferay.headless.admin.site.dto.v1_0.OpenGraphSettings;
import com.liferay.headless.admin.site.dto.v1_0.PageSettings;
import com.liferay.headless.admin.site.dto.v1_0.SEOSettings;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="The settings of a widget page.", value="WidgetPageSettings")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="WidgetPageSettings")
public class WidgetPageSettings
extends PageSettings
implements Serializable {
    @GraphQLField(description="A flag that indicates whether the widget page is customizable.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A flag that indicates whether the widget page is customizable.") Boolean customizable;
    @JsonIgnore
    private Supplier<Boolean> _customizableSupplier;
    @GraphQLField(description="The IDs of the customizable sections.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The IDs of the customizable sections.") String[] customizableSectionIds;
    @JsonIgnore
    private Supplier<String[]> _customizableSectionIdsSupplier;
    @GraphQLField(description="Whether this widget page will inherit changes made to the associated widget page template.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Whether this widget page will inherit changes made to the associated widget page template.") Boolean inheritChanges;
    @JsonIgnore
    private Supplier<Boolean> _inheritChangesSupplier;
    @GraphQLField(description="The ID of the layout template.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The ID of the layout template.") String layoutTemplateId;
    @JsonIgnore
    private Supplier<String> _layoutTemplateIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected ItemExternalReference widgetPageTemplateReference;
    @JsonIgnore
    private Supplier<ItemExternalReference> _widgetPageTemplateReferenceSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.WidgetPageSettings", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static WidgetPageSettings toDTO(String json) {
        return (WidgetPageSettings)ObjectMapperUtil.readValue(WidgetPageSettings.class, (String)json);
    }

    public static WidgetPageSettings unsafeToDTO(String json) {
        return (WidgetPageSettings)ObjectMapperUtil.unsafeReadValue(WidgetPageSettings.class, (String)json);
    }

    @Schema(description="A flag that indicates whether the widget page is customizable.")
    public Boolean getCustomizable() {
        if (this._customizableSupplier != null) {
            this.customizable = this._customizableSupplier.get();
            this._customizableSupplier = null;
        }
        return this.customizable;
    }

    public void setCustomizable(Boolean customizable) {
        this.customizable = customizable;
        this._customizableSupplier = null;
    }

    @JsonIgnore
    public void setCustomizable(UnsafeSupplier<Boolean, Exception> customizableUnsafeSupplier) {
        this._customizableSupplier = () -> {
            try {
                return (Boolean)customizableUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The IDs of the customizable sections.")
    public String[] getCustomizableSectionIds() {
        if (this._customizableSectionIdsSupplier != null) {
            this.customizableSectionIds = this._customizableSectionIdsSupplier.get();
            this._customizableSectionIdsSupplier = null;
        }
        return this.customizableSectionIds;
    }

    public void setCustomizableSectionIds(String[] customizableSectionIds) {
        this.customizableSectionIds = customizableSectionIds;
        this._customizableSectionIdsSupplier = null;
    }

    @JsonIgnore
    public void setCustomizableSectionIds(UnsafeSupplier<String[], Exception> customizableSectionIdsUnsafeSupplier) {
        this._customizableSectionIdsSupplier = () -> {
            try {
                return (String[])customizableSectionIdsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Whether this widget page will inherit changes made to the associated widget page template.")
    public Boolean getInheritChanges() {
        if (this._inheritChangesSupplier != null) {
            this.inheritChanges = this._inheritChangesSupplier.get();
            this._inheritChangesSupplier = null;
        }
        return this.inheritChanges;
    }

    public void setInheritChanges(Boolean inheritChanges) {
        this.inheritChanges = inheritChanges;
        this._inheritChangesSupplier = null;
    }

    @JsonIgnore
    public void setInheritChanges(UnsafeSupplier<Boolean, Exception> inheritChangesUnsafeSupplier) {
        this._inheritChangesSupplier = () -> {
            try {
                return (Boolean)inheritChangesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The ID of the layout template.")
    public String getLayoutTemplateId() {
        if (this._layoutTemplateIdSupplier != null) {
            this.layoutTemplateId = this._layoutTemplateIdSupplier.get();
            this._layoutTemplateIdSupplier = null;
        }
        return this.layoutTemplateId;
    }

    public void setLayoutTemplateId(String layoutTemplateId) {
        this.layoutTemplateId = layoutTemplateId;
        this._layoutTemplateIdSupplier = null;
    }

    @JsonIgnore
    public void setLayoutTemplateId(UnsafeSupplier<String, Exception> layoutTemplateIdUnsafeSupplier) {
        this._layoutTemplateIdSupplier = () -> {
            try {
                return (String)layoutTemplateIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public ItemExternalReference getWidgetPageTemplateReference() {
        if (this._widgetPageTemplateReferenceSupplier != null) {
            this.widgetPageTemplateReference = this._widgetPageTemplateReferenceSupplier.get();
            this._widgetPageTemplateReferenceSupplier = null;
        }
        return this.widgetPageTemplateReference;
    }

    public void setWidgetPageTemplateReference(ItemExternalReference widgetPageTemplateReference) {
        this.widgetPageTemplateReference = widgetPageTemplateReference;
        this._widgetPageTemplateReferenceSupplier = null;
    }

    @JsonIgnore
    public void setWidgetPageTemplateReference(UnsafeSupplier<ItemExternalReference, Exception> widgetPageTemplateReferenceUnsafeSupplier) {
        this._widgetPageTemplateReferenceSupplier = () -> {
            try {
                return (ItemExternalReference)widgetPageTemplateReferenceUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WidgetPageSettings)) {
            return false;
        }
        WidgetPageSettings widgetPageSettings = (WidgetPageSettings)object;
        return Objects.equals(this.toString(), widgetPageSettings.toString());
    }

    @Override
    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    @Override
    public String toString() {
        PageSettings.Type type;
        SEOSettings seoSettings;
        Integer priority;
        OpenGraphSettings openGraphSettings;
        NavigationSettings navigationSettings;
        Boolean hiddenFromNavigation;
        CustomMetaTag[] customMetaTags;
        ItemExternalReference widgetPageTemplateReference;
        String layoutTemplateId;
        Boolean inheritChanges;
        String[] customizableSectionIds;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Boolean customizable = this.getCustomizable();
        if (customizable != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customizable\": ");
            sb.append((Object)customizable);
        }
        if ((customizableSectionIds = this.getCustomizableSectionIds()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customizableSectionIds\": ");
            sb.append("[");
            for (int i = 0; i < customizableSectionIds.length; ++i) {
                sb.append("\"");
                sb.append(WidgetPageSettings._escape(customizableSectionIds[i]));
                sb.append("\"");
                if (i + 1 >= customizableSectionIds.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((inheritChanges = this.getInheritChanges()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"inheritChanges\": ");
            sb.append((Object)inheritChanges);
        }
        if ((layoutTemplateId = this.getLayoutTemplateId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"layoutTemplateId\": ");
            sb.append("\"");
            sb.append(WidgetPageSettings._escape(layoutTemplateId));
            sb.append("\"");
        }
        if ((widgetPageTemplateReference = this.getWidgetPageTemplateReference()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"widgetPageTemplateReference\": ");
            sb.append(String.valueOf(widgetPageTemplateReference));
        }
        if ((customMetaTags = this.getCustomMetaTags()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customMetaTags\": ");
            sb.append("[");
            for (int i = 0; i < customMetaTags.length; ++i) {
                sb.append(String.valueOf(customMetaTags[i]));
                if (i + 1 >= customMetaTags.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((hiddenFromNavigation = this.getHiddenFromNavigation()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"hiddenFromNavigation\": ");
            sb.append((Object)hiddenFromNavigation);
        }
        if ((navigationSettings = this.getNavigationSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"navigationSettings\": ");
            sb.append(String.valueOf(navigationSettings));
        }
        if ((openGraphSettings = this.getOpenGraphSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"openGraphSettings\": ");
            sb.append(String.valueOf(openGraphSettings));
        }
        if ((priority = this.getPriority()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"priority\": ");
            sb.append((Object)priority);
        }
        if ((seoSettings = this.getSeoSettings()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"seoSettings\": ");
            sb.append(String.valueOf(seoSettings));
        }
        if ((type = this.getType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append((Object)type);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(WidgetPageSettings._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (WidgetPageSettings._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(WidgetPageSettings._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WidgetPageSettings._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(WidgetPageSettings._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

