/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="A page element.", value="PageElement")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="PageElement")
public class PageElement
implements Serializable {
    @GraphQLField(description="The page element's definition.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page element's definition.") Object definition;
    @JsonIgnore
    private Supplier<Object> _definitionSupplier;
    @GraphQLField(description="The page element's external reference code. Unique within the site.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page element's external reference code. Unique within the site.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="A list of the page elements this page element has.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of the page elements this page element has.") PageElement[] pageElements;
    @JsonIgnore
    private Supplier<PageElement[]> _pageElementsSupplier;
    @GraphQLField(description="The parent's page element's external reference code. Unique within the site.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The parent's page element's external reference code. Unique within the site.") String parentExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _parentExternalReferenceCodeSupplier;
    @GraphQLField(description="The 0-based position this page element occupies with respect to its siblings (0 for first child, 1 for second child, ...). If not specified when creating a page element the page element will be added at the last valid position.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The 0-based position this page element occupies with respect to its siblings (0 for first child, 1 for second child, ...). If not specified when creating a page element the page element will be added at the last valid position.") Integer position;
    @JsonIgnore
    private Supplier<Integer> _positionSupplier;
    @GraphQLField(description="The page element's type (collection, collection item, column, container, drop zone, form, fragment, fragment composition, fragment drop zone, row, widget or widget section).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page element's type (collection, collection item, column, container, drop zone, form, fragment, fragment composition, fragment drop zone, row, widget or widget section).") Type type;
    @JsonIgnore
    private Supplier<Type> _typeSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.site.dto.v1_0.PageElement", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static PageElement toDTO(String json) {
        return (PageElement)ObjectMapperUtil.readValue(PageElement.class, (String)json);
    }

    public static PageElement unsafeToDTO(String json) {
        return (PageElement)ObjectMapperUtil.unsafeReadValue(PageElement.class, (String)json);
    }

    @Schema(description="The page element's definition.")
    @Valid
    public Object getDefinition() {
        if (this._definitionSupplier != null) {
            this.definition = this._definitionSupplier.get();
            this._definitionSupplier = null;
        }
        return this.definition;
    }

    public void setDefinition(Object definition) {
        this.definition = definition;
        this._definitionSupplier = null;
    }

    @JsonIgnore
    public void setDefinition(UnsafeSupplier<Object, Exception> definitionUnsafeSupplier) {
        this._definitionSupplier = () -> {
            try {
                return definitionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The page element's external reference code. Unique within the site.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A list of the page elements this page element has.")
    @Valid
    public PageElement[] getPageElements() {
        if (this._pageElementsSupplier != null) {
            this.pageElements = this._pageElementsSupplier.get();
            this._pageElementsSupplier = null;
        }
        return this.pageElements;
    }

    public void setPageElements(PageElement[] pageElements) {
        this.pageElements = pageElements;
        this._pageElementsSupplier = null;
    }

    @JsonIgnore
    public void setPageElements(UnsafeSupplier<PageElement[], Exception> pageElementsUnsafeSupplier) {
        this._pageElementsSupplier = () -> {
            try {
                return (PageElement[])pageElementsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The parent's page element's external reference code. Unique within the site.")
    public String getParentExternalReferenceCode() {
        if (this._parentExternalReferenceCodeSupplier != null) {
            this.parentExternalReferenceCode = this._parentExternalReferenceCodeSupplier.get();
            this._parentExternalReferenceCodeSupplier = null;
        }
        return this.parentExternalReferenceCode;
    }

    public void setParentExternalReferenceCode(String parentExternalReferenceCode) {
        this.parentExternalReferenceCode = parentExternalReferenceCode;
        this._parentExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setParentExternalReferenceCode(UnsafeSupplier<String, Exception> parentExternalReferenceCodeUnsafeSupplier) {
        this._parentExternalReferenceCodeSupplier = () -> {
            try {
                return (String)parentExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(description="The 0-based position this page element occupies with respect to its siblings (0 for first child, 1 for second child, ...). If not specified when creating a page element the page element will be added at the last valid position.")
    public @DecimalMin(value="0") Integer getPosition() {
        if (this._positionSupplier != null) {
            this.position = this._positionSupplier.get();
            this._positionSupplier = null;
        }
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
        this._positionSupplier = null;
    }

    @JsonIgnore
    public void setPosition(UnsafeSupplier<Integer, Exception> positionUnsafeSupplier) {
        this._positionSupplier = () -> {
            try {
                return (Integer)positionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @JsonGetter(value="type")
    @Schema(description="The page element's type (collection, collection item, column, container, drop zone, form, fragment, fragment composition, fragment drop zone, row, widget or widget section).")
    @Valid
    public Type getType() {
        if (this._typeSupplier != null) {
            this.type = this._typeSupplier.get();
            this._typeSupplier = null;
        }
        return this.type;
    }

    @JsonIgnore
    public String getTypeAsString() {
        Type type = this.getType();
        if (type == null) {
            return null;
        }
        return type.toString();
    }

    public void setType(Type type) {
        this.type = type;
        this._typeSupplier = null;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<Type, Exception> typeUnsafeSupplier) {
        this._typeSupplier = () -> {
            try {
                return (Type)((Object)((Object)typeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PageElement)) {
            return false;
        }
        PageElement pageElement = (PageElement)object;
        return Objects.equals(this.toString(), pageElement.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Type type;
        Integer position;
        String parentExternalReferenceCode;
        PageElement[] pageElements;
        String externalReferenceCode;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Object definition = this.getDefinition();
        if (definition != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"definition\": ");
            if (definition instanceof Map) {
                sb.append((Object)JSONFactoryUtil.createJSONObject((Map)((Map)definition)));
            } else if (definition instanceof String) {
                sb.append("\"");
                sb.append(PageElement._escape((String)definition));
                sb.append("\"");
            } else {
                sb.append(definition);
            }
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(PageElement._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((pageElements = this.getPageElements()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pageElements\": ");
            sb.append("[");
            for (int i = 0; i < pageElements.length; ++i) {
                sb.append(String.valueOf(pageElements[i]));
                if (i + 1 >= pageElements.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((parentExternalReferenceCode = this.getParentExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(PageElement._escape(parentExternalReferenceCode));
            sb.append("\"");
        }
        if ((position = this.getPosition()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"position\": ");
            sb.append((Object)position);
        }
        if ((type = this.getType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append((Object)type);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(PageElement._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (PageElement._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(PageElement._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(PageElement._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(PageElement._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="Type")
    public static enum Type {
        COLLECTION("Collection"),
        COLLECTION_ITEM("CollectionItem"),
        COLUMN("Column"),
        CONTAINER("Container"),
        DROP_ZONE("DropZone"),
        FORM("Form"),
        FRAGMENT("Fragment"),
        FRAGMENT_COMPOSITION("FragmentComposition"),
        FRAGMENT_DROP_ZONE("FragmentDropZone"),
        ROW("Row"),
        WIDGET("Widget");

        private final String _value;

        @JsonCreator
        public static Type create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Type type : Type.values()) {
                if (!Objects.equals(type.getValue(), value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Type(String value) {
            this._value = value;
        }
    }
}

