/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.configuration.internal.resource.v1_0;

import com.liferay.configuration.admin.exportimport.ConfigurationExportImportProcessor;
import com.liferay.configuration.admin.util.ConfigurationFilterStringUtil;
import com.liferay.headless.admin.configuration.dto.v1_0.SiteConfiguration;
import com.liferay.headless.admin.configuration.internal.resource.v1_0.BaseSiteConfigurationResourceImpl;
import com.liferay.headless.admin.configuration.internal.util.ConfigurationUtil;
import com.liferay.headless.admin.configuration.resource.v1_0.SiteConfigurationResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.pagination.Page;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/site-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={SiteConfigurationResource.class})
public class SiteConfigurationResourceImpl
extends BaseSiteConfigurationResourceImpl {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationExportImportProcessor _configurationExportImportProcessor;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private SettingsLocatorHelper _settingsLocatorHelper;

    @Override
    public SiteConfiguration getSiteSiteConfiguration(String siteExternalReferenceCode, String siteConfigurationExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-65399")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(siteExternalReferenceCode, this.contextCompany.getCompanyId());
        this._checkPermission(group.getGroupId());
        Object[] configurations = this._configurationAdmin.listConfigurations(ConfigurationFilterStringUtil.getGroupScopedFilterString((String)String.valueOf(group.getGroupId()), (String)siteConfigurationExternalReferenceCode, (String)siteExternalReferenceCode));
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            throw new NotFoundException("Unable to find site configuration with external reference code " + siteConfigurationExternalReferenceCode);
        }
        if (configurations.length > 1) {
            ArrayList<String> pids = new ArrayList<String>();
            for (Object configuration : configurations) {
                pids.add(configuration.getPid());
            }
            throw new BadRequestException(StringBundler.concat((String[])new String[]{siteConfigurationExternalReferenceCode, " is a factory configuration. Specify one of these PIDs: ", ListUtil.toString(pids, (String)"", (String)","), "."}));
        }
        return this._toSiteConfiguration((Configuration)configurations[0]);
    }

    @Override
    public Page<SiteConfiguration> getSiteSiteConfigurationsPage(String siteExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-65399")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(siteExternalReferenceCode, this.contextCompany.getCompanyId());
        this._checkPermission(group.getGroupId());
        Object[] configurations = this._configurationAdmin.listConfigurations(ConfigurationFilterStringUtil.getGroupScopedFilterString((String)String.valueOf(group.getGroupId()), (String)siteExternalReferenceCode));
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            return Page.of(Collections.emptyList());
        }
        ArrayList<SiteConfiguration> siteConfigurations = new ArrayList<SiteConfiguration>();
        for (Object configuration : configurations) {
            SiteConfiguration siteConfiguration = this._toSiteConfiguration((Configuration)configuration);
            if (siteConfiguration == null) continue;
            siteConfigurations.add(siteConfiguration);
        }
        return Page.of(siteConfigurations);
    }

    private void _checkPermission(long groupId) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!(permissionChecker.isCompanyAdmin() || permissionChecker.isGroupAdmin(groupId) || permissionChecker.isOmniadmin())) {
            throw new NotAuthorizedException((Object)Response.Status.UNAUTHORIZED, new Object[0]);
        }
    }

    private SiteConfiguration _toSiteConfiguration(Configuration configuration) throws Exception {
        Map<String, Object> properties = ConfigurationUtil.getProperties(configuration, this._configurationExportImportProcessor, this._settingsLocatorHelper);
        if (properties.isEmpty()) {
            return null;
        }
        SiteConfiguration siteConfiguration = new SiteConfiguration();
        siteConfiguration.setExternalReferenceCode(() -> ((Configuration)configuration).getPid());
        siteConfiguration.setProperties(() -> properties);
        return siteConfiguration;
    }
}

