/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.configuration.internal.resource.v1_0;

import com.liferay.configuration.admin.exportimport.ConfigurationExportImportProcessor;
import com.liferay.configuration.admin.util.ConfigurationFilterStringUtil;
import com.liferay.headless.admin.configuration.dto.v1_0.InstanceConfiguration;
import com.liferay.headless.admin.configuration.internal.resource.v1_0.BaseInstanceConfigurationResourceImpl;
import com.liferay.headless.admin.configuration.internal.util.ConfigurationUtil;
import com.liferay.headless.admin.configuration.resource.v1_0.InstanceConfigurationResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.pagination.Page;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/instance-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={InstanceConfigurationResource.class})
public class InstanceConfigurationResourceImpl
extends BaseInstanceConfigurationResourceImpl {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationExportImportProcessor _configurationExportImportProcessor;
    @Reference
    private SettingsLocatorHelper _settingsLocatorHelper;

    @Override
    public InstanceConfiguration getInstanceConfiguration(String instanceConfigurationExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-65399")) {
            throw new UnsupportedOperationException();
        }
        this._checkPermission();
        Object[] configurations = this._configurationAdmin.listConfigurations(ConfigurationFilterStringUtil.getCompanyScopedFilterString((String)String.valueOf(this.contextCompany.getCompanyId()), (String)instanceConfigurationExternalReferenceCode, (String)this.contextCompany.getDefaultWebId()));
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            throw new NotFoundException("Unable to find instance configuration with external reference code " + instanceConfigurationExternalReferenceCode);
        }
        if (configurations.length > 1) {
            ArrayList<String> pids = new ArrayList<String>();
            for (Object configuration : configurations) {
                pids.add(configuration.getPid());
            }
            throw new BadRequestException(StringBundler.concat((String[])new String[]{instanceConfigurationExternalReferenceCode, " is a factory configuration. Specify one of these PIDs: ", ListUtil.toString(pids, (String)"", (String)","), "."}));
        }
        return this._toInstanceConfiguration((Configuration)configurations[0]);
    }

    @Override
    public Page<InstanceConfiguration> getInstanceConfigurationsPage() throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-65399")) {
            throw new UnsupportedOperationException();
        }
        this._checkPermission();
        Object[] configurations = this._configurationAdmin.listConfigurations(ConfigurationFilterStringUtil.getCompanyScopedFilterString((String)String.valueOf(this.contextCompany.getCompanyId()), (String)this.contextCompany.getDefaultWebId()));
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            return Page.of(Collections.emptyList());
        }
        ArrayList<InstanceConfiguration> instanceConfigurations = new ArrayList<InstanceConfiguration>();
        for (Object configuration : configurations) {
            InstanceConfiguration instanceConfiguration = this._toInstanceConfiguration((Configuration)configuration);
            if (instanceConfiguration == null) continue;
            instanceConfigurations.add(instanceConfiguration);
        }
        return Page.of(instanceConfigurations);
    }

    private void _checkPermission() {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin() && !permissionChecker.isOmniadmin()) {
            throw new NotAuthorizedException((Object)Response.Status.UNAUTHORIZED, new Object[0]);
        }
    }

    private InstanceConfiguration _toInstanceConfiguration(Configuration configuration) throws Exception {
        Map<String, Object> properties = ConfigurationUtil.getProperties(configuration, this._configurationExportImportProcessor, this._settingsLocatorHelper);
        if (properties.isEmpty()) {
            return null;
        }
        InstanceConfiguration instanceConfiguration = new InstanceConfiguration();
        instanceConfiguration.setExternalReferenceCode(() -> ((Configuration)configuration).getPid());
        instanceConfiguration.setProperties(() -> properties);
        return instanceConfiguration;
    }
}

