/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.tasks.WatchTask;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.War;

public class LiferayWarPlugin
implements Plugin<Project> {
    public static final String BUILD_WAR_DIR_TASK_NAME = "buildWarDir";
    public static final String WATCH_TASK_NAME = "watch";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, WarPlugin.class);
        War war = (War)GradleUtil.getTask((Project)project, (String)"war");
        Sync buildWarDirSync = this._addTaskBuildWarDir(project, war);
        this._addTaskWatch(buildWarDirSync, war);
    }

    private Sync _addTaskBuildWarDir(final Project project, final War war) {
        Sync sync = (Sync)GradleUtil.addTask((Project)project, (String)BUILD_WAR_DIR_TASK_NAME, Sync.class);
        sync.dependsOn(new Object[]{war});
        sync.from(new Object[]{new Callable<FileTree>(){

            @Override
            public FileTree call() throws Exception {
                return project.zipTree((Object)war.getArchivePath());
            }
        }});
        sync.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), LiferayWarPlugin.BUILD_WAR_DIR_TASK_NAME);
            }
        });
        sync.setDescription("Unzips the project's WAR file into a temporary directory.");
        return sync;
    }

    private WatchTask _addTaskWatch(final Sync buildWarDirSync, final War war) {
        WatchTask watchTask = (WatchTask)GradleUtil.addTask((Project)buildWarDirSync.getProject(), (String)WATCH_TASK_NAME, WatchTask.class);
        watchTask.dependsOn(new Object[]{buildWarDirSync});
        watchTask.setBundleDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return buildWarDirSync.getDestinationDir();
            }
        });
        watchTask.setBundleSymbolicName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return war.getBaseName();
            }
        });
        watchTask.setDescription("Continuously redeploys the project's WAR dir.");
        watchTask.setGroup("build");
        return watchTask;
    }
}

