/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.NodeDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.internal.util.StringUtil;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.ExecutePackageManagerTask;
import com.liferay.gradle.plugins.node.tasks.YarnInstallTask;
import groovy.json.JsonSlurper;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;

public class LiferayYarnPlugin
implements Plugin<Project> {
    public static final String YARN_CHECK_FORMAT_TASK_NAME = "yarnCheckFormat";
    public static final String YARN_FORMAT_TASK_NAME = "yarnFormat";
    public static final String YARN_INSTALL_TASK_NAME = "yarnInstall";
    public static final String YARN_LOCK_TASK_NAME = "yarnLock";
    private static final String _CHECK_FORMAT_SCRIPT_NAME = "checkFormat";
    private static final String _FORMAT_SCRIPT_NAME = "format";
    private static final List<String> _excludes = Arrays.asList("**/bin/", "**/build/", "**/classes/", "**/node_modules/", "**/node_modules_cache/", "**/test-classes/", "**/tmp/");
    private static final List<String> _includes = Arrays.asList("yarn.lock", "private/yarn.lock", "apps/*/yarn.lock", "private/apps/*/yarn.lock");

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        GradleUtil.applyPlugin((Project)project, NodeDefaultsPlugin.class);
        this._addTaskYarnCheckFormat(project);
        this._addTaskYarnFormat(project);
        this._addTaskYarnInstall(project);
        this._addTaskYarnLock(project);
    }

    private ExecutePackageManagerTask _addTaskYarnCheckFormat(File yarnLockFile, Project project) {
        File workingDir = yarnLockFile.getParentFile();
        String suffix = StringUtil.camelCase(workingDir.getName(), true);
        ExecutePackageManagerTask executePackageManagerTask = (ExecutePackageManagerTask)GradleUtil.addTask((Project)project, (String)(YARN_CHECK_FORMAT_TASK_NAME + suffix), ExecutePackageManagerTask.class);
        executePackageManagerTask.args(new Object[]{_CHECK_FORMAT_SCRIPT_NAME});
        executePackageManagerTask.setDescription("Runs the Yarn \"checkFormat\" script.");
        executePackageManagerTask.setWorkingDir((Object)workingDir);
        return executePackageManagerTask;
    }

    private Task _addTaskYarnCheckFormat(Project project) {
        Task task = project.task(YARN_CHECK_FORMAT_TASK_NAME);
        task.setDescription("Runs the Yarn \"checkFormat\" script.");
        task.setGroup("formatting");
        task.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                Logger logger = project.getLogger();
                if (logger.isLifecycleEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Running the Yarn \"");
                    sb.append(LiferayYarnPlugin._CHECK_FORMAT_SCRIPT_NAME);
                    sb.append("\" script");
                    logger.lifecycle(sb.toString());
                }
            }
        });
        FileTree yarnLockFiles = this._getYarnLockFiles(project);
        yarnLockFiles.forEach(yarnLockFile -> {
            File packageJsonFile = new File(yarnLockFile.getParentFile(), "package.json");
            if (this._hasPackageJsonScript(_CHECK_FORMAT_SCRIPT_NAME, packageJsonFile)) {
                task.finalizedBy(new Object[]{this._addTaskYarnCheckFormat((File)yarnLockFile, project)});
            }
        });
        return task;
    }

    private ExecutePackageManagerTask _addTaskYarnFormat(File yarnLockFile, Project project) {
        File workingDir = yarnLockFile.getParentFile();
        String suffix = StringUtil.camelCase(workingDir.getName(), true);
        ExecutePackageManagerTask executePackageManagerTask = (ExecutePackageManagerTask)GradleUtil.addTask((Project)project, (String)(YARN_FORMAT_TASK_NAME + suffix), ExecutePackageManagerTask.class);
        executePackageManagerTask.args(new Object[]{_FORMAT_SCRIPT_NAME});
        executePackageManagerTask.setDescription("Runs the Yarn \"format\" script.");
        executePackageManagerTask.setWorkingDir((Object)workingDir);
        return executePackageManagerTask;
    }

    private Task _addTaskYarnFormat(Project project) {
        Task task = project.task(YARN_FORMAT_TASK_NAME);
        task.setDescription("Runs the Yarn \"format\" script.");
        task.setGroup("formatting");
        task.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                Logger logger = project.getLogger();
                if (logger.isLifecycleEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Running the Yarn \"");
                    sb.append(LiferayYarnPlugin._FORMAT_SCRIPT_NAME);
                    sb.append("\" script");
                    logger.lifecycle(sb.toString());
                }
            }
        });
        FileTree yarnLockFiles = this._getYarnLockFiles(project);
        yarnLockFiles.forEach(yarnLockFile -> {
            File packageJsonFile = new File(yarnLockFile.getParentFile(), "package.json");
            if (this._hasPackageJsonScript(_FORMAT_SCRIPT_NAME, packageJsonFile)) {
                task.finalizedBy(new Object[]{this._addTaskYarnFormat((File)yarnLockFile, project)});
            }
        });
        return task;
    }

    private Task _addTaskYarnInstall(Project project) {
        Task task = project.task(YARN_INSTALL_TASK_NAME);
        task.setDescription("Installs the Node.js packages.");
        task.setGroup("build");
        task.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                Logger logger = project.getLogger();
                if (logger.isLifecycleEnabled()) {
                    logger.lifecycle("Installing the Node.js packages");
                }
            }
        });
        FileTree yarnLockFiles = this._getYarnLockFiles(project);
        yarnLockFiles.forEach(yarnLockFile -> task.finalizedBy(new Object[]{this._addTaskYarnInstall(task, (File)yarnLockFile, true)}));
        return task;
    }

    private YarnInstallTask _addTaskYarnInstall(Task task, File yarnLockFile, boolean frozenLockFile) {
        File workingDir = yarnLockFile.getParentFile();
        String suffix = StringUtil.camelCase(workingDir.getName(), true);
        YarnInstallTask yarnInstallTask = (YarnInstallTask)GradleUtil.addTask((Project)task.getProject(), (String)(task.getName() + suffix), YarnInstallTask.class);
        yarnInstallTask.setDescription("Installs the Node.js packages.");
        yarnInstallTask.setFrozenLockFile((Object)frozenLockFile);
        yarnInstallTask.setWorkingDir((Object)workingDir);
        return yarnInstallTask;
    }

    private Task _addTaskYarnLock(Project project) {
        Task task = project.task(YARN_LOCK_TASK_NAME);
        task.setDescription("Installs the Node.js packages and updates the yarn.lock file");
        task.setGroup("build");
        task.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                Logger logger = project.getLogger();
                if (logger.isLifecycleEnabled()) {
                    logger.lifecycle("Updating the yarn.lock file");
                }
            }
        });
        FileTree yarnLockFiles = this._getYarnLockFiles(project);
        yarnLockFiles.forEach(yarnLockFile -> task.finalizedBy(new Object[]{this._addTaskYarnInstall(task, (File)yarnLockFile, false)}));
        return task;
    }

    private FileTree _getYarnLockFiles(Project project) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", project.getProjectDir());
        args.put("excludes", _excludes);
        args.put("includes", _includes);
        return project.fileTree(args);
    }

    private boolean _hasPackageJsonScript(String scriptName, File packageJsonFile) {
        if (!packageJsonFile.exists()) {
            return false;
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map packageJsonMap = (Map)jsonSlurper.parse(packageJsonFile);
        Map scriptsJsonMap = (Map)packageJsonMap.get("scripts");
        if (scriptsJsonMap == null) {
            return false;
        }
        for (String curScriptName : scriptsJsonMap.keySet()) {
            if (!curScriptName.equals(scriptName)) continue;
            return true;
        }
        return false;
    }
}

