/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.NodeDefaultsPlugin;
import com.liferay.gradle.plugins.SourceFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.extensions.AppServer;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.internal.LangBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.tasks.DirectDeployTask;
import com.liferay.gradle.plugins.tasks.DockerDeployTask;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.net.URL;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskContainer;

public class LiferayBasePlugin
implements Plugin<Project> {
    public static final String DEPLOY_TASK_NAME = "deploy";
    public static final String DOCKER_DEPLOY_TASK_NAME = "dockerDeploy";
    public static final String PORTAL_CONFIGURATION_NAME = "portal";

    public void apply(Project project) {
        LiferayExtension liferayExtension = this._addLiferayExtension(project);
        GradleUtil.applyPlugin((Project)project, NodeDefaultsPlugin.class);
        LangBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        SourceFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
        this._addConfigurationPortal(project, liferayExtension);
        Copy copy = this._addTaskDeploy(project, liferayExtension);
        String dockerContainerId = GradleUtil.getTaskPrefixedProperty((Task)copy, (String)"docker.container.id");
        String dockerFilesDir = GradleUtil.getTaskPrefixedProperty((Task)copy, (String)"docker.files.dir");
        if (dockerContainerId != null) {
            DockerDeployTask dockerDeployTask = this._addTaskDockerDeploy(project, copy, liferayExtension, dockerContainerId);
            this._configureTaskDeploy(copy, dockerDeployTask);
        } else if (dockerFilesDir != null) {
            this._configureTaskDeploy(copy, liferayExtension, dockerFilesDir);
        }
        this._configureConfigurations(project, liferayExtension);
        this._configureTasksDirectDeploy(project, liferayExtension);
    }

    private Configuration _addConfigurationPortal(final Project project, final LiferayExtension liferayExtension) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)PORTAL_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                LiferayBasePlugin.this._addDependenciesPortal(project, liferayExtension);
            }
        });
        configuration.setDescription("Configures the classpath from the local Liferay bundle.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesPortal(Project project, LiferayExtension liferayExtension) {
        File appServerClassesPortalDir = new File(liferayExtension.getAppServerPortalDir(), "WEB-INF/classes");
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (File)appServerClassesPortalDir);
        File appServerLibPortalDir = new File(liferayExtension.getAppServerPortalDir(), "WEB-INF/lib");
        FileTree appServerLibPortalDirJarFiles = FileUtil.getJarsFileTree(project, appServerLibPortalDir, new String[0]);
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (FileCollection)appServerLibPortalDirJarFiles);
        FileTree appServerLibGlobalDirJarFiles = FileUtil.getJarsFileTree(project, liferayExtension.getAppServerLibGlobalDir(), "mail.jar");
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (FileCollection)appServerLibGlobalDirJarFiles);
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (String)"com.liferay", (String)"net.sf.jargs", (String)"1.0");
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (String)"com.thoughtworks.qdox", (String)"qdox", (String)"1.12.1");
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (String)"javax.activation", (String)"activation", (String)"1.1");
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (String)"javax.servlet", (String)"javax.servlet-api", (String)"3.0.1");
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (String)"javax.servlet.jsp", (String)"javax.servlet.jsp-api", (String)"2.3.1");
        AppServer appServer = liferayExtension.getAppServer();
        appServer.addAdditionalDependencies(PORTAL_CONFIGURATION_NAME);
    }

    private LiferayExtension _addLiferayExtension(Project project) {
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.addExtension((ExtensionAware)project, (String)"liferay", LiferayExtension.class);
        String name = this._getConfigLiferayScriptName(PortalTools.getPortalVersion(project));
        ClassLoader classLoader = LiferayBasePlugin.class.getClassLoader();
        URL url = classLoader.getResource(name);
        if (url == null) {
            name = this._getConfigLiferayScriptName(null);
        }
        GradleUtil.applyScript((Project)project, (String)name, (Object)project);
        return liferayExtension;
    }

    private Copy _addTaskDeploy(Project project, final LiferayExtension liferayExtension) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)DEPLOY_TASK_NAME, Copy.class);
        copy.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Logger logger = task.getLogger();
                if (logger.isLifecycleEnabled()) {
                    Copy copy = (Copy)task;
                    logger.lifecycle("Files of {} deployed to {}", new Object[]{copy.getProject(), copy.getDestinationDir()});
                }
            }
        });
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getDeployDir();
            }
        });
        copy.setDescription("Assembles the project and deploys it to Liferay.");
        copy.setGroup("build");
        return copy;
    }

    private DockerDeployTask _addTaskDockerDeploy(Project project, final Copy copy, final LiferayExtension liferayExtension, String dockerContainerId) {
        final DockerDeployTask dockerDeployTask = (DockerDeployTask)GradleUtil.addTask((Project)project, (String)DOCKER_DEPLOY_TASK_NAME, DockerDeployTask.class);
        dockerDeployTask.dependsOn(new Object[]{copy});
        dockerDeployTask.setContainerId(dockerContainerId);
        dockerDeployTask.setDeployDir(new Callable<String>(){

            @Override
            public String call() throws Exception {
                StringBuilder sb = new StringBuilder();
                sb.append(dockerDeployTask.getLiferayHome());
                sb.append('/');
                String relativePath = FileUtil.relativize((File)liferayExtension.getDeployDir(), (File)liferayExtension.getLiferayHome());
                sb.append(relativePath);
                String deployDir = sb.toString();
                return deployDir.replace('\\', '/');
            }
        });
        dockerDeployTask.setDescription("Deploys the project to the Docker container.");
        dockerDeployTask.setGroup("build");
        dockerDeployTask.setSourceFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                FileCollection fileCollection = copy.getSource();
                return fileCollection.getSingleFile();
            }
        });
        dockerDeployTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Logger logger = task.getLogger();
                if (logger.isLifecycleEnabled()) {
                    DockerDeployTask dockerDeployTask = (DockerDeployTask)task;
                    logger.lifecycle("Files of {} deployed to {}", new Object[]{dockerDeployTask.getProject(), dockerDeployTask.getDeployDir()});
                }
            }
        });
        return dockerDeployTask;
    }

    private void _configureConfigurations(Project project, final LiferayExtension liferayExtension) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Action<Configuration> action = new Action<Configuration>(){

            public void execute(Configuration configuration) {
                ResolutionStrategy resolutionStrategy = configuration.getResolutionStrategy();
                resolutionStrategy.eachDependency((Action)new Action<DependencyResolveDetails>(){

                    public void execute(DependencyResolveDetails dependencyResolveDetails) {
                        ModuleVersionSelector moduleVersionSelector = dependencyResolveDetails.getRequested();
                        String version = moduleVersionSelector.getVersion();
                        if (!version.equals("default")) {
                            return;
                        }
                        version = liferayExtension.getDefaultVersion(moduleVersionSelector);
                        dependencyResolveDetails.useVersion(version);
                    }
                });
            }
        };
        configurationContainer.all((Action)action);
    }

    private void _configureTaskDeploy(Copy copy, DockerDeployTask dockerDeployTask) {
        copy.finalizedBy(new Object[]{dockerDeployTask});
        copy.setEnabled(false);
    }

    private void _configureTaskDeploy(Copy copy, final LiferayExtension liferayExtension, final String dockerFilesDir) {
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                String relativePath = FileUtil.relativize((File)liferayExtension.getDeployDir(), (File)liferayExtension.getLiferayHome());
                return new File(dockerFilesDir, relativePath);
            }
        });
    }

    private void _configureTaskDirectDeploy(DirectDeployTask directDeployTask, final LiferayExtension liferayExtension) {
        directDeployTask.setAppServerDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getAppServerDir();
            }
        });
        directDeployTask.setAppServerLibGlobalDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getAppServerLibGlobalDir();
            }
        });
        directDeployTask.setAppServerPortalDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getAppServerPortalDir();
            }
        });
        directDeployTask.setAppServerType(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return liferayExtension.getAppServerType();
            }
        });
    }

    private void _configureTasksDirectDeploy(Project project, final LiferayExtension liferayExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(DirectDeployTask.class, (Action)new Action<DirectDeployTask>(){

            public void execute(DirectDeployTask directDeployTask) {
                LiferayBasePlugin.this._configureTaskDirectDeploy(directDeployTask, liferayExtension);
            }
        });
    }

    private String _getConfigLiferayScriptName(String portalVersion) {
        StringBuilder sb = new StringBuilder();
        sb.append("com/liferay/gradle/plugins/dependencies/config-liferay");
        if (Validator.isNotNull((String)portalVersion)) {
            sb.append('-');
            sb.append(portalVersion);
        }
        sb.append(".gradle");
        return sb.toString();
    }
}

