/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import groovy.lang.Closure;
import groovy.util.Node;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.XmlProvider;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;

public class EclipseDefaultsPlugin
extends BaseDefaultsPlugin<EclipsePlugin> {
    public static final Plugin<Project> INSTANCE = new EclipseDefaultsPlugin();
    private static final String _CLEAN_ECLIPSE_TASK_NAME = "cleanEclipse";
    private static final String _ECLIPSE_TASK_NAME = "eclipse";
    private static final String[] _FILTERED_DIR_NAMES = new String[]{".git", ".gradle", "build", "node_modules", "tmp"};

    @Override
    protected void configureDefaults(Project project, EclipsePlugin eclipsePlugin) {
        this._configureEclipseClasspathFile(project);
        this._configureEclipseProject(project);
        this._configureTaskEclipse(project);
    }

    @Override
    protected Class<EclipsePlugin> getPluginClass() {
        return EclipsePlugin.class;
    }

    private EclipseDefaultsPlugin() {
    }

    private void _configureEclipseClasspathFile(Project project) {
        EclipseModel eclipseModel = (EclipseModel)GradleUtil.getExtension((ExtensionAware)project, EclipseModel.class);
        EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
        XmlFileContentMerger fileContentMerger = eclipseClasspath.getFile();
        Closure<Void> closure = new Closure<Void>((Object)project){

            public void doCall(Classpath classpath) {
                List classpathEntries = classpath.getEntries();
                Iterator iterator = classpathEntries.iterator();
                while (iterator.hasNext()) {
                    ClasspathEntry classpathEntry = (ClasspathEntry)iterator.next();
                    if (!(classpathEntry instanceof AbstractClasspathEntry)) continue;
                    AbstractClasspathEntry abstractClasspathEntry = (AbstractClasspathEntry)classpathEntry;
                    String kind = abstractClasspathEntry.getKind();
                    String path = abstractClasspathEntry.getPath();
                    if (!kind.equals("lib") || !path.endsWith(".pom")) continue;
                    iterator.remove();
                }
            }
        };
        fileContentMerger.whenMerged((Closure)closure);
    }

    private void _configureEclipseProject(Project project) {
        EclipseModel eclipseModel = (EclipseModel)GradleUtil.getExtension((ExtensionAware)project, EclipseModel.class);
        EclipseProject eclipseProject = eclipseModel.getProject();
        eclipseProject.setName(project.getName());
        List natures = eclipseProject.getNatures();
        natures.add("com.liferay.ide.core.liferayNature");
        Action<XmlProvider> action = new Action<XmlProvider>(){

            public void execute(XmlProvider xmlProvider) {
                Node projectDescriptionNode = xmlProvider.asNode();
                Node filteredResourcesNode = projectDescriptionNode.appendNode((Object)"filteredResources");
                Node filterNode = filteredResourcesNode.appendNode((Object)"filter");
                filterNode.appendNode((Object)"id", (Object)System.currentTimeMillis());
                filterNode.appendNode((Object)"name");
                filterNode.appendNode((Object)"type", (Object)"26");
                Node matcherNode = filterNode.appendNode((Object)"matcher");
                matcherNode.appendNode((Object)"id", (Object)"org.eclipse.ui.ide.orFilterMatcher");
                Node argumentsNode = matcherNode.appendNode((Object)"arguments");
                for (String filteredDirName : _FILTERED_DIR_NAMES) {
                    Node curMatcherNode = argumentsNode.appendNode((Object)"matcher");
                    curMatcherNode.appendNode((Object)"arguments", (Object)("1.0-name-matches-false-false-" + filteredDirName));
                    curMatcherNode.appendNode((Object)"id", (Object)"org.eclipse.ui.ide.multiFilter");
                }
            }
        };
        XmlFileContentMerger xmlFileContentMerger = eclipseProject.getFile();
        xmlFileContentMerger.withXml((Action)action);
    }

    private void _configureTaskEclipse(Project project) {
        Task task = GradleUtil.getTask((Project)project, (String)_ECLIPSE_TASK_NAME);
        task.dependsOn(new Object[]{_CLEAN_ECLIPSE_TASK_NAME});
    }
}

