/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.BasePortalToolDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.source.formatter.FormatSourceTask;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;

public class SourceFormatterDefaultsPlugin
extends BasePortalToolDefaultsPlugin<SourceFormatterPlugin> {
    public static final Plugin<Project> INSTANCE = new SourceFormatterDefaultsPlugin();
    private static final String _PORTAL_TOOL_NAME = "com.liferay.source.formatter";

    @Override
    protected void configureDefaults(final Project project, SourceFormatterPlugin sourceFormatterPlugin) {
        super.configureDefaults(project, sourceFormatterPlugin);
        this._configureTasksFormatSource(project);
        GradleUtil.withPlugin(project, NodePlugin.class, new Action<NodePlugin>(){

            public void execute(NodePlugin nodePlugin) {
                SourceFormatterDefaultsPlugin.this._configureTaskForNodePlugin(project, "checkSourceFormatting", "npmRunCheckFormat");
                SourceFormatterDefaultsPlugin.this._configureTaskForNodePlugin(project, "formatSource", "npmRunFormat");
            }
        });
    }

    @Override
    protected Class<SourceFormatterPlugin> getPluginClass() {
        return SourceFormatterPlugin.class;
    }

    @Override
    protected String getPortalToolConfigurationName() {
        return "sourceFormatter";
    }

    @Override
    protected String getPortalToolName() {
        return _PORTAL_TOOL_NAME;
    }

    private void _configureTaskForNodePlugin(Project project, String taskName, String nodeTaskName) {
        TaskContainer taskContainer = project.getTasks();
        Task nodeTask = (Task)taskContainer.findByName(nodeTaskName);
        if (nodeTask != null) {
            Task task = GradleUtil.getTask((Project)project, (String)taskName);
            task.dependsOn(new Object[]{nodeTask});
        }
    }

    private void _configureTasksFormatSource(FormatSourceTask formatSourceTask) {
        String showStatusUpdates;
        String showDocumentation;
        String showDebugInformation;
        String processorThreadCount;
        String maxLineLength;
        String includeSubrepositories;
        Project project = formatSourceTask.getProject();
        String gitWorkingBranchName = GradleUtil.getProperty((ExtensionAware)project, (String)"git.working.branch.name", (String)null);
        if (Validator.isNotNull((String)gitWorkingBranchName)) {
            formatSourceTask.setGitWorkingBranchName(gitWorkingBranchName);
        }
        if (Validator.isNotNull((String)(includeSubrepositories = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.include.subrepositories", (String)null)))) {
            formatSourceTask.setIncludeSubrepositories(Boolean.parseBoolean(includeSubrepositories));
        }
        if (Validator.isNotNull((String)(maxLineLength = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.max.line.length", (String)null)))) {
            formatSourceTask.setMaxLineLength(Integer.parseInt(maxLineLength));
        }
        if (Validator.isNotNull((String)(processorThreadCount = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.processor.thread.count", (String)null)))) {
            formatSourceTask.setProcessorThreadCount(Integer.parseInt(processorThreadCount));
        }
        if (Validator.isNotNull((String)(showDebugInformation = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.show.debug.information", (String)null)))) {
            formatSourceTask.setShowDebugInformation(Boolean.parseBoolean(showDebugInformation));
        }
        if (Validator.isNotNull((String)(showDocumentation = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.show.documentation", (String)null)))) {
            formatSourceTask.setShowDocumentation(Boolean.parseBoolean(showDocumentation));
        }
        if (Validator.isNotNull((String)(showStatusUpdates = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.show.status.updates", (String)null)))) {
            formatSourceTask.setShowStatusUpdates(Boolean.parseBoolean(showStatusUpdates));
        }
    }

    private void _configureTasksFormatSource(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(FormatSourceTask.class, (Action)new Action<FormatSourceTask>(){

            public void execute(FormatSourceTask formatSourceTask) {
                SourceFormatterDefaultsPlugin.this._configureTasksFormatSource(formatSourceTask);
            }
        });
    }
}

