/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import com.liferay.gradle.plugins.internal.util.GradleUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dm.gradle.plugins.bundle.BundleExtension;
import org.dm.gradle.plugins.bundle.JarBuilder;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Factory;

public class ExecuteBndTask
extends DefaultTask {
    private Object _baseDir;
    private FileCollection _classpath;
    private boolean _failOnError = true;
    private Object _outputFile;
    private final Map<String, Object> _properties = new LinkedHashMap<String, Object>();
    private FileCollection _resourceDirs;
    private FileCollection _sourceDirs;
    private boolean _writeManifest;

    public ExecuteBndTask() {
        Project project = this.getProject();
        this._baseDir = project.getProjectDir();
    }

    @TaskAction
    public void executeBnd() {
        File outputFile;
        long clockStart;
        Logger logger;
        block18: {
            logger = this.getLogger();
            Properties properties = this.getProperties();
            clockStart = System.currentTimeMillis();
            BundleExtension bundleExtension = (BundleExtension)GradleUtil.getExtension((ExtensionAware)this.getProject(), BundleExtension.class);
            Factory jarBuilderFactory = bundleExtension.getJarBuilderFactory();
            JarBuilder jarBuilder = (JarBuilder)jarBuilderFactory.create();
            jarBuilder.withBase((Object)this.getBaseDir());
            jarBuilder.withClasspath((Object)ExecuteBndTask._toArray(this.getClasspath()));
            jarBuilder.withFailOnError((Object)this.isFailOnError());
            jarBuilder.withName(properties.getProperty("Bundle-SymbolicName"));
            jarBuilder.withProperties((Object)properties);
            jarBuilder.withResources((Object)ExecuteBndTask._toArray(this.getResourceDirs()));
            jarBuilder.withSourcepath((Object)this.getSourceDirs());
            jarBuilder.withVersion(properties.getProperty("Bundle-Version"));
            if (logger.isInfoEnabled()) {
                jarBuilder.withTrace((Object)true);
            } else {
                jarBuilder.withTrace((Object)true);
            }
            outputFile = this.getOutputFile();
            if (this.isWriteManifest()) {
                File outputDir = outputFile.getParentFile();
                outputDir.mkdirs();
                try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                    jarBuilder.writeManifestTo((OutputStream)outputStream);
                    break block18;
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException((Throwable)ioe);
                }
            }
            jarBuilder.writeJarTo(outputFile);
        }
        if (logger.isLifecycleEnabled()) {
            long clockStop = System.currentTimeMillis();
            logger.lifecycle("Building the {} file took {} seconds.", new Object[]{outputFile.getName(), (clockStart - clockStop) / 1000L});
        }
    }

    @Input
    public File getBaseDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._baseDir);
    }

    @InputFiles
    public FileCollection getClasspath() {
        return this._classpath;
    }

    @OutputFile
    public File getOutputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputFile);
    }

    @Input
    public Properties getProperties() {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> entry : this._properties.entrySet()) {
            properties.setProperty(entry.getKey(), GradleUtil.toString((Object)entry.getValue()));
        }
        return properties;
    }

    @InputFiles
    public FileCollection getResourceDirs() {
        return this._resourceDirs;
    }

    @InputFiles
    public FileCollection getSourceDirs() {
        return this._sourceDirs;
    }

    public boolean isFailOnError() {
        return this._failOnError;
    }

    @Input
    public boolean isWriteManifest() {
        return this._writeManifest;
    }

    public ExecuteBndTask properties(Map<String, ?> properties) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            this.property(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ExecuteBndTask property(String key, Object value) {
        this._properties.put(key, value);
        return this;
    }

    public void setBaseDir(Object baseDir) {
        this._baseDir = baseDir;
    }

    public void setClasspath(FileCollection classpath) {
        this._classpath = classpath;
    }

    public void setFailOnError(boolean failOnError) {
        this._failOnError = failOnError;
    }

    public void setOutputFile(Object outputFile) {
        this._outputFile = outputFile;
    }

    public void setProperties(Map<String, ?> properties) {
        this._properties.clear();
        this.properties(properties);
    }

    public void setResourceDirs(FileCollection resourceDirs) {
        this._resourceDirs = resourceDirs;
    }

    public void setSourceDirs(FileCollection sourceDirs) {
        this._sourceDirs = sourceDirs;
    }

    public void setWriteManifest(boolean writeManifest) {
        this._writeManifest = writeManifest;
    }

    private static File[] _toArray(FileCollection fileCollection) {
        Set files = fileCollection.getFiles();
        return files.toArray(new File[0]);
    }
}

