/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BasePortalToolDefaultsPlugin;
import com.liferay.gradle.plugins.css.builder.BuildCSSTask;
import com.liferay.gradle.plugins.css.builder.CSSBuilderPlugin;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;

public class CSSBuilderDefaultsPlugin
extends BasePortalToolDefaultsPlugin<CSSBuilderPlugin> {
    public static final Plugin<Project> INSTANCE = new CSSBuilderDefaultsPlugin();
    private static final String _FRONTEND_COMMON_CSS_NAME = "com.liferay.frontend.css.common";
    private static final String _PORTAL_TOOL_NAME = "com.liferay.css.builder";

    @Override
    protected void configureDefaults(Project project, CSSBuilderPlugin cssBuilderPlugin) {
        super.configureDefaults(project, cssBuilderPlugin);
        this.addPortalToolDependencies(project, "portalCommonCSS", _FRONTEND_COMMON_CSS_NAME);
        this._configureTasksBuildCSS(project);
    }

    @Override
    protected Class<CSSBuilderPlugin> getPluginClass() {
        return CSSBuilderPlugin.class;
    }

    @Override
    protected String getPortalToolConfigurationName() {
        return "cssBuilder";
    }

    @Override
    protected String getPortalToolName() {
        return _PORTAL_TOOL_NAME;
    }

    private CSSBuilderDefaultsPlugin() {
    }

    private void _configureTaskBuildCSS(BuildCSSTask buildCSSTask) {
        String precision;
        String generateSourceMap;
        Project project = buildCSSTask.getProject();
        File docrootDir = project.file((Object)"docroot");
        if (docrootDir.exists()) {
            buildCSSTask.setBaseDir((Object)docrootDir);
        }
        if (Validator.isNotNull((String)(generateSourceMap = GradleUtil.getProperty((ExtensionAware)project, (String)"sass.generate.source.map", (String)null)))) {
            buildCSSTask.setGenerateSourceMap(Boolean.parseBoolean(generateSourceMap));
        }
        if (Validator.isNotNull((String)(precision = GradleUtil.getProperty((ExtensionAware)project, (String)"sass.precision", (String)null)))) {
            buildCSSTask.setPrecision((Object)precision);
        }
        String sassCompilerClassName = GradleUtil.getProperty((ExtensionAware)project, (String)"sass.compiler.class.name", (String)null);
        buildCSSTask.setSassCompilerClassName((Object)sassCompilerClassName);
    }

    private void _configureTasksBuildCSS(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildCSSTask.class, (Action)new Action<BuildCSSTask>(){

            public void execute(BuildCSSTask buildCSSTask) {
                CSSBuilderDefaultsPlugin.this._configureTaskBuildCSS(buildCSSTask);
            }
        });
    }
}

