/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BasePortalToolDefaultsPlugin;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.alloy.taglib.AlloyTaglibPlugin;
import com.liferay.gradle.plugins.alloy.taglib.BuildTaglibsTask;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskContainer;

public class AlloyTaglibDefaultsPlugin
extends BasePortalToolDefaultsPlugin<AlloyTaglibPlugin> {
    private static final String _PORTAL_TOOL_CONFIGURATION_NAME = "alloyTaglib";
    private static final String _PORTAL_TOOL_NAME = "com.liferay.alloy.taglib";

    protected Configuration addPortalToolConfiguration(final Project project) {
        final Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)this.getPortalToolConfigurationName());
        configuration.setDescription("Configures the Alloy Taglib tool for this project.");
        configuration.setVisible(false);
        GradleUtil.withPlugin(project, LiferayBasePlugin.class, new Action<LiferayBasePlugin>(){

            public void execute(LiferayBasePlugin liferayBasePlugin) {
                Configuration portalConfiguration = GradleUtil.getConfiguration((Project)project, (String)"portal");
                configuration.extendsFrom(new Configuration[]{portalConfiguration});
            }
        });
        Configuration runtimeConfiguration = GradleUtil.getConfiguration((Project)project, (String)"runtime");
        configuration.extendsFrom(new Configuration[]{runtimeConfiguration});
        return configuration;
    }

    @Override
    protected void addPortalToolDependencies(Project project) {
        this.addPortalToolConfiguration(project);
        super.addPortalToolDependencies(project);
        GradleUtil.addDependency((Project)project, (String)this.getPortalToolConfigurationName(), (String)"org.freemarker", (String)"freemarker", (String)"2.3.23");
    }

    @Override
    protected void configureDefaults(Project project, AlloyTaglibPlugin alloyTaglibPlugin) {
        super.configureDefaults(project, alloyTaglibPlugin);
        this.configureTasksBuildTaglibs(project);
    }

    protected void configureTaskBuildTaglibs(BuildTaglibsTask buildTaglibsTask) {
        Configuration configuration = GradleUtil.getConfiguration((Project)buildTaglibsTask.getProject(), (String)this.getPortalToolConfigurationName());
        buildTaglibsTask.setClasspath((FileCollection)configuration);
    }

    protected void configureTasksBuildTaglibs(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildTaglibsTask.class, (Action)new Action<BuildTaglibsTask>(){

            public void execute(BuildTaglibsTask buildTaglibsTask) {
                AlloyTaglibDefaultsPlugin.this.configureTaskBuildTaglibs(buildTaglibsTask);
            }
        });
    }

    @Override
    protected Class<AlloyTaglibPlugin> getPluginClass() {
        return AlloyTaglibPlugin.class;
    }

    @Override
    protected String getPortalToolConfigurationName() {
        return _PORTAL_TOOL_CONFIGURATION_NAME;
    }

    @Override
    protected String getPortalToolName() {
        return _PORTAL_TOOL_NAME;
    }
}

