/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.extensions;

import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.util.OSDetector;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.util.GUtil;

public class AppServer {
    protected final Project project;
    private Object _binDir;
    private Object _checkPath = "/web/guest";
    private Object _deployDir;
    private Object _dir;
    private Object _libGlobalDir;
    private final String _name;
    private Object _portalDir;
    private Object _portNumber = 8080;
    private Object _startExecutable;
    private final List<Object> _startExecutableArgs = new ArrayList<Object>();
    private Object _stopExecutable;
    private final List<Object> _stopExecutableArgs = new ArrayList<Object>();
    private Object _version;
    private Object _zipUrl;

    public AppServer(String name, Project project) {
        this._name = name;
        this.project = project;
    }

    public void addAdditionalDependencies(String configurationName) {
    }

    public File getBinDir() {
        return GradleUtil.toFile((Project)this.project, (Object)this._binDir);
    }

    public String getCheckPath() {
        return GradleUtil.toString((Object)this._checkPath);
    }

    public File getDeployDir() {
        return GradleUtil.toFile((Project)this.project, (Object)this._deployDir);
    }

    public File getDir() {
        return GradleUtil.toFile((Project)this.project, (Object)this._dir);
    }

    public File getLibGlobalDir() {
        return GradleUtil.toFile((Project)this.project, (Object)this._libGlobalDir);
    }

    public String getName() {
        return this._name;
    }

    public File getPortalDir() {
        return GradleUtil.toFile((Project)this.project, (Object)this._portalDir);
    }

    public int getPortNumber() {
        return GradleUtil.toInteger((Object)this._portNumber);
    }

    public String getStartExecutable() {
        return GradleUtil.toString((Object)this._startExecutable);
    }

    public List<String> getStartExecutableArgs() {
        return GradleUtil.toStringList(this._startExecutableArgs);
    }

    public String getStopExecutable() {
        return GradleUtil.toString((Object)this._stopExecutable);
    }

    public List<String> getStopExecutableArgs() {
        return GradleUtil.toStringList(this._stopExecutableArgs);
    }

    public String getVersion() {
        return GradleUtil.toString((Object)this._version);
    }

    public String getZipUrl() {
        return GradleUtil.toString((Object)this._zipUrl);
    }

    public boolean isReachable() {
        try {
            URL url = new URL("http", "localhost", this.getPortNumber(), this.getCheckPath());
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("GET");
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode > 0 && responseCode < 400) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void setBinDir(Object binDir) {
        this._binDir = binDir;
    }

    public void setCheckPath(Object checkPath) {
        this._checkPath = checkPath;
    }

    public void setDeployDir(Object deployDir) {
        this._deployDir = deployDir;
    }

    public void setDir(Object dir) {
        this._dir = dir;
    }

    public void setLibGlobalDir(Object libGlobalDir) {
        this._libGlobalDir = libGlobalDir;
    }

    public void setPortalDir(Object portalDir) {
        this._portalDir = portalDir;
    }

    public void setPortNumber(Object portNumber) {
        this._portNumber = portNumber;
    }

    public void setStartExecutable(Object startExecutable) {
        this._startExecutable = startExecutable;
    }

    public void setStartExecutableArgs(Iterable<?> startExecutableArgs) {
        this._startExecutableArgs.clear();
        GUtil.addToCollection(this._startExecutableArgs, (Iterable[])new Iterable[]{startExecutableArgs});
    }

    public void setStopExecutable(Object stopExecutable) {
        this._stopExecutable = stopExecutable;
    }

    public void setStopExecutableArgs(Iterable<?> stopExecutableArgs) {
        this._stopExecutableArgs.clear();
        GUtil.addToCollection(this._stopExecutableArgs, (Iterable[])new Iterable[]{stopExecutableArgs});
    }

    public void setVersion(Object version) {
        this._version = version;
    }

    public void setZipUrl(Object zipUrl) {
        this._zipUrl = zipUrl;
    }

    protected String getFileSuffixBat() {
        if (OSDetector.isWindows()) {
            return ".bat";
        }
        return ".sh";
    }
}

