/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import aQute.bnd.gradle.BeanProperties;
import aQute.bnd.gradle.BndUtils;
import aQute.bnd.gradle.BundleTaskExtension;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Processor;
import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import com.liferay.gradle.plugins.CSSBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.EclipseDefaultsPlugin;
import com.liferay.gradle.plugins.IdeaDefaultsPlugin;
import com.liferay.gradle.plugins.JspCDefaultsPlugin;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.WatchOSGiPlugin;
import com.liferay.gradle.plugins.css.builder.CSSBuilderPlugin;
import com.liferay.gradle.plugins.extensions.BundleExtension;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.LiferayOSGiExtension;
import com.liferay.gradle.plugins.internal.DBSupportDefaultsPlugin;
import com.liferay.gradle.plugins.internal.JavadocFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.internal.RESTBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.ServiceBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.TLDFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.internal.TestIntegrationDefaultsPlugin;
import com.liferay.gradle.plugins.internal.UpgradeTableBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.WSDDBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.internal.util.IncludeResourceCompileIncludeInstruction;
import com.liferay.gradle.plugins.internal.util.copy.RenameDependencyAction;
import com.liferay.gradle.plugins.jasper.jspc.JspCPlugin;
import com.liferay.gradle.plugins.javadoc.formatter.JavadocFormatterPlugin;
import com.liferay.gradle.plugins.lang.builder.LangBuilderPlugin;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.task.DownloadNodeModuleTask;
import com.liferay.gradle.plugins.node.task.NpmInstallTask;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.plugins.task.DirectDeployTask;
import com.liferay.gradle.plugins.test.integration.TestIntegrationPlugin;
import com.liferay.gradle.plugins.tld.formatter.TLDFormatterPlugin;
import com.liferay.gradle.plugins.tlddoc.builder.TLDDocBuilderPlugin;
import com.liferay.gradle.plugins.util.BndUtil;
import com.liferay.gradle.plugins.wsdd.builder.BuildWSDDTask;
import com.liferay.gradle.plugins.wsdl.builder.WSDLBuilderPlugin;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;

public class LiferayOSGiPlugin
implements Plugin<Project> {
    public static final String AUTO_CLEAN_PROPERTY_NAME = "autoClean";
    public static final String AUTO_UPDATE_XML_TASK_NAME = "autoUpdateXml";
    public static final String CLEAN_DEPLOYED_PROPERTY_NAME = "cleanDeployed";
    public static final String COMPILE_INCLUDE_CONFIGURATION_NAME = "compileInclude";
    public static final String DEPLOY_DEPENDENCIES_TASK_NAME = "deployDependencies";
    public static final String PLUGIN_NAME = "liferayOSGi";
    public static final String ZIP_ZIPPABLE_RESOURCES_TASK_NAME = "zipZippableResources";
    private static final String _CACHE_PLUGIN_ID = "com.liferay.cache";
    private static final Logger _logger = Logging.getLogger(LiferayOSGiPlugin.class);
    private static final Pattern _keyPattern = Pattern.compile("[a-z][\\p{Alnum}-_.]*");

    public void apply(final Project project) {
        File[] zippableResourcesDirs;
        this._applyPlugins(project);
        ExtensionContainer extensionContainer = project.getExtensions();
        final LiferayOSGiExtension liferayOSGiExtension = new LiferayOSGiExtension(project);
        extensionContainer.add(LiferayOSGiExtension.class, PLUGIN_NAME, (Object)liferayOSGiExtension);
        final BundleExtension bundleExtension = BndUtil.getBundleExtension(extensionContainer);
        final LiferayExtension liferayExtension = (LiferayExtension)extensionContainer.getByType(LiferayExtension.class);
        this._configureExtensionBundle(project, bundleExtension);
        this._configureExtensionLiferay(project, liferayExtension);
        final Convention convention = project.getConvention();
        BasePluginConvention basePluginConvention = (BasePluginConvention)convention.getPlugin(BasePluginConvention.class);
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)convention.getPlugin(JavaPluginConvention.class);
        SourceSetContainer javaSourceSetContainer = javaPluginConvention.getSourceSets();
        final SourceSet javaMainSourceSet = (SourceSet)javaSourceSetContainer.getByName("main");
        this._configureConventionBasePlugin(bundleExtension, basePluginConvention);
        this._configureConventionJavaPlugin(project, javaMainSourceSet);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        final Configuration compileIncludeConfiguration = (Configuration)configurationContainer.maybeCreate(COMPILE_INCLUDE_CONFIGURATION_NAME);
        Configuration compileOnlyConfiguration = configurationContainer.getByName("compileOnly");
        this._configureConfigurationCompileInclude(compileIncludeConfiguration);
        this._configureConfigurationCompileOnly(compileIncludeConfiguration, compileOnlyConfiguration);
        final TaskProvider deployDependenciesTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)DEPLOY_DEPENDENCIES_TASK_NAME, Copy.class);
        TaskProvider directDeployTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)AUTO_UPDATE_XML_TASK_NAME, DirectDeployTask.class);
        TaskProvider zipZippableResourcesTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)ZIP_ZIPPABLE_RESOURCES_TASK_NAME, Task.class);
        final TaskProvider cleanTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"clean", Delete.class);
        final TaskProvider compileTestJavaTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"compileTestJava", JavaCompile.class);
        final TaskProvider deployTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"deploy", Copy.class);
        TaskProvider jarTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"jar", Jar.class);
        TaskProvider javadocTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"javadoc", Javadoc.class);
        TaskProvider testTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"test", Test.class);
        ArrayList<TaskProvider<Zip>> zippableResourcesTaskProviders = new ArrayList<TaskProvider<Zip>>();
        for (File zippableResourcesDir : zippableResourcesDirs = FileUtil.getDirectories(project.file((Object)"src/main/zippableResources"))) {
            String taskName = GradleUtil.getTaskName((String)ZIP_ZIPPABLE_RESOURCES_TASK_NAME, (File)zippableResourcesDir);
            TaskProvider zippableResourcesTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)taskName, Zip.class);
            zippableResourcesTaskProviders.add(zippableResourcesTaskProvider);
            this._configureTaskZippableResources(project, (TaskProvider<Zip>)zippableResourcesTaskProvider, zippableResourcesDir);
        }
        this._configureTaskAutoUpdateXmlProvider(project, liferayExtension, liferayOSGiExtension, (TaskProvider<DirectDeployTask>)directDeployTaskProvider, (TaskProvider<Jar>)jarTaskProvider);
        this._configureTaskCleanProvider(project, (TaskProvider<Delete>)cleanTaskProvider);
        this._configureTaskDeployProvider((TaskProvider<Copy>)deployTaskProvider, (TaskProvider<Copy>)deployDependenciesTaskProvider);
        this._configureTaskDeployDependenciesProvider(liferayExtension, (TaskProvider<Copy>)deployDependenciesTaskProvider);
        this._configureTaskJarProvider(project, bundleExtension, (TaskProvider<Jar>)jarTaskProvider, (TaskProvider<Task>)zipZippableResourcesTaskProvider);
        this._configureTaskJavadocProvider(bundleExtension, (TaskProvider<Javadoc>)javadocTaskProvider);
        this._configureTaskTestProvider((TaskProvider<Test>)testTaskProvider);
        this._configureTaskZipZippableResources(project, zippableResourcesTaskProviders, (TaskProvider<Task>)zipZippableResourcesTaskProvider);
        this._configureTaskCleanProvider(liferayExtension, (TaskProvider<Delete>)cleanTaskProvider, (TaskProvider<Copy>)deployTaskProvider, (TaskProvider<Jar>)jarTaskProvider);
        this._configureTaskDeployProvider(project, liferayExtension, (TaskProvider<Copy>)deployTaskProvider, (TaskProvider<Jar>)jarTaskProvider, false);
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildWSDDTask.class, (Action)new Action<BuildWSDDTask>(){

            public void execute(BuildWSDDTask buildWSDDTask) {
                TaskProvider buildWSDDJarTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)(buildWSDDTask.getName() + "Jar"), Jar.class);
                LiferayOSGiPlugin.this._configureTaskBuildWSDDJarProvider(project, bundleExtension, liferayExtension, liferayOSGiExtension, javaMainSourceSet, buildWSDDTask, (TaskProvider<Jar>)buildWSDDJarTaskProvider, (TaskProvider<Delete>)cleanTaskProvider, (TaskProvider<Copy>)deployTaskProvider);
            }
        });
        taskContainer.configureEach((Action)new Action<Task>(){

            public void execute(Task task) {
                if (task instanceof JavaCompile) {
                    LiferayOSGiPlugin.this._configureTaskJavaCompile((JavaCompile)task, true);
                }
                if (task instanceof Test) {
                    LiferayOSGiPlugin.this._configureTaskTest((Test)task);
                }
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.configureEach((Action)new Action<Plugin>(){

            public void execute(Plugin plugin) {
                if (plugin instanceof ApplicationPlugin) {
                    LiferayOSGiPlugin.this._configurePluginApplication(project, bundleExtension, compileIncludeConfiguration, convention);
                }
            }
        });
        this._configureProject(project, bundleExtension);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayOSGiPlugin.this._configureExtensionBundleAfterEvaluate(bundleExtension, liferayOSGiExtension, compileIncludeConfiguration);
                LiferayOSGiPlugin.this._configureTaskCompileTestJavaProviderAfterEvaluate(project, (TaskProvider<JavaCompile>)compileTestJavaTaskProvider);
                LiferayOSGiPlugin.this._configureTaskDeployDependenciesProviderAfterEvaluate((TaskProvider<Copy>)deployDependenciesTaskProvider);
            }
        });
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, JavaLibraryPlugin.class);
        GradleUtil.applyPlugin((Project)project, CSSBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        GradleUtil.applyPlugin((Project)project, EclipsePlugin.class);
        GradleUtil.applyPlugin((Project)project, JavadocFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, JspCPlugin.class);
        GradleUtil.applyPlugin((Project)project, LangBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, TLDDocBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, TLDFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, TestIntegrationPlugin.class);
        CSSBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        DBSupportDefaultsPlugin.INSTANCE.apply((Object)project);
        EclipseDefaultsPlugin.INSTANCE.apply((Object)project);
        IdeaDefaultsPlugin.INSTANCE.apply((Object)project);
        JavadocFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
        JspCDefaultsPlugin.INSTANCE.apply((Object)project);
        RESTBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        ServiceBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        TLDFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
        TestIntegrationDefaultsPlugin.INSTANCE.apply((Object)project);
        UpgradeTableBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        WSDDBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        WatchOSGiPlugin.INSTANCE.apply((Object)project);
    }

    private void _configureConfigurationCompileInclude(Configuration compileIncludeConfiguration) {
        compileIncludeConfiguration.setDescription("Additional dependencies to include in the final JAR.");
        compileIncludeConfiguration.setVisible(false);
    }

    private void _configureConfigurationCompileOnly(Configuration compileIncludeConfiguration, Configuration compileOnlyConfiguration) {
        compileOnlyConfiguration.extendsFrom(new Configuration[]{compileIncludeConfiguration});
    }

    private void _configureConventionBasePlugin(BundleExtension bundleExtension, BasePluginConvention basePluginConvention) {
        String bundleSymbolicName = bundleExtension.getInstruction("Bundle-SymbolicName");
        if (Validator.isNull((String)bundleSymbolicName)) {
            return;
        }
        Parameters parameters = new Parameters(bundleSymbolicName);
        Set keys = parameters.keySet();
        Iterator iterator = keys.iterator();
        bundleSymbolicName = (String)iterator.next();
        basePluginConvention.setArchivesBaseName(bundleSymbolicName);
    }

    private void _configureConventionJavaPlugin(Project project, SourceSet javaMainSourceSet) {
        File docrootDir = project.file((Object)"docroot");
        if (!docrootDir.exists()) {
            return;
        }
        File javaClassesDir = new File(docrootDir, "WEB-INF/classes");
        SourceDirectorySet javaSourceDirectorySet = javaMainSourceSet.getJava();
        DirectoryProperty directoryProperty = javaSourceDirectorySet.getDestinationDirectory();
        directoryProperty.set(javaClassesDir);
        SourceSetOutput sourceSetOutput = javaMainSourceSet.getOutput();
        sourceSetOutput.setResourcesDir(javaClassesDir);
        File srcDir = new File(docrootDir, "WEB-INF/src");
        Set<File> srcDirs = Collections.singleton(srcDir);
        javaSourceDirectorySet.setSrcDirs(srcDirs);
        SourceDirectorySet resourcesSourceDirectorySet = javaMainSourceSet.getResources();
        resourcesSourceDirectorySet.setSrcDirs(srcDirs);
    }

    private void _configureExtensionBundle(Project project, BundleExtension bundleExtension) {
        File file = project.file((Object)"bnd.bnd");
        if (!file.exists()) {
            return;
        }
        UTF8Properties utf8Properties = new UTF8Properties();
        try (Processor processor = new Processor();){
            utf8Properties.load(file, (Reporter)processor);
            Enumeration enumeration = utf8Properties.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = utf8Properties.getProperty(key);
                bundleExtension.put(key, (Object)value);
            }
        }
        catch (Exception exception) {
            throw new GradleException("Could not read " + file, (Throwable)exception);
        }
    }

    private void _configureExtensionBundleAfterEvaluate(BundleExtension bundleExtension, final LiferayOSGiExtension liferayOSGiExtension, final Configuration compileIncludeConfiguration) {
        IncludeResourceCompileIncludeInstruction includeResourceCompileIncludeInstruction = new IncludeResourceCompileIncludeInstruction(new Callable<Iterable<File>>(){

            @Override
            public Iterable<File> call() throws Exception {
                return compileIncludeConfiguration;
            }
        }, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return liferayOSGiExtension.isExpandCompileInclude();
            }
        });
        bundleExtension.instruction("-includeresource." + compileIncludeConfiguration.getName(), includeResourceCompileIncludeInstruction);
        Map<String, Object> bundleDefaultInstructions = liferayOSGiExtension.getBundleDefaultInstructions();
        for (Map.Entry<String, Object> entry : bundleDefaultInstructions.entrySet()) {
            String key = entry.getKey();
            if (bundleExtension.containsKey(key)) continue;
            bundleExtension.instruction(key, entry.getValue());
        }
    }

    private void _configureExtensionLiferay(final Project project, final LiferayExtension liferayExtension) {
        liferayExtension.setDeployDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File dir = new File(liferayExtension.getAppServerParentDir(), "osgi/modules");
                return GradleUtil.getProperty((Project)project, (String)"auto.deploy.dir", (File)dir);
            }
        });
    }

    private void _configurePluginApplication(Project project, BundleExtension bundleExtension, final Configuration compileIncludeConfiguration, Convention convention) {
        ApplicationPluginConvention applicationPluginConvention = (ApplicationPluginConvention)convention.getPlugin(ApplicationPluginConvention.class);
        String mainClassName = bundleExtension.getInstruction("Main-Class");
        if (Validator.isNotNull((String)mainClassName)) {
            applicationPluginConvention.setMainClassName(mainClassName);
        }
        TaskProvider runTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"run", JavaExec.class);
        runTaskProvider.configure((Action)new Action<JavaExec>(){

            public void execute(JavaExec runJavaExec) {
                runJavaExec.classpath(new Object[]{compileIncludeConfiguration});
            }
        });
    }

    private void _configureProject(Project project, BundleExtension bundleExtension) {
        String version;
        String description = bundleExtension.getInstruction("Bundle-Description");
        if (Validator.isNull((String)description)) {
            description = bundleExtension.getInstruction("Bundle-Name");
        }
        if (Validator.isNotNull((String)description)) {
            project.setDescription(description);
        }
        if (Validator.isNotNull((String)(version = bundleExtension.getInstruction("Bundle-Version")))) {
            project.setVersion((Object)version);
        }
    }

    private void _configureTaskAutoUpdateXmlProvider(final Project project, final LiferayExtension liferayExtension, final LiferayOSGiExtension liferayOSGiExtension, final TaskProvider<DirectDeployTask> directDeployTaskProvider, final TaskProvider<Jar> jarTaskProvider) {
        directDeployTaskProvider.configure((Action)new Action<DirectDeployTask>(){

            public void execute(final DirectDeployTask directDeployTask) {
                directDeployTask.setAppServerDeployDir(directDeployTask.getTemporaryDir());
                directDeployTask.setAppServerType("tomcat");
                final Jar jar = (Jar)jarTaskProvider.get();
                directDeployTask.setWebAppFile(new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return FileUtil.replaceExtension((File)jar.getArchivePath(), (String)"war");
                    }
                });
                directDeployTask.setWebAppType("portlet");
                directDeployTask.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        File jarFile = jar.getArchivePath();
                        jarFile.renameTo(directDeployTask.getWebAppFile());
                    }
                });
                directDeployTask.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        Logger logger = task.getLogger();
                        project.delete(new Object[]{"liferay/logs"});
                        File liferayDir = project.file((Object)"liferay");
                        boolean deleted = liferayDir.delete();
                        if (!deleted && logger.isInfoEnabled()) {
                            logger.info("Unable to delete " + liferayDir);
                        }
                    }
                });
                directDeployTask.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        Property property = jar.getArchiveFileName();
                        String deployedPluginDirName = FileUtil.stripExtension((String)((String)property.get()));
                        File deployedPluginDir = new File(directDeployTask.getAppServerDeployDir(), deployedPluginDirName);
                        if (!deployedPluginDir.exists()) {
                            deployedPluginDir = new File(directDeployTask.getAppServerDeployDir(), project.getName());
                        }
                        if (!deployedPluginDir.exists()) {
                            _logger.warn("Unable to automatically update web.xml in " + jar.getArchivePath());
                            return;
                        }
                        FileUtil.touchFiles(project, deployedPluginDir, 0L, "WEB-INF/liferay-web.xml", "WEB-INF/web.xml", "WEB-INF/tld/*");
                        deployedPluginDirName = project.relativePath((Object)deployedPluginDir);
                        String[][] filesets = new String[][]{{project.relativePath((Object)liferayExtension.getAppServerPortalDir()), "WEB-INF/tld/c.tld"}, {deployedPluginDirName, "WEB-INF/liferay-web.xml,WEB-INF/web.xml"}, {deployedPluginDirName, "WEB-INF/tld/*"}};
                        File warFile = directDeployTask.getWebAppFile();
                        FileUtil.jar((Project)project, (File)warFile, (String)"preserve", (boolean)true, (String[][])filesets);
                        warFile.renameTo(jar.getArchivePath());
                    }
                });
                directDeployTask.onlyIf((Spec)new Spec<Task>(){

                    public boolean isSatisfiedBy(Task task) {
                        return liferayOSGiExtension.isAutoUpdateXml() && FileUtil.exists((Project)project, (String)"docroot/WEB-INF/portlet.xml");
                    }
                });
                TaskInputsInternal taskInputs = directDeployTask.getInputs();
                taskInputs.file(() -> ((Jar)jar).getArchivePath());
            }
        });
        jarTaskProvider.configure((Action)new Action<Jar>(){

            public void execute(Jar jar) {
                jar.finalizedBy(new Object[]{directDeployTaskProvider});
            }
        });
    }

    private void _configureTaskBuildWSDDJarProvider(final Project project, final BundleExtension bundleExtension, LiferayExtension liferayExtension, final LiferayOSGiExtension liferayOSGiExtension, final SourceSet javaMainSourceSet, final BuildWSDDTask buildWSDDTask, TaskProvider<Jar> buildWSDDJarTaskProvider, TaskProvider<Delete> cleanTaskProvider, TaskProvider<Copy> deployTaskProvider) {
        buildWSDDJarTaskProvider.configure((Action)new Action<Jar>(){

            public void execute(Jar buildWSDDJar) {
                buildWSDDJar.setActions(Collections.emptyList());
                buildWSDDJar.dependsOn(new Object[]{buildWSDDTask});
                buildWSDDJar.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        Logger logger = project.getLogger();
                        BeanProperties beanProperties = new BeanProperties();
                        beanProperties.put("project", project);
                        beanProperties.put("task", task);
                        try (Builder builder = new Builder(new Processor((Properties)beanProperties, false));){
                            String bundleVersion;
                            String bundleSymbolicName;
                            Map properties = LiferayOSGiPlugin.this._getBuilderProperties(project, bundleExtension, liferayOSGiExtension, buildWSDDTask);
                            File buildFile = project.getBuildFile();
                            builder.setBase(buildFile.getParentFile());
                            builder.putAll(properties, true);
                            SourceDirectorySet sourceDirectorySet = javaMainSourceSet.getJava();
                            SourceSetOutput sourceSetOutput = javaMainSourceSet.getOutput();
                            ConfigurableFileCollection buildDirs = project.files(new Object[]{sourceDirectorySet.getClassesDirectory(), sourceSetOutput.getResourcesDir()});
                            Set buildDirsFiles = buildDirs.getFiles();
                            builder.setClasspath(buildDirsFiles.toArray(new File[0]));
                            builder.setProperty("project.buildpath", buildDirs.getAsPath());
                            if (logger.isDebugEnabled()) {
                                logger.lifecycle("BND Builder Classpath {}: {}", new Object[]{project.getName(), buildDirs.getAsPath()});
                            }
                            SourceDirectorySet allSource = javaMainSourceSet.getAllSource();
                            Set srcDirs = allSource.getSrcDirs();
                            Stream stream = srcDirs.stream();
                            ConfigurableFileCollection sourceDirs = project.files(new Object[]{stream.filter(File::exists).collect(Collectors.toList())});
                            builder.setProperty("project.sourcepath", sourceDirs.getAsPath());
                            Set sourceDirsFiles = sourceDirs.getFiles();
                            builder.setSourcepath(sourceDirsFiles.toArray(new File[0]));
                            if (logger.isDebugEnabled()) {
                                logger.debug("BND Builder Sourcepath {}: {}", (Object)project.getName(), (Object)builder.getSourcePath());
                            }
                            if (Validator.isNull((String)(bundleSymbolicName = builder.getProperty("Bundle-SymbolicName"))) || "<<EMPTY>>".equals(bundleSymbolicName)) {
                                builder.setProperty("Bundle-SymbolicName", project.getName());
                            }
                            if ((Validator.isNull((String)(bundleVersion = builder.getProperty("Bundle-Version"))) || "<<EMPTY>>".equals(bundleVersion)) && project.getVersion() != null) {
                                Object version = project.getVersion();
                                MavenVersion mavenVersion = MavenVersion.parseString((String)version.toString());
                                Version osgiVersion = mavenVersion.getOSGiVersion();
                                builder.setProperty("Bundle-Version", osgiVersion.toString());
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("BND Builder Properties {}: {}", (Object)project.getName(), (Object)properties);
                            }
                            aQute.bnd.osgi.Jar bndJar = builder.build();
                            if (!builder.isOk()) {
                                BndUtils.logReport((Report)builder, (Logger)logger);
                                new GradleException(buildWSDDTask + " failed");
                            }
                            TaskOutputs taskOutputs = task.getOutputs();
                            FileCollection fileCollection = taskOutputs.getFiles();
                            bndJar.write(fileCollection.getSingleFile());
                            BndUtils.logReport((Report)builder, (Logger)logger);
                            if (!builder.isOk()) {
                                new GradleException(buildWSDDTask + " failed");
                            }
                        }
                        catch (Exception exception) {
                            throw new GradleException(buildWSDDTask + " failed", (Throwable)exception);
                        }
                    }
                });
                String taskName = buildWSDDTask.getName();
                Property property = buildWSDDJar.getArchiveAppendix();
                if (taskName.equals("buildWSDD")) {
                    property.set((Object)"wsdd");
                } else {
                    property.set((Object)("wsdd-" + taskName));
                }
                buildWSDDTask.finalizedBy(new Object[]{buildWSDDJar});
            }
        });
        this._configureTaskCleanProvider(liferayExtension, cleanTaskProvider, deployTaskProvider, buildWSDDJarTaskProvider);
        this._configureTaskDeployProvider(project, liferayExtension, deployTaskProvider, buildWSDDJarTaskProvider, true);
    }

    private void _configureTaskCleanProvider(final LiferayExtension liferayExtension, TaskProvider<Delete> cleanTaskProvider, final TaskProvider<Copy> deployTaskProvider, final TaskProvider<Jar> jarTaskProvider) {
        cleanTaskProvider.configure((Action)new Action<Delete>(){

            public void execute(final Delete cleanDelete) {
                cleanDelete.delete(new Object[]{new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        boolean cleanDeployed = GradleUtil.getProperty((ExtensionAware)cleanDelete, (String)LiferayOSGiPlugin.CLEAN_DEPLOYED_PROPERTY_NAME, (boolean)true);
                        if (!cleanDeployed) {
                            return null;
                        }
                        Copy deployCopy = (Copy)deployTaskProvider.get();
                        Jar jar = (Jar)jarTaskProvider.get();
                        Closure<String> deployedFileNameClosure = liferayExtension.getDeployedFileNameClosure();
                        return new File(deployCopy.getDestinationDir(), (String)deployedFileNameClosure.call((Object)jar));
                    }
                }});
            }
        });
    }

    private void _configureTaskCleanProvider(final Project project, TaskProvider<Delete> cleanTaskProvider) {
        cleanTaskProvider.configure((Action)new Action<Delete>(){

            public void execute(Delete cleanDelete) {
                Closure<Set<String>> c = new Closure<Set<String>>((Object)project){

                    public Set<String> doCall(Delete delete) {
                        HashSet<String> cleanTaskNames = new HashSet<String>();
                        Project project = delete.getProject();
                        for (Task task : project.getTasks()) {
                            TaskOutputs taskOutputs;
                            boolean autoClean;
                            String taskName = task.getName();
                            if (taskName.equals("deploy") || taskName.equals("buildSoy") || taskName.equals("eclipseClasspath") || taskName.equals("eclipseProject") || taskName.equals("ideaModule") || task instanceof DownloadNodeModuleTask || task instanceof NpmInstallTask || GradleUtil.hasPlugin(project, LiferayOSGiPlugin._CACHE_PLUGIN_ID) && taskName.startsWith("save") && taskName.endsWith("Cache") || GradleUtil.hasPlugin(project, WSDLBuilderPlugin.class) && taskName.startsWith("buildWSDLGenerate") || !(autoClean = GradleUtil.getProperty((ExtensionAware)task, (String)LiferayOSGiPlugin.AUTO_CLEAN_PROPERTY_NAME, (boolean)true)) || !(taskOutputs = task.getOutputs()).getHasOutput()) continue;
                            cleanTaskNames.add("clean" + StringUtil.capitalize((String)taskName));
                        }
                        return cleanTaskNames;
                    }
                };
                cleanDelete.dependsOn(new Object[]{c});
            }
        });
    }

    private void _configureTaskCompileTestJavaProviderAfterEvaluate(final Project project, TaskProvider<JavaCompile> compileTestJavaTaskProvider) {
        compileTestJavaTaskProvider.configure((Action)new Action<JavaCompile>(){

            public void execute(JavaCompile javaCompile) {
                Configuration testImplementationConfiguration = GradleUtil.getConfiguration((Project)project, (String)"testImplementation");
                DependencySet dependencySet = testImplementationConfiguration.getDependencies();
                for (ProjectDependency projectDependency : dependencySet.withType(ProjectDependency.class)) {
                    Project dependencyProject = projectDependency.getDependencyProject();
                    javaCompile.mustRunAfter(new Object[]{dependencyProject.getPath() + ":" + "processResources"});
                }
            }
        });
    }

    private void _configureTaskDeployDependenciesProvider(final LiferayExtension liferayExtension, TaskProvider<Copy> deployDependenciesTaskProvider) {
        deployDependenciesTaskProvider.configure((Action)new Action<Copy>(){

            public void execute(Copy deployDependenciesCopy) {
                boolean keepVersions = Boolean.getBoolean("deploy.dependencies.keep.versions");
                GradleUtil.setProperty((ExtensionAware)deployDependenciesCopy, (String)LiferayOSGiPlugin.AUTO_CLEAN_PROPERTY_NAME, (Object)false);
                GradleUtil.setProperty((ExtensionAware)deployDependenciesCopy, (String)"keepVersions", (Object)keepVersions);
                String renameSuffix = ".jar";
                if (keepVersions) {
                    renameSuffix = "-$1.jar";
                }
                GradleUtil.setProperty((ExtensionAware)deployDependenciesCopy, (String)"renameSuffix", (Object)renameSuffix);
                deployDependenciesCopy.into(liferayExtension::getDeployDir);
                deployDependenciesCopy.setDescription("Deploys additional dependencies.");
                TaskOutputsInternal taskOutputs = deployDependenciesCopy.getOutputs();
                taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

                    public boolean isSatisfiedBy(Task task) {
                        return false;
                    }
                });
            }
        });
    }

    private void _configureTaskDeployDependenciesProviderAfterEvaluate(TaskProvider<Copy> deployDependenciesTaskProvider) {
        deployDependenciesTaskProvider.configure((Action)new Action<Copy>(){

            public void execute(Copy deployDependenciesCopy) {
                deployDependenciesCopy.eachFile((Action)new RenameDependencyAction(Boolean.getBoolean("deploy.dependencies.keep.versions")));
            }
        });
    }

    private void _configureTaskDeployProvider(final Project project, final LiferayExtension liferayExtension, TaskProvider<Copy> deployTaskProvider, final TaskProvider<Jar> jarTaskProvider, final boolean lazy) {
        deployTaskProvider.configure((Action)new Action<Copy>(){

            public void execute(Copy deployCopy) {
                Jar jar;
                Object sourcePath = jar = (Jar)jarTaskProvider.get();
                if (lazy) {
                    sourcePath = new Callable<File>(){

                        @Override
                        public File call() throws Exception {
                            return jar.getArchivePath();
                        }
                    };
                }
                Closure<Void> copySpecClosure = new Closure<Void>((Object)project){

                    public void doCall(CopySpec copySpec) {
                        copySpec.rename((Closure)new Closure<String>((Object)project){

                            public String doCall(String fileName) {
                                Closure<String> closure = liferayExtension.getDeployedFileNameClosure();
                                return (String)closure.call((Object)jar);
                            }
                        });
                    }
                };
                deployCopy.from(sourcePath, (Closure)copySpecClosure);
            }
        });
    }

    private void _configureTaskDeployProvider(TaskProvider<Copy> deployTaskProvider, final TaskProvider<Copy> deployDependenciesTaskProvider) {
        deployTaskProvider.configure((Action)new Action<Copy>(){

            public void execute(Copy deployCopy) {
                deployCopy.finalizedBy(new Object[]{deployDependenciesTaskProvider});
            }
        });
    }

    private void _configureTaskJarProvider(final Project project, final BundleExtension bundleExtension, TaskProvider<Jar> jarTaskProvider, final TaskProvider<Task> zipZippableResourcesTaskProvider) {
        jarTaskProvider.configure((Action)new Action<Jar>(){

            public void execute(Jar jar) {
                jar.dependsOn(new Object[]{zipZippableResourcesTaskProvider});
                Convention convention = jar.getConvention();
                Map plugins = convention.getPlugins();
                final BundleTaskExtension bundleTaskExtension = new BundleTaskExtension(jar);
                plugins.put("bundle", bundleTaskExtension);
                jar.setDescription("Assembles a bundle containing the main classes.");
                jar.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        for (Map.Entry entry : bundleExtension.entrySet()) {
                            bundleExtension.instruction((String)entry.getKey(), GradleUtil.toString(entry.getValue()));
                        }
                        Map projectProperties = project.getProperties();
                        for (Map.Entry entry : projectProperties.entrySet()) {
                            String key = (String)entry.getKey();
                            Object value = entry.getValue();
                            Matcher matcher = _keyPattern.matcher(key);
                            if (!matcher.matches() || !(value instanceof String)) continue;
                            bundleExtension.instruction(key, entry.getValue());
                        }
                        bundleTaskExtension.setBnd((Map)bundleExtension);
                    }
                });
                jar.doLast(bundleTaskExtension.buildAction());
                File bndFile = project.file((Object)"bnd.bnd");
                if (!bndFile.exists()) {
                    return;
                }
                TaskInputsInternal taskInputs = jar.getInputs();
                taskInputs.file((Object)bndFile);
            }
        });
    }

    private void _configureTaskJavaCompile(JavaCompile javaCompile, boolean fork) {
        if (GradleUtil.isRunningInsideDaemon()) {
            CompileOptions compileOptions = javaCompile.getOptions();
            compileOptions.setFork(fork);
        }
    }

    private void _configureTaskJavadocProvider(BundleExtension bundleExtension, TaskProvider<Javadoc> javadocTaskProvider) {
        final String bundleName = bundleExtension.getInstruction("Bundle-Name");
        final String bundleVersion = bundleExtension.getInstruction("Bundle-Version");
        if (Validator.isNull((String)bundleName) || Validator.isNull((String)bundleVersion)) {
            return;
        }
        javadocTaskProvider.configure((Action)new Action<Javadoc>(){

            public void execute(Javadoc javadoc) {
                String title = String.format("%s %s API", bundleName, bundleVersion);
                javadoc.setTitle(title);
            }
        });
    }

    private void _configureTaskTest(Test test) {
        test.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
    }

    private void _configureTaskTestProvider(TaskProvider<Test> testTaskProvider) {
        testTaskProvider.configure((Action)new Action<Test>(){

            public void execute(Test test) {
                test.jvmArgs(new Object[]{"-Djava.net.preferIPv4Stack=true", "-Duser.timezone=GMT"});
                test.setForkEvery(1L);
            }
        });
    }

    private void _configureTaskZippableResources(final Project project, TaskProvider<Zip> zippableResourcesTaskProvider, final File zippableResourcesDir) {
        zippableResourcesTaskProvider.configure((Action)new Action<Zip>(){

            public void execute(Zip zippableResourcesZip) {
                Provider provider = zippableResourcesZip.getArchiveFile();
                RegularFile regularFile = (RegularFile)provider.get();
                File zippableResourcesFile = regularFile.getAsFile();
                StringBuilder sb = new StringBuilder();
                sb.append("Assembles ");
                sb.append(project.relativePath((Object)zippableResourcesFile));
                sb.append(" with the contents of the ");
                sb.append(project.relativePath((Object)zippableResourcesDir));
                sb.append(" directory.");
                zippableResourcesZip.setDescription(sb.toString());
                zippableResourcesZip.from(new Object[]{zippableResourcesDir});
                Property property = zippableResourcesZip.getArchiveFileName();
                property.set((Object)(zippableResourcesDir.getName() + ".zip"));
                DirectoryProperty directoryProperty = zippableResourcesZip.getDestinationDirectory();
                directoryProperty.set(project.file((Object)"classes"));
            }
        });
    }

    private void _configureTaskZipZippableResources(final Project project, final List<TaskProvider<Zip>> zippableResourcesTaskProviders, TaskProvider<Task> zipZippableResourcesTaskProvider) {
        zipZippableResourcesTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task zipZippableResourcesTask) {
                File zippableResourcesDir = project.file((Object)"src/main/zippableResources");
                StringBuilder sb = new StringBuilder();
                sb.append("Assembles Zip files from the subdirectories ");
                sb.append(project.relativePath((Object)zippableResourcesDir));
                sb.append('.');
                zipZippableResourcesTask.setDescription(sb.toString());
                for (TaskProvider zippableResourcesTaskProvider : zippableResourcesTaskProviders) {
                    zipZippableResourcesTask.dependsOn(new Object[]{zippableResourcesTaskProvider});
                }
            }
        });
    }

    private Map<String, String> _getBuilderProperties(Project project, BundleExtension bundleExtension, LiferayOSGiExtension liferayOSGiExtension, BuildWSDDTask buildWSDDTask) {
        Map<String, String> properties = GradleUtil.toStringMap(liferayOSGiExtension.getBundleDefaultInstructions());
        Map projectProperties = project.getProperties();
        for (Map.Entry entry : projectProperties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!Character.isLowerCase(key.charAt(0)) || value == null) continue;
            properties.put(key, GradleUtil.toString(value));
        }
        properties.remove("-donotcopy");
        properties.remove("-liferay-service-xml");
        String bundleName = bundleExtension.getInstruction("Bundle-Name");
        if (Validator.isNotNull((String)bundleName)) {
            properties.put("Bundle-Name", bundleName + " WSDD descriptors");
        }
        String bundleSymbolicName = bundleExtension.getInstruction("Bundle-SymbolicName");
        properties.put("Bundle-SymbolicName", bundleSymbolicName + ".wsdd");
        properties.put("Fragment-Host", bundleSymbolicName);
        properties.put("Import-Package", "javax.servlet,javax.servlet.http");
        StringBuilder sb = new StringBuilder();
        sb.append("WEB-INF/=");
        sb.append(FileUtil.getRelativePath(project, buildWSDDTask.getServerConfigFile()));
        sb.append(',');
        sb.append(FileUtil.getRelativePath(project, buildWSDDTask.getOutputDir()));
        sb.append(";filter:=*.wsdd");
        properties.put("Include-Resource", sb.toString());
        return properties;
    }
}

