/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.util.StringUtil;
import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskProvider;

public class LiferayAntPlugin
implements Plugin<Project> {
    private static final String _WAR_TASK_NAME = "war";
    private static final Transformer<String, String> _antTaskNamer = new Transformer<String, String>(){

        public String transform(String targetName) {
            if (targetName.equals("clean") || targetName.equals("publish")) {
                targetName = "ant" + StringUtil.capitalize((String)targetName);
            }
            return targetName;
        }
    };

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        AntBuilder antBuilder = project.getAnt();
        antBuilder.importBuild((Object)"build.xml", _antTaskNamer);
        Convention convention = project.getConvention();
        final BasePluginConvention basePluginConvention = (BasePluginConvention)convention.getPlugin(BasePluginConvention.class);
        this._configureConventionBasePlugin(antBuilder, basePluginConvention);
        TaskProvider cleanTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"clean", Delete.class);
        final TaskProvider warTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)_WAR_TASK_NAME);
        this._configureTaskCleanProvider((TaskProvider<Delete>)cleanTaskProvider);
        this._configureProject(project, antBuilder);
        ArtifactHandler artifacts = project.getArtifacts();
        artifacts.add("archives", (Object)project.file(antBuilder.getProperty("plugin.file")), (Closure)new Closure<Void>((Object)project){

            public void doCall(ConfigurablePublishArtifact configurablePublishArtifact) {
                configurablePublishArtifact.builtBy(new Object[]{warTaskProvider.get()});
                configurablePublishArtifact.setName(basePluginConvention.getArchivesBaseName());
            }
        });
    }

    private void _configureConventionBasePlugin(AntBuilder antBuilder, BasePluginConvention basePluginConvention) {
        basePluginConvention.setArchivesBaseName(String.valueOf(antBuilder.getProperty("plugin.name")));
    }

    private void _configureProject(Project project, AntBuilder antBuilder) {
        project.setVersion(antBuilder.getProperty("plugin.full.version"));
    }

    private void _configureTaskCleanProvider(TaskProvider<Delete> cleanTaskProvider) {
        cleanTaskProvider.configure((Action)new Action<Delete>(){

            public void execute(Delete cleanDelete) {
                cleanDelete.dependsOn(new Object[]{_antTaskNamer.transform((Object)cleanDelete.getName())});
            }
        });
    }
}

