/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.task.ExecutePackageManagerTask;
import com.liferay.gradle.plugins.node.task.NpmInstallTask;
import com.liferay.gradle.plugins.node.task.PublishNodeModuleTask;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;

public class NodeDefaultsPlugin
extends BaseDefaultsPlugin<NodePlugin> {
    private static final String _NODE_VERSION = "20.12.2";
    private static final String _NPM_VERSION = "10.5.0";
    private static final String _SASS_BINARY_SITE_ARG = "--sass-binary-site=";

    @Override
    protected void applyPluginDefaults(Project project, NodePlugin nodePlugin) {
        ExtensionContainer extensionContainer = project.getExtensions();
        NodeExtension nodeExtension = (NodeExtension)extensionContainer.getByType(NodeExtension.class);
        this._configureExtensionNode(project, nodeExtension);
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecutePackageManagerTask.class, (Action)new Action<ExecutePackageManagerTask>(){

            public void execute(ExecutePackageManagerTask executePackageManagerTask) {
                NodeDefaultsPlugin.this._configureTaskExecutePackageManager(executePackageManagerTask);
            }
        });
        taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

            public void execute(NpmInstallTask npmInstallTask) {
                NodeDefaultsPlugin.this._configureTaskNpmInstall(npmInstallTask);
            }
        });
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                NodeDefaultsPlugin.this._configureTaskPublishNodeModule(publishNodeModuleTask);
            }
        });
    }

    @Override
    protected Class<NodePlugin> getPluginClass() {
        return NodePlugin.class;
    }

    private void _configureExtensionNode(Project project, NodeExtension nodeExtension) {
        nodeExtension.setGlobal(true);
        nodeExtension.setNodeVersion((Object)_NODE_VERSION);
        nodeExtension.setNpmVersion((Object)_NPM_VERSION);
        String npmArgs = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.args", (String)null);
        if (Validator.isNotNull((String)npmArgs)) {
            nodeExtension.npmArgs((Object[])npmArgs.split("\\s+"));
        }
    }

    private void _configureTaskExecutePackageManager(ExecutePackageManagerTask executePackageManagerTask) {
        String registry;
        String nodeEnv = GradleUtil.getProperty((ExtensionAware)executePackageManagerTask.getProject(), (String)"nodejs.node.env", (String)null);
        if (Validator.isNotNull((String)nodeEnv)) {
            executePackageManagerTask.environment((Object)"NODE_ENV", (Object)nodeEnv);
        }
        if (Validator.isNotNull((String)(registry = GradleUtil.getProperty((ExtensionAware)executePackageManagerTask.getProject(), (String)"nodejs.npm.registry", (String)null)))) {
            executePackageManagerTask.setRegistry((Object)registry);
        }
    }

    private void _configureTaskNpmInstall(NpmInstallTask npmInstallTask) {
        String sassBinarySite = GradleUtil.getProperty((ExtensionAware)npmInstallTask.getProject(), (String)"nodejs.npm.sass.binary.site", (String)null);
        if (Validator.isNotNull((String)sassBinarySite)) {
            boolean sassBinarySiteArg = false;
            for (Object object : npmInstallTask.getArgs()) {
                String arg = GradleUtil.toString(object);
                if (!arg.startsWith(_SASS_BINARY_SITE_ARG)) continue;
                sassBinarySiteArg = true;
            }
            if (!sassBinarySiteArg) {
                npmInstallTask.args(new Object[]{_SASS_BINARY_SITE_ARG + sassBinarySite});
            }
        }
    }

    private void _configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        String npmAccessToken;
        String moduleRepository;
        String moduleLicense;
        String moduleBugsUrl;
        Project project = publishNodeModuleTask.getProject();
        String moduleAuthor = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.module.author", (String)null);
        if (Validator.isNotNull((String)moduleAuthor)) {
            publishNodeModuleTask.setModuleAuthor((Object)moduleAuthor);
        }
        if (Validator.isNotNull((String)(moduleBugsUrl = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.module.bugs.url", (String)null)))) {
            publishNodeModuleTask.setModuleBugsUrl((Object)moduleBugsUrl);
        }
        if (Validator.isNotNull((String)(moduleLicense = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.module.license", (String)null)))) {
            publishNodeModuleTask.setModuleLicense((Object)moduleLicense);
        }
        if (Validator.isNotNull((String)(moduleRepository = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.module.repository", (String)null)))) {
            publishNodeModuleTask.setModuleRepository((Object)moduleRepository);
        }
        if (Validator.isNotNull((String)(npmAccessToken = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.access.token", (String)null)))) {
            publishNodeModuleTask.setNpmAccessToken((Object)npmAccessToken);
        }
    }
}

