/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.LiferayOSGiPlugin;
import com.liferay.gradle.plugins.db.support.DBSupportPlugin;
import com.liferay.gradle.plugins.db.support.tasks.CleanServiceBuilderTask;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.service.builder.BuildServiceTask;
import com.liferay.gradle.plugins.service.builder.ServiceBuilderPlugin;
import com.liferay.gradle.plugins.tasks.BuildDBTask;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class ServiceBuilderDefaultsPlugin
extends BaseDefaultsPlugin<ServiceBuilderPlugin> {
    public static final String BUILD_DB_TASK_NAME = "buildDB";
    public static final Plugin<Project> INSTANCE = new ServiceBuilderDefaultsPlugin();
    private static final String _PORTAL_TOOL_NAME = "com.liferay.portal.tools.service.builder";

    @Override
    protected void applyPluginDefaults(final Project project, ServiceBuilderPlugin serviceBuilderPlugin) {
        GradleUtil.applyPlugin((Project)project, DBSupportPlugin.class);
        PortalTools.addPortalToolDependencies(project, "serviceBuilder", "com.liferay", _PORTAL_TOOL_NAME);
        TaskProvider buildDBTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)BUILD_DB_TASK_NAME, BuildDBTask.class);
        TaskProvider buildServiceTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"buildService", BuildServiceTask.class);
        TaskProvider cleanServiceBuilderTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"cleanServiceBuilder", CleanServiceBuilderTask.class);
        TaskProvider processResourcesTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"processResources", Copy.class);
        this._configureTaskBuildDBProvider((TaskProvider<BuildDBTask>)buildDBTaskProvider, (TaskProvider<BuildServiceTask>)buildServiceTaskProvider);
        this._configureTaskCleanServiceBuilderProvider((TaskProvider<BuildServiceTask>)buildServiceTaskProvider, (TaskProvider<CleanServiceBuilderTask>)cleanServiceBuilderTaskProvider);
        this._configureTaskProcessResourcesProvider((TaskProvider<BuildServiceTask>)buildServiceTaskProvider, (TaskProvider<Copy>)processResourcesTaskProvider);
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildServiceTask.class, (Action)new Action<BuildServiceTask>(){

            public void execute(BuildServiceTask buildServiceTask) {
                ServiceBuilderDefaultsPlugin.this._configureTaskBuildService(buildServiceTask);
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(LiferayBasePlugin.class, (Action)new Action<LiferayBasePlugin>(){

            public void execute(LiferayBasePlugin liferayBasePlugin) {
                TaskContainer taskContainer = project.getTasks();
                taskContainer.withType(BuildDBTask.class, (Action)new Action<BuildDBTask>(){

                    public void execute(BuildDBTask buildDBTask) {
                        ServiceBuilderDefaultsPlugin.this._configureTaskBuildDBForLiferayBasePlugin(buildDBTask);
                    }
                });
            }
        });
        pluginContainer.withType(LiferayOSGiPlugin.class, (Action)new Action<LiferayOSGiPlugin>(){

            public void execute(LiferayOSGiPlugin liferayOSGiPlugin) {
                TaskContainer taskContainer = project.getTasks();
                taskContainer.withType(BuildServiceTask.class, (Action)new Action<BuildServiceTask>(){

                    public void execute(BuildServiceTask buildServiceTask) {
                        ServiceBuilderDefaultsPlugin.this._configureTaskBuildServiceForLiferayOSGiPlugin(buildServiceTask);
                    }
                });
            }
        });
    }

    @Override
    protected Class<ServiceBuilderPlugin> getPluginClass() {
        return ServiceBuilderPlugin.class;
    }

    private ServiceBuilderDefaultsPlugin() {
    }

    private void _configureTaskBuildDBForLiferayBasePlugin(BuildDBTask buildDBTask) {
        Configuration portalConfiguration = GradleUtil.getConfiguration((Project)buildDBTask.getProject(), (String)"portal");
        buildDBTask.setClasspath((FileCollection)portalConfiguration);
    }

    private void _configureTaskBuildDBProvider(TaskProvider<BuildDBTask> buildDBTaskProvider, final TaskProvider<BuildServiceTask> buildServiceTaskProvider) {
        buildDBTaskProvider.configure((Action)new Action<BuildDBTask>(){

            public void execute(BuildDBTask buildDBTask) {
                buildDBTask.setDatabaseName("lportal");
                buildDBTask.setDatabaseTypes("hypersonic", "mysql", "postgresql");
                buildDBTask.setDescription("Builds database SQL scripts from the generic SQL scripts.");
                buildDBTask.setGroup("build");
                buildDBTask.setSqlDir(new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        BuildServiceTask buildServiceTask = (BuildServiceTask)buildServiceTaskProvider.get();
                        return buildServiceTask.getSqlDir();
                    }
                });
            }
        });
    }

    private void _configureTaskBuildService(BuildServiceTask buildServiceTask) {
        String incubationFeatures = GradleUtil.getProperty((ExtensionAware)buildServiceTask.getProject(), (String)"service.builder.incubation.features", (String)null);
        if (Validator.isNotNull((String)incubationFeatures)) {
            buildServiceTask.setIncubationFeatures(incubationFeatures.split(","));
        }
    }

    private void _configureTaskBuildServiceForLiferayOSGiPlugin(BuildServiceTask buildServiceTask) {
        buildServiceTask.setOsgiModule(true);
    }

    private void _configureTaskCleanServiceBuilderProvider(final TaskProvider<BuildServiceTask> buildServiceTaskProvider, TaskProvider<CleanServiceBuilderTask> cleanServiceBuilderTaskProvider) {
        cleanServiceBuilderTaskProvider.configure((Action)new Action<CleanServiceBuilderTask>(){

            public void execute(CleanServiceBuilderTask cleanServiceBuilderTask) {
                cleanServiceBuilderTask.setServiceXmlFile((Object)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        BuildServiceTask buildServiceTask = (BuildServiceTask)buildServiceTaskProvider.get();
                        return buildServiceTask.getInputFile();
                    }
                });
            }
        });
    }

    private void _configureTaskProcessResourcesProvider(final TaskProvider<BuildServiceTask> buildServiceTaskProvider, TaskProvider<Copy> processResourcesTaskProvider) {
        processResourcesTaskProvider.configure((Action)new Action<Copy>(){

            public void execute(Copy processResourcesCopy) {
                processResourcesCopy.into((Object)"META-INF", (Closure)new Closure<Void>((Object)processResourcesCopy){

                    public void doCall(CopySpec copySpec) {
                        BuildServiceTask buildServiceTask = (BuildServiceTask)buildServiceTaskProvider.get();
                        File inputFile = buildServiceTask.getInputFile();
                        File dir = inputFile.getParentFile();
                        String dirName = dir.getName();
                        if (!dirName.equals("META-INF")) {
                            copySpec.from(new Object[]{inputFile});
                        }
                    }
                });
            }
        });
    }
}

