/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import groovy.lang.Closure;
import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.XmlProvider;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaModuleIml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IdeaDefaultsPlugin
extends BaseDefaultsPlugin<IdeaPlugin> {
    public static final Plugin<Project> INSTANCE = new IdeaDefaultsPlugin();
    private static final String _CLEAN_IDEA_TASK_NAME = "cleanIdea";
    private static final String _IDEA_TASK_NAME = "idea";

    @Override
    protected void applyPluginDefaults(Project project, IdeaPlugin ideaPlugin) {
        TaskProvider ideaTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)_IDEA_TASK_NAME);
        this._configureTaskIdeaProvider((TaskProvider<Task>)ideaTaskProvider);
        IdeaModel ideaModel = ideaPlugin.getModel();
        final IdeaModule ideaModule = ideaModel.getModule();
        this._configureIdeaModule(project, ideaModule);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                IdeaDefaultsPlugin.this._configureIdeaModuleAfterEvaluate(project, ideaModule);
            }
        });
    }

    @Override
    protected Class<IdeaPlugin> getPluginClass() {
        return IdeaPlugin.class;
    }

    private IdeaDefaultsPlugin() {
    }

    private void _configureIdeaModule(final Project project, IdeaModule ideaModule) {
        IdeaModuleIml ideaModuleIml = ideaModule.getIml();
        Closure<Void> closure = new Closure<Void>((Object)project){

            public void doCall(XmlProvider xmlProvider) throws Exception {
                if (!GradleUtil.hasPlugin(project, JavaPlugin.class)) {
                    return;
                }
                SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
                File resourcesDir = new File(GradleUtil.getSrcDir(sourceSet.getResources()), "META-INF/resources");
                if (!resourcesDir.exists()) {
                    return;
                }
                Element moduleElement = xmlProvider.asElement();
                Document document = moduleElement.getOwnerDocument();
                Element componentElement = document.createElement("component");
                componentElement.setAttribute("name", "FacetManager");
                NodeList componentElements = moduleElement.getElementsByTagName("component");
                moduleElement.insertBefore(componentElement, componentElements.item(componentElements.getLength() - 1));
                Element facetElement = document.createElement("facet");
                facetElement.setAttribute("name", "Web");
                facetElement.setAttribute("type", "web");
                componentElement.appendChild(facetElement);
                Element configurationElement = document.createElement("configuration");
                facetElement.appendChild(configurationElement);
                Element webrootsElement = document.createElement("webroots");
                configurationElement.appendChild(webrootsElement);
                Element rootElement = document.createElement("root");
                rootElement.setAttribute("relative", "/");
                String url = project.relativePath((Object)resourcesDir);
                rootElement.setAttribute("url", "file://$MODULE_DIR$/" + url.replace('\\', '/'));
                webrootsElement.appendChild(rootElement);
            }
        };
        ideaModuleIml.withXml((Closure)closure);
    }

    private void _configureIdeaModuleAfterEvaluate(Project project, IdeaModule ideaModule) {
        Set excludeDirs = ideaModule.getExcludeDirs();
        if (GradleUtil.hasPlugin(project, JavaPlugin.class)) {
            SourceSetOutput sourceSetOutput;
            File resourcesDir;
            SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
            File javaClassesDir = FileUtil.getJavaClassesDir((SourceSet)sourceSet);
            if (!FileUtil.isChild((File)javaClassesDir, (File)project.getBuildDir())) {
                excludeDirs.add(javaClassesDir);
            }
            if (!FileUtil.isChild((File)(resourcesDir = (sourceSetOutput = sourceSet.getOutput()).getResourcesDir()), (File)project.getBuildDir())) {
                excludeDirs.add(resourcesDir);
            }
        }
        if (GradleUtil.hasPlugin(project, NodePlugin.class)) {
            TaskProvider npmInstallTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"npmInstall", NpmInstallTask.class);
            NpmInstallTask npmInstallTask = (NpmInstallTask)npmInstallTaskProvider.get();
            excludeDirs.add(npmInstallTask.getNodeModulesDir());
        }
        ideaModule.setExcludeDirs(excludeDirs);
    }

    private void _configureTaskIdeaProvider(TaskProvider<Task> ideaTaskProvider) {
        ideaTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task ideaTask) {
                ideaTask.dependsOn(new Object[]{IdeaDefaultsPlugin._CLEAN_IDEA_TASK_NAME});
            }
        });
    }
}

