/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.NodeDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.internal.util.StringUtil;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.ExecutePackageManagerTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.node.tasks.YarnInstallTask;
import groovy.json.JsonSlurper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class LiferayYarnPlugin
implements Plugin<Project> {
    public static final String YARN_CHECK_FORMAT_TASK_NAME = "yarnCheckFormat";
    public static final String YARN_FORMAT_TASK_NAME = "yarnFormat";
    public static final String YARN_INSTALL_TASK_NAME = "yarnInstall";
    private static final String _CHECK_FORMAT_SCRIPT_NAME = "checkFormat";
    private static final String _FORMAT_SCRIPT_NAME = "format";
    private static final List<String> _excludes = Arrays.asList("**/bin/", "**/build/", "**/classes/", "**/node_modules/", "**/node_modules_cache/", "**/test-classes/", "**/tmp/");
    private static final List<String> _includes = Arrays.asList("yarn.lock", "private/yarn.lock", "apps/*/yarn.lock", "private/apps/*/yarn.lock");

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        GradleUtil.applyPlugin((Project)project, NodeDefaultsPlugin.class);
        HashMap<TaskProvider, File> yarnCheckFormatTaskProviders = new HashMap<TaskProvider, File>();
        HashMap<TaskProvider, File> yarnFormatTaskProviders = new HashMap<TaskProvider, File>();
        HashMap<TaskProvider, File> yarnInstallTaskProviders = new HashMap<TaskProvider, File>();
        for (File file : this._getYarnLockFiles(project)) {
            yarnInstallTaskProviders.put(GradleUtil.addTaskProvider((Project)project, (String)this._getYarnTaskName(YARN_INSTALL_TASK_NAME, file), YarnInstallTask.class), file);
            if (this._hasPackageJsonScript(_CHECK_FORMAT_SCRIPT_NAME, file)) {
                yarnCheckFormatTaskProviders.put(GradleUtil.addTaskProvider((Project)project, (String)this._getYarnTaskName(YARN_CHECK_FORMAT_TASK_NAME, file), ExecutePackageManagerTask.class), file);
            }
            if (!this._hasPackageJsonScript(_FORMAT_SCRIPT_NAME, file)) continue;
            yarnFormatTaskProviders.put(GradleUtil.addTaskProvider((Project)project, (String)this._getYarnTaskName(YARN_FORMAT_TASK_NAME, file), ExecutePackageManagerTask.class), file);
        }
        for (Map.Entry entry : yarnCheckFormatTaskProviders.entrySet()) {
            this._configureTaskYarnCheckFormatProvider((TaskProvider<ExecutePackageManagerTask>)((TaskProvider)entry.getKey()), (File)entry.getValue());
        }
        for (Map.Entry entry : yarnFormatTaskProviders.entrySet()) {
            this._configureTaskYarnFormatProvider((TaskProvider<ExecutePackageManagerTask>)((TaskProvider)entry.getKey()), (File)entry.getValue());
        }
        for (Map.Entry entry : yarnInstallTaskProviders.entrySet()) {
            this._configureTaskYarnInstallProvider((TaskProvider<YarnInstallTask>)((TaskProvider)entry.getKey()), (File)entry.getValue());
        }
        TaskProvider yarnCheckFormatTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)YARN_CHECK_FORMAT_TASK_NAME, Task.class);
        TaskProvider taskProvider = GradleUtil.addTaskProvider((Project)project, (String)YARN_FORMAT_TASK_NAME, Task.class);
        final TaskProvider yarnInstallTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)YARN_INSTALL_TASK_NAME, Task.class);
        this._configureTaskYarnCheckFormatProvider((TaskProvider<Task>)yarnCheckFormatTaskProvider, yarnCheckFormatTaskProviders.keySet());
        this._configureTaskYarnFormatProvider((TaskProvider<Task>)taskProvider, yarnFormatTaskProviders.keySet());
        this._configureTaskYarnInstallProvider((TaskProvider<Task>)yarnInstallTaskProvider, yarnInstallTaskProviders.keySet());
        Gradle gradle = project.getGradle();
        StartParameter startParameter = gradle.getStartParameter();
        if (startParameter.isParallelProjectExecutionEnabled()) {
            return;
        }
        for (Project subproject : project.getSubprojects()) {
            subproject.afterEvaluate((Action)new Action<Project>(){

                public void execute(Project project) {
                    TaskContainer taskContainer = project.getTasks();
                    taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

                        public void execute(NpmInstallTask npmInstallTask) {
                            LiferayYarnPlugin.this._configureTaskNpmInstallAfterEvaluate(npmInstallTask, (TaskProvider<Task>)yarnInstallTaskProvider);
                        }
                    });
                }
            });
        }
    }

    private void _configureTaskNpmInstallAfterEvaluate(NpmInstallTask npmInstallTask, TaskProvider<Task> yarnInstallTaskProvider) {
        if (!npmInstallTask.isUseNpm()) {
            npmInstallTask.finalizedBy(new Object[]{yarnInstallTaskProvider});
        }
    }

    private void _configureTaskYarnCheckFormatProvider(TaskProvider<ExecutePackageManagerTask> yarnCheckFormatTaskProvider, final File yarnLockFile) {
        yarnCheckFormatTaskProvider.configure((Action)new Action<ExecutePackageManagerTask>(){

            public void execute(ExecutePackageManagerTask yarnCheckFormatExecutePackageManagerTask) {
                yarnCheckFormatExecutePackageManagerTask.args(new Object[]{LiferayYarnPlugin._CHECK_FORMAT_SCRIPT_NAME});
                yarnCheckFormatExecutePackageManagerTask.setDescription("Runs the Yarn \"checkFormat\" script.");
                yarnCheckFormatExecutePackageManagerTask.setWorkingDir((Object)yarnLockFile.getParentFile());
            }
        });
    }

    private void _configureTaskYarnCheckFormatProvider(TaskProvider<Task> yarnCheckFormatTaskProvider, final Set<TaskProvider<ExecutePackageManagerTask>> yarnCheckFormatTaskProviders) {
        yarnCheckFormatTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task yarnCheckFormatTask) {
                yarnCheckFormatTask.setDescription("Runs the Yarn \"checkFormat\" script.");
                yarnCheckFormatTask.setGroup("formatting");
                for (TaskProvider yarnCheckFormatTaskProvider : yarnCheckFormatTaskProviders) {
                    yarnCheckFormatTask.finalizedBy(new Object[]{yarnCheckFormatTaskProvider});
                }
            }
        });
    }

    private void _configureTaskYarnFormatProvider(TaskProvider<ExecutePackageManagerTask> yarnFormatTaskProvider, final File yarnLockFile) {
        yarnFormatTaskProvider.configure((Action)new Action<ExecutePackageManagerTask>(){

            public void execute(ExecutePackageManagerTask yarnFormatExecutePackageManagerTask) {
                yarnFormatExecutePackageManagerTask.args(new Object[]{LiferayYarnPlugin._FORMAT_SCRIPT_NAME});
                yarnFormatExecutePackageManagerTask.setDescription("Runs the Yarn \"format\" script.");
                yarnFormatExecutePackageManagerTask.setWorkingDir((Object)yarnLockFile.getParentFile());
            }
        });
    }

    private void _configureTaskYarnFormatProvider(TaskProvider<Task> yarnFormatTaskProvider, final Set<TaskProvider<ExecutePackageManagerTask>> yarnFormatTaskProviders) {
        yarnFormatTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task yarnFormatTask) {
                yarnFormatTask.setDescription("Runs the Yarn \"format\" script.");
                yarnFormatTask.setGroup("formatting");
                for (TaskProvider yarnFormatTaskProvider : yarnFormatTaskProviders) {
                    yarnFormatTask.finalizedBy(new Object[]{yarnFormatTaskProvider});
                }
            }
        });
    }

    private void _configureTaskYarnInstallProvider(TaskProvider<Task> yarnInstallTaskProvider, final Set<TaskProvider<YarnInstallTask>> yarnInstallTaskProviders) {
        yarnInstallTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task yarnInstallTask) {
                yarnInstallTask.setDescription("Installs the Node.js packages.");
                yarnInstallTask.setGroup("build");
                for (TaskProvider yarnInstallTaskProvider : yarnInstallTaskProviders) {
                    yarnInstallTask.finalizedBy(new Object[]{yarnInstallTaskProvider});
                }
            }
        });
    }

    private void _configureTaskYarnInstallProvider(TaskProvider<YarnInstallTask> yarnInstallTaskProvider, final File yarnLockFile) {
        yarnInstallTaskProvider.configure((Action)new Action<YarnInstallTask>(){

            public void execute(YarnInstallTask yarnInstallTask) {
                boolean frozenLockfile = Boolean.parseBoolean(System.getProperty("frozen.lockfile", Boolean.TRUE.toString()));
                yarnInstallTask.setDescription("Installs the Node.js packages.");
                yarnInstallTask.setFrozenLockFile((Object)frozenLockfile);
                yarnInstallTask.setWorkingDir((Object)yarnLockFile.getParentFile());
            }
        });
    }

    private List<File> _getYarnLockFiles(Project project) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", project.getProjectDir());
        args.put("excludes", _excludes);
        args.put("includes", _includes);
        ConfigurableFileTree yarnLockFileTree = project.fileTree(args);
        return new ArrayList<File>(yarnLockFileTree.getFiles());
    }

    private String _getYarnTaskName(String parentTaskName, File yarnLockFile) {
        File workingDir = yarnLockFile.getParentFile();
        String suffix = StringUtil.camelCase(workingDir.getName(), true);
        return parentTaskName + suffix;
    }

    private boolean _hasPackageJsonScript(String scriptName, File yarnLockFile) {
        File packageJsonFile = new File(yarnLockFile.getParentFile(), "package.json");
        if (!packageJsonFile.exists()) {
            return false;
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map packageJsonMap = (Map)jsonSlurper.parse(packageJsonFile);
        Map scriptsJsonMap = (Map)packageJsonMap.get("scripts");
        if (scriptsJsonMap == null) {
            return false;
        }
        for (String curScriptName : scriptsJsonMap.keySet()) {
            if (!curScriptName.equals(scriptName)) continue;
            return true;
        }
        return false;
    }
}

