/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.tasks.BuildExtInfoTask;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.War;
import org.gradle.util.GUtil;

public class LiferayExtPlugin
implements Plugin<Project> {
    public static final String BUILD_EXT_INFO_BASE_DIR_TASK_NAME = "buildExtInfoBaseDir";
    public static final String BUILD_EXT_INFO_TASK_NAME = "buildExtInfo";
    public static final String EXT_IMPL_SOURCE_SET_NAME = "extImpl";
    public static final String EXT_KERNEL_SOURCE_SET_NAME = "extKernel";
    public static final String EXT_UTIL_BRIDGES_SOURCE_SET_NAME = "extUtilBridges";
    public static final String EXT_UTIL_JAVA_SOURCE_SET_NAME = "extUtilJava";
    public static final String EXT_UTIL_TAGLIB_SOURCE_SET_NAME = "extUtilTaglib";

    public void apply(Project project) {
        this._applyPlugins(project);
        ExtensionContainer extensionContainer = project.getExtensions();
        LiferayExtension liferayExtension = (LiferayExtension)extensionContainer.getByType(LiferayExtension.class);
        this._configureExtensionLiferay(liferayExtension);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration portalConfiguration = configurationContainer.getByName("portal");
        Convention convention = project.getConvention();
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)convention.getPlugin(JavaPluginConvention.class);
        WarPluginConvention warPluginConvention = (WarPluginConvention)convention.getPlugin(WarPluginConvention.class);
        SourceSetContainer sourceSetContainer = javaPluginConvention.getSourceSets();
        SourceSet extImplSourceSet = (SourceSet)sourceSetContainer.create(EXT_IMPL_SOURCE_SET_NAME);
        SourceSet extKernelSourceSet = (SourceSet)sourceSetContainer.create(EXT_KERNEL_SOURCE_SET_NAME);
        SourceSet extUtilBridgesSourceSet = (SourceSet)sourceSetContainer.create(EXT_UTIL_BRIDGES_SOURCE_SET_NAME);
        SourceSet extUtilJavaSourceSet = (SourceSet)sourceSetContainer.create(EXT_UTIL_JAVA_SOURCE_SET_NAME);
        SourceSet extUtilTaglibSourceSet = (SourceSet)sourceSetContainer.create(EXT_UTIL_TAGLIB_SOURCE_SET_NAME);
        this._configureSourceSetExt(warPluginConvention, extImplSourceSet);
        this._configureSourceSetExt(warPluginConvention, extKernelSourceSet);
        this._configureSourceSetExt(warPluginConvention, extUtilBridgesSourceSet);
        this._configureSourceSetExt(warPluginConvention, extUtilJavaSourceSet);
        this._configureSourceSetExt(warPluginConvention, extUtilTaglibSourceSet);
        TaskProvider buildExtInfoBaseDirTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)BUILD_EXT_INFO_BASE_DIR_TASK_NAME, Sync.class);
        TaskProvider buildExtInfoTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)BUILD_EXT_INFO_TASK_NAME, BuildExtInfoTask.class);
        TaskProvider extImplJarTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)extImplSourceSet.getJarTaskName(), Jar.class);
        TaskProvider extKernelJarTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)extKernelSourceSet.getJarTaskName(), Jar.class);
        TaskProvider extUtilBridgesJarTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)extUtilBridgesSourceSet.getJarTaskName(), Jar.class);
        TaskProvider extUtilJavaJarTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)extUtilJavaSourceSet.getJarTaskName(), Jar.class);
        TaskProvider extUtilTaglibJarTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)extUtilTaglibSourceSet.getJarTaskName(), Jar.class);
        TaskProvider deployTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"deploy", Copy.class);
        TaskProvider warTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"war", War.class);
        this._configureTaskBuildExtInfoBaseDirProvider(project, (TaskProvider<Sync>)buildExtInfoBaseDirTaskProvider, (TaskProvider<BuildExtInfoTask>)buildExtInfoTaskProvider, (TaskProvider<War>)warTaskProvider);
        this._configureTaskBuildExtInfoProvider((TaskProvider<Sync>)buildExtInfoBaseDirTaskProvider, (TaskProvider<BuildExtInfoTask>)buildExtInfoTaskProvider, (TaskProvider<War>)warTaskProvider, (FileCollection)portalConfiguration);
        this._configureTaskDeployProvider((TaskProvider<Copy>)deployTaskProvider, (TaskProvider<War>)warTaskProvider);
        this._configureTaskExtImplJarProvider(project, (TaskProvider<Jar>)extImplJarTaskProvider, extUtilBridgesJarTaskProvider, extUtilJavaJarTaskProvider, extUtilTaglibJarTaskProvider);
        this._configureTaskExtJarProvider(extImplSourceSet, (TaskProvider<Jar>)extImplJarTaskProvider);
        this._configureTaskExtJarProvider(extKernelSourceSet, (TaskProvider<Jar>)extKernelJarTaskProvider);
        this._configureTaskExtJarProvider(extUtilBridgesSourceSet, (TaskProvider<Jar>)extUtilBridgesJarTaskProvider);
        this._configureTaskExtJarProvider(extUtilJavaSourceSet, (TaskProvider<Jar>)extUtilJavaJarTaskProvider);
        this._configureTaskExtJarProvider(extUtilTaglibSourceSet, (TaskProvider<Jar>)extUtilTaglibJarTaskProvider);
        this._configureTaskWarProvider(project, (TaskProvider<BuildExtInfoTask>)buildExtInfoTaskProvider, (TaskProvider<War>)warTaskProvider, extImplJarTaskProvider, extKernelJarTaskProvider, extUtilBridgesJarTaskProvider, extUtilJavaJarTaskProvider, extUtilTaglibJarTaskProvider);
        ConfigurableFileCollection fileCollection = project.files(new Object[]{extKernelJarTaskProvider, extUtilBridgesJarTaskProvider, extUtilJavaJarTaskProvider, extUtilTaglibJarTaskProvider});
        extImplSourceSet.setCompileClasspath(portalConfiguration.plus((FileCollection)fileCollection));
        fileCollection = project.files(new Object[]{Collections.emptyList()});
        extKernelSourceSet.setCompileClasspath(portalConfiguration.plus((FileCollection)fileCollection));
        fileCollection = project.files(new Object[]{extKernelJarTaskProvider});
        extUtilBridgesSourceSet.setCompileClasspath(portalConfiguration.plus((FileCollection)fileCollection));
        fileCollection = project.files(new Object[]{extKernelJarTaskProvider, extUtilBridgesJarTaskProvider});
        extUtilJavaSourceSet.setCompileClasspath(portalConfiguration.plus((FileCollection)fileCollection));
        fileCollection = project.files(new Object[]{extKernelJarTaskProvider, extUtilBridgesJarTaskProvider, extUtilJavaJarTaskProvider});
        extUtilTaglibSourceSet.setCompileClasspath(portalConfiguration.plus((FileCollection)fileCollection));
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, WarPlugin.class);
    }

    private void _configureExtensionLiferay(final LiferayExtension liferayExtension) {
        liferayExtension.setDeployDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(liferayExtension.getAppServerParentDir(), "deploy");
            }
        });
    }

    private void _configureSourceSetExt(final WarPluginConvention warPluginConvention, final SourceSet extSourceSet) {
        SourceDirectorySet javaSourceDirectorySet = extSourceSet.getJava();
        javaSourceDirectorySet.srcDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                String s = GUtil.toWords((CharSequence)extSourceSet.getName(), (char)'-');
                return new File(warPluginConvention.getWebAppDir(), "WEB-INF/" + s + "/src");
            }
        });
        SourceDirectorySet resourcesDirectorySet = extSourceSet.getResources();
        resourcesDirectorySet.srcDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                String s = GUtil.toWords((CharSequence)extSourceSet.getName(), (char)'-');
                return new File(warPluginConvention.getWebAppDir(), "WEB-INF/" + s + "/src");
            }
        });
    }

    private void _configureTaskBuildExtInfoBaseDirProvider(final Project project, TaskProvider<Sync> buildExtInfoBaseDirTaskProvider, final TaskProvider<BuildExtInfoTask> buildExtInfoTaskProvider, final TaskProvider<War> warTaskProvider) {
        buildExtInfoBaseDirTaskProvider.configure((Action)new Action<Sync>(){

            public void execute(Sync buildExtInfoBaseDirSync) {
                buildExtInfoBaseDirSync.exclude((Spec)new Spec<FileTreeElement>(){

                    public boolean isSatisfiedBy(FileTreeElement fileTreeElement) {
                        BuildExtInfoTask buildExtInfoTask = (BuildExtInfoTask)((Object)buildExtInfoTaskProvider.get());
                        File outputFile = buildExtInfoTask.getOutputFile();
                        String outputFileName = outputFile.getName();
                        return outputFileName.equals(fileTreeElement.getPath());
                    }
                });
                buildExtInfoBaseDirSync.into((Object)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return new File(project.getBuildDir(), "build-ext-info");
                    }
                });
                buildExtInfoBaseDirSync.setDescription("Copies the exploded war archive into a temporary directory.");
                buildExtInfoBaseDirSync.with(new CopySpec[]{(CopySpec)warTaskProvider.get()});
            }
        });
    }

    private void _configureTaskBuildExtInfoProvider(final TaskProvider<Sync> buildExtInfoBaseDirTaskProvider, TaskProvider<BuildExtInfoTask> buildExtInfoTaskProvider, final TaskProvider<War> warTaskProvider, final FileCollection classpath) {
        buildExtInfoTaskProvider.configure((Action)new Action<BuildExtInfoTask>(){

            public void execute(final BuildExtInfoTask buildExtInfoTask) {
                final Sync buildExtInfoBaseDirSync = (Sync)buildExtInfoBaseDirTaskProvider.get();
                buildExtInfoTask.dependsOn(new Object[]{buildExtInfoBaseDirSync});
                buildExtInfoTask.setBaseDir(new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return new File(buildExtInfoBaseDirSync.getDestinationDir(), "WEB-INF");
                    }
                });
                buildExtInfoTask.setClasspath(classpath);
                buildExtInfoTask.setDescription("Generates the ext information xml file.");
                buildExtInfoTask.setOutputDir(new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return buildExtInfoTask.getTemporaryDir();
                    }
                });
                buildExtInfoTask.setServletContextName(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        War war = (War)warTaskProvider.get();
                        Property archiveAppendixProperty = war.getArchiveAppendix();
                        Property archiveBaseNameProperty = war.getArchiveBaseName();
                        String servletContextName = (String)archiveBaseNameProperty.get();
                        if (archiveAppendixProperty.isPresent()) {
                            servletContextName = servletContextName + '-' + (String)archiveAppendixProperty.get();
                        }
                        return servletContextName;
                    }
                });
            }
        });
    }

    private void _configureTaskDeployProvider(TaskProvider<Copy> deployTaskProvider, final TaskProvider<War> warTaskProvider) {
        deployTaskProvider.configure((Action)new Action<Copy>(){

            public void execute(Copy deployCopy) {
                deployCopy.from(new Object[]{warTaskProvider});
            }
        });
    }

    private void _configureTaskExtImplJarProvider(final Project project, TaskProvider<Jar> extImplJarTaskProvider, final TaskProvider<Jar> ... extJarTaskProviders) {
        extImplJarTaskProvider.configure((Action)new Action<Jar>(){

            public void execute(Jar extImplJar) {
                for (final TaskProvider extJarTaskProvider : extJarTaskProviders) {
                    extImplJar.into((Object)"com/liferay/portal/deploy/dependencies", (Closure)new Closure<Void>((Object)project){

                        public void doCall(CopySpec copySpec) {
                            Jar extJar = (Jar)extJarTaskProvider.get();
                            Property archiveAppendixProperty = extJar.getArchiveAppendix();
                            final String archiveAppendix = (String)archiveAppendixProperty.get();
                            Property archiveExtensionProperty = extJar.getArchiveExtension();
                            final String archiveExtension = (String)archiveExtensionProperty.get();
                            copySpec.from(new Object[]{extJar});
                            copySpec.rename((Closure)new Closure<String>((Object)project){

                                public String doCall(String fileName) {
                                    StringBuilder sb = new StringBuilder();
                                    sb.append("ext-");
                                    sb.append(project.getName());
                                    sb.append('-');
                                    sb.append(archiveAppendix);
                                    sb.append('.');
                                    sb.append(archiveExtension);
                                    return sb.toString();
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    private void _configureTaskExtJarProvider(final SourceSet extSourceSet, TaskProvider<Jar> extJarTaskProvider) {
        extJarTaskProvider.configure((Action)new Action<Jar>(){

            public void execute(Jar extJar) {
                extJar.from(new Object[]{extSourceSet.getOutput()});
                Property archiveAppendixProperty = extJar.getArchiveAppendix();
                String archiveAppendix = GUtil.toWords((CharSequence)extSourceSet.getName(), (char)'-');
                archiveAppendixProperty.set((Object)archiveAppendix);
                extJar.setDescription("Assembles a jar archive containing the " + archiveAppendix + " classes.");
            }
        });
    }

    private void _configureTaskWarProvider(final Project project, final TaskProvider<BuildExtInfoTask> buildExtInfoTaskProvider, TaskProvider<War> warTaskProvider, final TaskProvider<Jar> ... extJarTaskProviders) {
        warTaskProvider.configure((Action)new Action<War>(){

            public void execute(War war) {
                String name = project.getName();
                if (!name.endsWith("-ext")) {
                    Property archiveAppendixProperty = war.getArchiveAppendix();
                    archiveAppendixProperty.set((Object)"ext");
                }
                CopySpec copySpec = war.getWebInf();
                war.dependsOn(new Object[]{buildExtInfoTaskProvider});
                copySpec.from(new Object[]{new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        BuildExtInfoTask buildExtInfoTask = (BuildExtInfoTask)((Object)buildExtInfoTaskProvider.get());
                        return buildExtInfoTask.getOutputFile();
                    }
                }});
                for (TaskProvider extJarTaskProvider : extJarTaskProviders) {
                    Jar extJar = (Jar)extJarTaskProvider.get();
                    Property archiveAppendixProperty = extJar.getArchiveAppendix();
                    final String archiveAppendix = (String)archiveAppendixProperty.get();
                    Property archiveExtensionProperty = extJar.getArchiveExtension();
                    final String archiveExtension = (String)archiveExtensionProperty.get();
                    copySpec.from((Object)extJarTaskProvider, (Closure)new Closure<Void>((Object)project){

                        public void doCall(CopySpec copySpec) {
                            copySpec.into((Object)archiveAppendix);
                            copySpec.rename((Closure)new Closure<String>((Object)project){

                                public String doCall(String fileName) {
                                    return archiveAppendix + '.' + archiveExtension;
                                }
                            });
                        }
                    });
                }
            }
        });
    }
}

