/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import com.liferay.gradle.plugins.extensions.AppServer;
import com.liferay.gradle.plugins.tasks.AppServerTask;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class StopAppServerTask
extends DefaultTask
implements AppServerTask {
    private final AppServer _appServer = new AppServer(null, this.getProject());
    private String _appServerType;

    @InputDirectory
    public File getAppServerBinDir() {
        return this._appServer.getBinDir();
    }

    public String getAppServerStopExecutable() {
        return this._appServer.getStopExecutable();
    }

    public List<String> getAppServerStopExecutableArgs() {
        return this._appServer.getStopExecutableArgs();
    }

    @InputFile
    public File getAppServerStopExecutableFile() {
        return new File(this.getAppServerBinDir(), this.getAppServerStopExecutable());
    }

    @Override
    public String getAppServerType() {
        return this._appServerType;
    }

    public boolean isAppServerReachable() {
        return this._appServer.isReachable();
    }

    @Override
    public void merge(AppServer appServer) {
        List<String> appServerStopExecutableArgs;
        if (this.getAppServerBinDir() == null) {
            this.setAppServerBinDir(appServer.getBinDir());
        }
        if (Validator.isNull((String)this.getAppServerStopExecutable())) {
            this.setAppServerStopExecutable(appServer.getStopExecutable());
        }
        if ((appServerStopExecutableArgs = this.getAppServerStopExecutableArgs()).isEmpty()) {
            this.setAppServerStopExecutableArgs(appServer.getStopExecutableArgs());
        }
    }

    public void setAppServerBinDir(Object appServerBinDir) {
        this._appServer.setBinDir(appServerBinDir);
    }

    public void setAppServerStopExecutable(Object appServerStopExecutable) {
        this._appServer.setStopExecutable(appServerStopExecutable);
    }

    public void setAppServerStopExecutableArgs(Iterable<?> appServerStopExecutableArgs) {
        this._appServer.setStopExecutableArgs(appServerStopExecutableArgs);
    }

    public void setAppServerType(String appServerType) {
        this._appServerType = appServerType;
    }

    @TaskAction
    public void stopAppServer() throws Exception {
        if (!this.isAppServerReachable()) {
            return;
        }
        ArrayList<String> commands = new ArrayList<String>();
        File appServerStopExecutableFile = this.getAppServerStopExecutableFile();
        commands.add(appServerStopExecutableFile.getAbsolutePath());
        commands.addAll(this.getAppServerStopExecutableArgs());
        ProcessExecutor processExecutor = new ProcessExecutor(commands);
        processExecutor.directory(this.getAppServerBinDir());
        Slf4jStream slf4jStream = Slf4jStream.ofCaller();
        processExecutor.redirectError((OutputStream)slf4jStream.asWarn());
        processExecutor.redirectOutput((OutputStream)slf4jStream.asWarn());
        processExecutor.executeNoTimeout();
    }
}

