/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import com.liferay.gradle.plugins.extensions.AppServer;
import com.liferay.gradle.plugins.tasks.AppServerTask;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class StartAppServerTask
extends DefaultTask
implements AppServerTask {
    private final AppServer _appServer = new AppServer(null, this.getProject());
    private String _appServerType;
    private long _checkInterval = 500L;
    private long _timeout = 300000L;

    @InputDirectory
    public File getAppServerBinDir() {
        return this._appServer.getBinDir();
    }

    public String getAppServerStartExecutable() {
        return this._appServer.getStartExecutable();
    }

    public List<String> getAppServerStartExecutableArgs() {
        return this._appServer.getStartExecutableArgs();
    }

    @InputFile
    public File getAppServerStartExecutableFile() {
        return new File(this.getAppServerBinDir(), this.getAppServerStartExecutable());
    }

    @Override
    public String getAppServerType() {
        return this._appServerType;
    }

    public long getCheckInterval() {
        return this._checkInterval;
    }

    public String getCheckPath() {
        return this._appServer.getCheckPath();
    }

    public long getTimeout() {
        return this._timeout;
    }

    public boolean isAppServerReachable() {
        return this._appServer.isReachable();
    }

    @Override
    public void merge(AppServer appServer) {
        List<String> appServerStartExecutableArgs;
        if (this.getAppServerBinDir() == null) {
            this.setAppServerBinDir(appServer.getBinDir());
        }
        if (Validator.isNull((String)this.getAppServerStartExecutable())) {
            this.setAppServerStartExecutable(appServer.getStartExecutable());
        }
        if ((appServerStartExecutableArgs = this.getAppServerStartExecutableArgs()).isEmpty()) {
            this.setAppServerStartExecutableArgs(appServer.getStartExecutableArgs());
        }
    }

    public void setAppServerBinDir(Object appServerBinDir) {
        this._appServer.setBinDir(appServerBinDir);
    }

    public void setAppServerStartExecutable(Object appServerStartExecutable) {
        this._appServer.setStartExecutable(appServerStartExecutable);
    }

    public void setAppServerStartExecutableArgs(Iterable<?> appServerStartExecutableArgs) {
        this._appServer.setStartExecutableArgs(appServerStartExecutableArgs);
    }

    public void setAppServerType(String appServerType) {
        this._appServerType = appServerType;
    }

    public void setCheckInterval(long checkInterval) {
        this._checkInterval = checkInterval;
    }

    public void setCheckPath(Object checkPath) {
        this._appServer.setCheckPath(checkPath);
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    @TaskAction
    public void startAppServer() throws Exception {
        if (this.isAppServerReachable()) {
            return;
        }
        ArrayList<String> commands = new ArrayList<String>();
        File appServerStartExecutableFile = this.getAppServerStartExecutableFile();
        commands.add(appServerStartExecutableFile.getAbsolutePath());
        commands.addAll(this.getAppServerStartExecutableArgs());
        ProcessExecutor processExecutor = new ProcessExecutor(commands);
        processExecutor.directory(this.getAppServerBinDir());
        Slf4jStream slf4jStream = Slf4jStream.ofCaller();
        processExecutor.redirectError((OutputStream)slf4jStream.asWarn());
        processExecutor.redirectOutput((OutputStream)slf4jStream.asWarn());
        processExecutor.start();
        this.waitForAppServer();
    }

    public void waitForAppServer() {
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (StartAppServerTask.this.isAppServerReachable()) {
                    return true;
                }
                return false;
            }
        };
        boolean success = false;
        try {
            success = GradleUtil.waitFor((Callable)callable, (long)this.getCheckInterval(), (long)this.getTimeout());
        }
        catch (Exception e) {
            throw new GradleException("Unable to wait for the application server", (Throwable)e);
        }
        if (!success) {
            throw new GradleException("Timeout while starting the application server");
        }
    }
}

