/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import com.liferay.gradle.plugins.extensions.AppServer;
import com.liferay.gradle.plugins.extensions.TomcatAppServer;
import com.liferay.gradle.plugins.tasks.AppServerTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import groovy.lang.Closure;
import groovy.xml.DOMBuilder;
import groovy.xml.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetupTestableTomcatTask
extends DefaultTask
implements AppServerTask {
    private static final String[] _TOMCAT_USERS_ROLE_NAMES = new String[]{"manager-gui", "manager-jmx", "manager-script", "manager-status", "tomcat"};
    private boolean _debugLogging;
    private boolean _jmxRemoteAuthenticate;
    private int _jmxRemotePort;
    private boolean _jmxRemoteSsl;
    private File _moduleFrameworkBaseDir;
    private final Project _project;
    private final DateFormat _timestampDateFormat = new SimpleDateFormat("yyyyMMddkkmmssSSS");
    private final TomcatAppServer _tomcatAppServer = new TomcatAppServer(this.getProject());

    public SetupTestableTomcatTask() {
        this._project = this.getProject();
    }

    @Override
    public String getAppServerType() {
        return "tomcat";
    }

    @Input
    public int getJmxRemotePort() {
        return this._jmxRemotePort;
    }

    @InputDirectory
    public File getModuleFrameworkBaseDir() {
        return this._moduleFrameworkBaseDir;
    }

    public File getTomcatBinDir() {
        return new File(this.getTomcatDir(), "bin");
    }

    @InputDirectory
    public File getTomcatDir() {
        return this._tomcatAppServer.getDir();
    }

    @Input
    public String getTomcatManagerPassword() {
        return this._tomcatAppServer.getManagerPassword();
    }

    @Input
    public String getTomcatManagerUserName() {
        return this._tomcatAppServer.getManagerUserName();
    }

    @Input
    public String getTomcatZipUrl() {
        return this._tomcatAppServer.getZipUrl();
    }

    @Input
    public boolean isDebugLogging() {
        return this._debugLogging;
    }

    @Input
    public boolean isJmxRemoteAuthenticate() {
        return this._jmxRemoteAuthenticate;
    }

    @Input
    public boolean isJmxRemoteSsl() {
        return this._jmxRemoteSsl;
    }

    @Override
    public void merge(AppServer appServer) {
        TomcatAppServer tomcatAppServer = (TomcatAppServer)appServer;
        if (this.getTomcatDir() == null) {
            this.setTomcatDir(tomcatAppServer.getDir());
        }
        if (Validator.isNull((String)this.getTomcatManagerPassword())) {
            this.setTomcatManagerPassword(tomcatAppServer.getManagerPassword());
        }
        if (Validator.isNull((String)this.getTomcatManagerUserName())) {
            this.setTomcatManagerUserName(tomcatAppServer.getManagerUserName());
        }
        if (Validator.isNull((String)this.getTomcatZipUrl())) {
            this.setTomcatZipUrl(tomcatAppServer.getZipUrl());
        }
    }

    public void setDebugLogging(boolean debugLogging) {
        this._debugLogging = debugLogging;
    }

    public void setJmxRemoteAuthenticate(boolean jmxRemoteAuthenticate) {
        this._jmxRemoteAuthenticate = jmxRemoteAuthenticate;
    }

    public void setJmxRemotePort(int jmxRemotePort) {
        this._jmxRemotePort = jmxRemotePort;
    }

    public void setJmxRemoteSsl(boolean jmxRemoteSsl) {
        this._jmxRemoteSsl = jmxRemoteSsl;
    }

    public void setModuleFrameworkBaseDir(File moduleFrameworkBaseDir) {
        this._moduleFrameworkBaseDir = moduleFrameworkBaseDir;
    }

    public void setTomcatDir(Object tomcatDir) {
        this._tomcatAppServer.setDir(tomcatDir);
    }

    public void setTomcatManagerPassword(Object tomcatManagerPassword) {
        this._tomcatAppServer.setManagerPassword(tomcatManagerPassword);
    }

    public void setTomcatManagerUserName(Object tomcatManagerUserName) {
        this._tomcatAppServer.setManagerUserName(tomcatManagerUserName);
    }

    public void setTomcatZipUrl(Object tomcatZipUrl) {
        this._tomcatAppServer.setZipUrl(tomcatZipUrl);
    }

    @TaskAction
    public void setupTestableTomcat() throws Exception {
        this.setupJmx();
        this.setupLogging();
        this.setupManager();
        this.setupOsgiModules();
    }

    protected boolean contains(String fileName, String s) throws Exception {
        File file = new File(this.getTomcatDir(), fileName);
        String fileContent = new String(Files.readAllBytes(file.toPath()));
        return fileContent.contains(s);
    }

    protected PrintWriter getAppendPrintWriter(String fileName) throws Exception {
        File file = new File(this.getTomcatDir(), fileName);
        return new PrintWriter(Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.WRITE));
    }

    protected String getJmxOptions() {
        StringBuilder sb = new StringBuilder();
        sb.append("-Dcom.sun.management.jmxremote");
        sb.append(" -Dcom.sun.management.jmxremote.authenticate=");
        sb.append(this.isJmxRemoteAuthenticate());
        sb.append(" -Dcom.sun.management.jmxremote.port=");
        sb.append(this.getJmxRemotePort());
        sb.append(" -Dcom.sun.management.jmxremote.ssl=");
        sb.append(this.isJmxRemoteSsl());
        return sb.toString();
    }

    protected void setupJmx() throws Exception {
        Throwable throwable;
        PrintWriter printWriter;
        String jmxOptions = this.getJmxOptions();
        if (!this.contains("bin/setenv.bat", jmxOptions)) {
            printWriter = this.getAppendPrintWriter("bin/setenv.bat");
            throwable = null;
            try {
                printWriter.println();
                printWriter.print("set \"JMX_OPTS=");
                printWriter.print(jmxOptions);
                printWriter.println('\"');
                printWriter.println();
                printWriter.println("set \"CATALINA_OPTS=%CATALINA_OPTS% %JMX_OPTS%\"");
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (printWriter != null) {
                    if (throwable != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        printWriter.close();
                    }
                }
            }
        }
        if (!this.contains("bin/setenv.sh", jmxOptions)) {
            printWriter = this.getAppendPrintWriter("bin/setenv.sh");
            throwable = null;
            try {
                printWriter.print("JMX_OPTS=\"");
                printWriter.print(jmxOptions);
                printWriter.println('\"');
                printWriter.println();
                printWriter.println("CATALINA_OPTS=\"${CATALINA_OPTS} ${JMX_OPTS}\"");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (printWriter != null) {
                    if (throwable != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        printWriter.close();
                    }
                }
            }
        }
    }

    protected void setupLogging() throws Exception {
        if (!this.isDebugLogging() || this.contains("conf/Logging.properties", "org.apache.catalina.level")) {
            return;
        }
        try (PrintWriter printWriter = this.getAppendPrintWriter("conf/Logging.properties");){
            printWriter.println("org.apache.catalina.level=ALL");
            printWriter.println();
            printWriter.println("org.apache.catalina.loader.WebappClassLoader.level=INFO");
            printWriter.println("org.apache.catalina.loader.WebappLoader.level=INFO");
            printWriter.println("org.apache.catalina.startup.ClassLoaderFactory.level=INFO");
        }
    }

    protected void setupManager() throws Exception {
        final File managerDir = new File(this.getTomcatDir(), "webapps/manager");
        if (!managerDir.exists()) {
            final File tomcatZipFile = FileUtil.get((Project)this._project, (String)this.getTomcatZipUrl());
            Closure<Void> closure = new Closure<Void>(null){

                public void doCall(CopySpec copySpec) {
                    copySpec.eachFile((Action)new StripPathSegmentsAction(2));
                    copySpec.from(new Object[]{SetupTestableTomcatTask.this._project.zipTree((Object)tomcatZipFile)});
                    copySpec.include(new String[]{"apache-tomcat-*/webapps/manager/**/*"});
                    copySpec.into((Object)managerDir.getParentFile());
                    copySpec.setIncludeEmptyDirs(false);
                }
            };
            this._project.copy((Closure)closure);
        }
        Document document = null;
        File tomcatUsersXmlFile = new File(this.getTomcatDir(), "conf/tomcat-users.xml");
        try (InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(tomcatUsersXmlFile));){
            document = DOMBuilder.parse((Reader)inputStreamReader);
        }
        Element tomcatUsersElement = document.getDocumentElement();
        HashSet<String> existentRoleNames = new HashSet<String>();
        boolean tomcatManagerUserExists = false;
        NodeList nodeList = tomcatUsersElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String userName;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String elementName = element.getNodeName();
            if (elementName.equals("role")) {
                String roleName = element.getAttribute("rolename");
                existentRoleNames.add(roleName);
                continue;
            }
            if (!elementName.equals("user") || !(userName = element.getAttribute("username")).equals(this.getTomcatManagerUserName())) continue;
            tomcatManagerUserExists = true;
        }
        boolean tomcatUsersXmlFileModified = false;
        for (String roleName : _TOMCAT_USERS_ROLE_NAMES) {
            if (existentRoleNames.contains(roleName)) continue;
            Element element = document.createElement("role");
            element.setAttribute("rolename", roleName);
            tomcatUsersElement.appendChild(element);
            tomcatUsersXmlFileModified = true;
        }
        if (!tomcatManagerUserExists) {
            Element element = document.createElement("user");
            element.setAttribute("password", this.getTomcatManagerPassword());
            element.setAttribute("roles", "tomcat,manager-gui,manager-script,manager-jmx,manager-status");
            element.setAttribute("username", this.getTomcatManagerUserName());
            tomcatUsersElement.appendChild(element);
            tomcatUsersXmlFileModified = true;
        }
        if (tomcatUsersXmlFileModified) {
            Path timestampTomcatUserXmlFilePath = Paths.get(tomcatUsersXmlFile.toString() + "." + this._timestampDateFormat.format(new Date()), new String[0]);
            Files.copy(tomcatUsersXmlFile.toPath(), timestampTomcatUserXmlFilePath, new CopyOption[0]);
            try (FileOutputStream fileOutputStream = new FileOutputStream(tomcatUsersXmlFile);){
                XmlUtil.serialize((Element)tomcatUsersElement, (OutputStream)fileOutputStream);
            }
        }
    }

    protected void setupOsgiModules() {
        Closure<Void> closure = new Closure<Void>(null){

            public void doCall(CopySpec copySpec) {
                File moduleFrameworkBaseDir = SetupTestableTomcatTask.this.getModuleFrameworkBaseDir();
                copySpec.from(new Object[]{new File(moduleFrameworkBaseDir, "test")});
                copySpec.into((Object)new File(moduleFrameworkBaseDir, "modules"));
            }
        };
        this._project.copy((Closure)closure);
    }
}

