/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.LiferayOSGiExtension;
import com.liferay.gradle.plugins.extensions.LiferayThemeExtension;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import groovy.util.Node;
import groovy.util.NodeList;
import groovy.util.XmlParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import nebula.plugin.extraconfigurations.OptionalBasePlugin;
import nebula.plugin.extraconfigurations.ProvidedBasePlugin;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskAction;

public class InitGradleTask
extends DefaultTask {
    public static final String[] SOURCE_FILE_NAMES = new String[]{"build.xml", "docroot/WEB-INF/liferay-plugin-package.properties", "ivy.xml"};
    private static final Logger _logger = Logging.getLogger(InitGradleTask.class);
    private Node _buildXmlNode;
    private boolean _ignoreMissingDependencies;
    private Node _ivyXmlNode;
    private LiferayExtension _liferayExtension;
    private boolean _overwrite;
    private Properties _pluginPackageProperties;
    private final Map<String, String[]> _portalDependencyNotations = new HashMap<String, String[]>();
    private Project _project;

    public InitGradleTask() {
        this.portalDependencyNotation("antlr2.jar", "antlr", "antlr", "2.7.7");
        this.portalDependencyNotation("axis.jar", "com.liferay", "org.apache.axis", "1.4.LIFERAY-PATCHED-1");
        this.portalDependencyNotation("backport-concurrent.jar", "backport-util-concurrent", "backport-util-concurrent", "3.1");
        this.portalDependencyNotation("bsf.jar", "bsf", "bsf", "2.4.0");
        this.portalDependencyNotation("commons-beanutils.jar", "commons-beanutils", "commons-beanutils", "1.8.2");
        this.portalDependencyNotation("commons-chain.jar", "commons-chain", "commons-chain", "1.2");
        this.portalDependencyNotation("commons-codec.jar", "commons-codec", "commons-codec", "1.9");
        this.portalDependencyNotation("commons-collections.jar", "commons-collections", "commons-collections", "3.2.1");
        this.portalDependencyNotation("commons-digester.jar", "commons-digester", "commons-digester", "1.8");
        this.portalDependencyNotation("commons-discovery.jar", "commons-discovery", "commons-discovery", "0.4");
        this.portalDependencyNotation("commons-fileupload.jar", "commons-fileupload", "commons-fileupload", "1.3.1");
        this.portalDependencyNotation("commons-httpclient.jar", "commons-httpclient", "commons-httpclient", "3.1");
        this.portalDependencyNotation("commons-io.jar", "commons-io", "commons-io", "2.1");
        this.portalDependencyNotation("commons-lang.jar", "commons-lang", "commons-lang", "2.6");
        this.portalDependencyNotation("commons-logging.jar", "commons-logging", "commons-logging", "1.1.3");
        this.portalDependencyNotation("commons-math.jar", "org.apache.commons", "commons-math", "2.0");
        this.portalDependencyNotation("commons-validator.jar", "commons-validator", "commons-validator", "1.3.1");
        this.portalDependencyNotation("dom4j.jar", "dom4j", "dom4j", "1.6.1");
        this.portalDependencyNotation("hibernate-core.jar", "org.hibernate", "hibernate-core", "3.6.10.Final");
        this.portalDependencyNotation("ical4j.jar", "org.mnode.ical4j", "ical4j", "1.0.2");
        this.portalDependencyNotation("jabsorb.jar", "org.jabsorb", "jabsorb", "1.3.1");
        this.portalDependencyNotation("jaxrpc.jar", "javax.xml", "jaxrpc", "1.1");
        this.portalDependencyNotation("jcommon.jar", "jfree", "jcommon", "1.0.16");
        this.portalDependencyNotation("jdom.jar", "org.jopendocument", "jdom", "1.1.1");
        this.portalDependencyNotation("jericho-html.jar", "net.htmlparser.jericho", "jericho-html", "3.1");
        this.portalDependencyNotation("jfreechart.jar", "jfree", "jfreechart", "1.0.13");
        this.portalDependencyNotation("jruby.jar", "org.jruby", "jruby", "1.6.5");
        this.portalDependencyNotation("json-java.jar", "org.json", "json", "+");
        this.portalDependencyNotation("jstl-api.jar", "javax.servlet.jsp.jstl", "jstl-api", "1.2");
        this.portalDependencyNotation("jstl-impl.jar", "org.glassfish.web", "jstl-impl", "1.2");
        this.portalDependencyNotation("jutf7.jar", "com.beetstra.jutf7", "jutf7", "0.9.0");
        this.portalDependencyNotation("nekohtml.jar", "net.sourceforge.nekohtml", "nekohtml", "1.9.14");
        this.portalDependencyNotation("oro.jar", "oro", "oro", "2.0.8");
        this.portalDependencyNotation("portals-bridges.jar", "org.apache.portals.bridges", "portals-bridges-common", "1.0");
        this.portalDependencyNotation("rhino.jar", "org.mozilla", "rhino", "1.7R4");
        this.portalDependencyNotation("rome.jar", "rome", "rome", "1.0");
        this.portalDependencyNotation("saaj-api.jar", "javax.xml.soap", "saaj-api", "1.3");
        this.portalDependencyNotation("saaj-impl.jar", "com.sun.xml.messaging.saaj", "saaj-impl", "1.3");
        this.portalDependencyNotation("slf4j-api.jar", "org.slf4j", "slf4j-api", "1.7.2");
        this.portalDependencyNotation("struts-core.jar", "org.apache.struts", "struts-core", "1.3.10");
        this.portalDependencyNotation("struts-extras.jar", "org.apache.struts", "struts-extras", "1.3.10");
        this.portalDependencyNotation("struts-taglib.jar", "org.apache.struts", "struts-taglib", "1.3.10");
        this.portalDependencyNotation("struts-tiles.jar", "org.apache.struts", "struts-tiles", "1.3.10");
        this.portalDependencyNotation("util-slf4j.jar", "com.liferay.portal", "util-slf4j", "default");
        this.portalDependencyNotation("wsdl4j.jar", "wsdl4j", "wsdl4j", "1.6.1");
        this.portalDependencyNotation("xercesImpl.jar", "xerces", "xercesImpl", "2.11.0");
        this.portalDependencyNotation("xml-apis.jar", "xml-apis", "xml-apis", "1.4.01");
        this.portalDependencyNotation("xmlsec.jar", "org.apache.santuario", "xmlsec", "1.4.5");
    }

    public String[] getPortalDependencyNotation(String fileName) {
        return this._portalDependencyNotations.get(fileName);
    }

    @TaskAction
    public void initGradle() throws Exception {
        this._project = this.getProject();
        File buildGradleFile = this._project.file((Object)"build.gradle");
        if (!this.isOverwrite() && buildGradleFile.exists() && buildGradleFile.length() > 0L) {
            _logger.error("Unable to automatically upgrade build.gradle in \"" + this._project.getPath() + "\"");
            return;
        }
        this._liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)this._project, LiferayExtension.class);
        this._pluginPackageProperties = FileUtil.readProperties((Project)this._project, (String)"docroot/WEB-INF/liferay-plugin-package.properties");
        XmlParser xmlParser = new XmlParser();
        xmlParser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
        this._buildXmlNode = this.readXml(xmlParser, "build.xml");
        this._ivyXmlNode = this.readXml(xmlParser, "ivy.xml");
        ArrayList<String> contents = new ArrayList<String>();
        this.addContents(contents, this.getBuildGradleDependencies());
        this.addContents(contents, this.getBuildGradleDeploy());
        this.addContents(contents, this.getBuildGradleLiferay());
        this.addContents(contents, this.getBuildGradleProperties());
        FileUtil.write((File)buildGradleFile, contents);
    }

    public boolean isIgnoreMissingDependencies() {
        return this._ignoreMissingDependencies;
    }

    public boolean isOverwrite() {
        return this._overwrite;
    }

    public void portalDependencyNotation(String fileName, String group, String name, String version) {
        this._portalDependencyNotations.put(fileName, new String[]{group, name, version});
    }

    public void setIgnoreMissingDependencies(boolean ignoreMissingDependencies) {
        this._ignoreMissingDependencies = ignoreMissingDependencies;
    }

    public void setOverwrite(boolean overwrite) {
        this._overwrite = overwrite;
    }

    protected void addContents(List<String> contents1, List<String> contents2) {
        if (contents2.isEmpty()) {
            return;
        }
        if (!contents1.isEmpty()) {
            contents1.add("");
        }
        contents1.addAll(contents2);
    }

    protected String convertBuildPropertyValue(String value) {
        value = value.replace("${app.server.deploy.dir}", "${appServerDeployDir}");
        value = value.replace("${app.server.dir}", "${appServerDir}");
        value = value.replace("${app.server.lib.global.dir}", "${appServerLibGlobalDir}");
        value = value.replace("${app.server.parent.dir}", "${appServerParentDir}");
        value = value.replace("${auto.deploy.dir}", "${deployDir}");
        value = value.replace("${liferay.home}", "${liferayHome}");
        value = this._liferayExtension instanceof LiferayOSGiExtension ? value.replace("${plugin.name}", "${bundle.instructions['Bundle-SymbolicName']}") : value.replace("${plugin.name}", "${project.name}");
        return value;
    }

    protected List<String> getBuildDependenciesCompile() {
        String importShared;
        String requiredDeploymentContexts;
        ArrayList<String> contents = new ArrayList<String>();
        Iterator<Node> iterator = this.getIvyXmlDependenciesIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Node dependencyNode = iterator.next();
                String conf = (String)dependencyNode.attribute((Object)"conf");
                if (Validator.isNotNull((String)conf) && !conf.startsWith("default") && !conf.startsWith("internal")) continue;
                String group = (String)dependencyNode.attribute((Object)"org");
                String name = (String)dependencyNode.attribute((Object)"name");
                boolean optional = false;
                boolean transitive = this.getNodeAttribute(dependencyNode, "transitive", true);
                if (Validator.isNotNull((String)conf)) {
                    if (conf.startsWith("default")) {
                        transitive = false;
                    } else if (conf.startsWith("internal")) {
                        optional = true;
                    }
                }
                String version = (String)dependencyNode.attribute((Object)"rev");
                contents.add(this.wrapDependency("compile", group, name, optional, transitive, version));
            }
        }
        if (Validator.isNotNull((String)(requiredDeploymentContexts = this._pluginPackageProperties.getProperty("required-deployment-contexts")))) {
            String[] requiredDeploymentContextsArray;
            for (String deploymentContext : requiredDeploymentContextsArray = requiredDeploymentContexts.split(",")) {
                String serviceJarFileName = this.getServiceJarFileName(deploymentContext);
                if (!FileUtil.exists((Project)this._project, (String)serviceJarFileName)) continue;
                contents.add(this.wrapServiceJarDependency("compile", serviceJarFileName));
            }
        }
        if (Validator.isNotNull((String)(importShared = this.getBuildXmlProperty("import.shared")))) {
            String[] importSharedArray;
            HashMap<String, String> projectNamePathMap = new HashMap<String, String>();
            Project rootProject = this._project.getRootProject();
            for (Project project : rootProject.getSubprojects()) {
                if (!FileUtil.exists((Project)project, (String)"build.gradle")) continue;
                File dir = project.getProjectDir();
                projectNamePathMap.put(dir.getName(), project.getPath());
            }
            for (String projectFileName : importSharedArray = importShared.split(",")) {
                String projectPath;
                String projectName = projectFileName = projectFileName.trim();
                int pos = projectName.lastIndexOf(47);
                if (pos != -1) {
                    projectName = projectName.substring(pos + 1);
                }
                if (Validator.isNull((String)(projectPath = (String)projectNamePathMap.get(projectName)))) {
                    String message = "Unable to find project dependency " + projectFileName;
                    if (this.isIgnoreMissingDependencies()) {
                        _logger.error(message);
                        continue;
                    }
                    throw new GradleException(message);
                }
                contents.add(this.wrapProjectDependency("compile", projectPath));
            }
        }
        Collections.sort(contents);
        return contents;
    }

    protected List<String> getBuildDependenciesProvided() {
        ArrayList<String> contents = new ArrayList<String>();
        Iterator<Node> iterator = this.getIvyXmlDependenciesIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Node dependencyNode = iterator.next();
                String conf = (String)dependencyNode.attribute((Object)"conf");
                if (Validator.isNull((String)conf) || !conf.startsWith("provided")) continue;
                String group = (String)dependencyNode.attribute((Object)"org");
                String name = (String)dependencyNode.attribute((Object)"name");
                String version = (String)dependencyNode.attribute((Object)"rev");
                contents.add(this.wrapDependency(ProvidedBasePlugin.getPROVIDED_CONFIGURATION_NAME(), group, name, false, version));
            }
        }
        Collections.sort(contents);
        return contents;
    }

    protected List<String> getBuildDependenciesProvidedCompile() {
        ArrayList<String> contents = new ArrayList<String>();
        String portalDependencyJars = this._pluginPackageProperties.getProperty("portal-dependency-jars");
        if (Validator.isNotNull((String)portalDependencyJars)) {
            String[] portalDependencyJarsArray = portalDependencyJars.split(",");
            String configurationName = "providedCompile";
            if (FileUtil.exists((Project)this._project, (String)"bnd.bnd")) {
                configurationName = ProvidedBasePlugin.getPROVIDED_CONFIGURATION_NAME();
            }
            for (String fileName : portalDependencyJarsArray) {
                String[] portalDependencyNotation = this.getPortalDependencyNotation(fileName);
                if (portalDependencyNotation == null) {
                    _logger.error("Unable to find portal dependency " + fileName);
                    continue;
                }
                String group = portalDependencyNotation[0];
                String name = portalDependencyNotation[1];
                String version = portalDependencyNotation[2];
                contents.add(this.wrapDependency(configurationName, group, name, false, version));
            }
        }
        Collections.sort(contents);
        return contents;
    }

    protected List<String> getBuildDependenciesTestCompile() {
        ArrayList<String> contents = new ArrayList<String>();
        Iterator<Node> iterator = this.getIvyXmlDependenciesIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Node dependencyNode = iterator.next();
                String conf = (String)dependencyNode.attribute((Object)"conf");
                if (Validator.isNull((String)conf) || !conf.contains("test")) continue;
                String group = (String)dependencyNode.attribute((Object)"org");
                String name = (String)dependencyNode.attribute((Object)"name");
                boolean transitive = this.getNodeAttribute(dependencyNode, "transitive", true);
                String version = (String)dependencyNode.attribute((Object)"rev");
                contents.add(this.wrapDependency("testCompile", group, name, transitive, version));
            }
        }
        Collections.sort(contents);
        return contents;
    }

    protected List<String> getBuildGradleDependencies() {
        ArrayList<String> contents = new ArrayList<String>();
        this.addContents(contents, this.getBuildDependenciesCompile());
        this.addContents(contents, this.getBuildDependenciesProvided());
        this.addContents(contents, this.getBuildDependenciesProvidedCompile());
        this.addContents(contents, this.getBuildDependenciesTestCompile());
        return this.wrapContents(contents, 0, " {", "dependencies", "}", false);
    }

    protected List<String> getBuildGradleDeploy() {
        String[] osgiRuntimeDependenciesArray;
        String osgiRuntimeDependencies = this.getBuildXmlProperty("osgi.runtime.dependencies");
        if (Validator.isNull((String)osgiRuntimeDependencies)) {
            return Collections.emptyList();
        }
        List<String> contents = new ArrayList<String>();
        for (String osgiRuntimeDependency : osgiRuntimeDependenciesArray = osgiRuntimeDependencies.split(",")) {
            contents.add("\t\tinclude \"" + osgiRuntimeDependency + "\"");
        }
        contents = this.wrapContents(contents, 1, " {", "from(\"lib\")", "}", true);
        return this.wrapContents(contents, 0, " {", "deploy", "}", false);
    }

    protected List<String> getBuildGradleLiferay() {
        String autoUpdateXml;
        List<String> contents = new ArrayList<String>();
        String autoDeployDirName = this.getBuildXmlProperty("auto.deploy.dir");
        if (Validator.isNotNull((String)autoDeployDirName)) {
            autoDeployDirName = this.convertBuildPropertyValue(autoDeployDirName);
            contents.add(this.wrapPropertyFile("deployDir", autoDeployDirName));
        }
        if (this._liferayExtension instanceof LiferayOSGiExtension && Validator.isNotNull((String)(autoUpdateXml = this.getBuildXmlProperty("osgi.auto.update.xml")))) {
            contents.add(this.wrapProperty(1, "autoUpdateXml", false, autoUpdateXml));
        }
        if (this._liferayExtension instanceof LiferayThemeExtension) {
            String themeParent = this.getBuildXmlProperty("theme.parent");
            if (Validator.isNotNull((String)themeParent)) {
                contents.add(this.wrapProperty(1, "themeParent", themeParent));
            }
            String themeType = this.getBuildXmlProperty("theme.type", "vm");
            contents.add(this.wrapProperty(1, "themeType", themeType));
        }
        if (!contents.isEmpty()) {
            contents = this.wrapContents(contents, 0, " {", "liferay", "}", true);
        }
        return contents;
    }

    protected List<String> getBuildGradleProperties() {
        String pluginVersion;
        ArrayList<String> contents = new ArrayList<String>();
        String javacSource = this.getBuildXmlProperty("javac.source");
        if (Validator.isNotNull((String)javacSource)) {
            contents.add(this.wrapProperty(0, "sourceCompatibility", javacSource));
        }
        String javacTarget = this.getBuildXmlProperty("javac.target");
        if (Validator.isNotNull((String)javacSource)) {
            contents.add(this.wrapProperty(0, "targetCompatibility", javacTarget));
        }
        if (Validator.isNotNull((String)(pluginVersion = this.getBuildXmlProperty("plugin.version")))) {
            if (!contents.isEmpty()) {
                contents.add("");
            }
            contents.add(this.wrapProperty(0, "version", pluginVersion));
        }
        return contents;
    }

    protected String getBuildXmlProperty(String key) {
        return this.getBuildXmlProperty(key, null);
    }

    protected String getBuildXmlProperty(String key, String defaultValue) {
        NodeList propertyNodeList = (NodeList)this._buildXmlNode.get("property");
        for (Node propertyNode : propertyNodeList) {
            String propertyNodeName = (String)propertyNode.attribute((Object)"name");
            if (!key.equals(propertyNodeName)) continue;
            return (String)propertyNode.attribute((Object)"value");
        }
        return defaultValue;
    }

    protected Iterator<Node> getIvyXmlDependenciesIterator() {
        if (this._ivyXmlNode == null) {
            return null;
        }
        Node dependenciesNode = this.getNode(this._ivyXmlNode, "dependencies");
        if (dependenciesNode == null) {
            return null;
        }
        return dependenciesNode.iterator();
    }

    protected Node getNode(Node parentNode, String name) {
        NodeList nodeList = (NodeList)parentNode.get(name);
        if (nodeList.isEmpty()) {
            return null;
        }
        return (Node)nodeList.get(0);
    }

    protected boolean getNodeAttribute(Node node, String name, boolean defaultValue) {
        String value = (String)node.attribute((Object)name);
        if (Validator.isNull((String)value)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    protected String getServiceJarFileName(String deploymentContext) {
        StringBuilder sb = new StringBuilder();
        sb.append("../../");
        sb.append(deploymentContext.replaceFirst(".+-", ""));
        sb.append("s/");
        sb.append(deploymentContext);
        sb.append("/docroot/WEB-INF/lib/");
        sb.append(deploymentContext);
        sb.append("-service.jar");
        return sb.toString();
    }

    protected Node readXml(XmlParser xmlParser, String fileName) throws Exception {
        File file = this._project.file((Object)fileName);
        if (!file.exists()) {
            return null;
        }
        return xmlParser.parse(file);
    }

    protected List<String> wrapContents(List<String> contents, int indentCount, String leftClose, String name, String rightClose, boolean sort) {
        if (contents.isEmpty()) {
            return contents;
        }
        if (sort) {
            Collections.sort(contents);
        }
        String indent = StringUtil.repeat((char)'\t', (int)indentCount);
        contents.add(0, indent + name + leftClose);
        String content = contents.get(contents.size() - 1);
        if (content.endsWith(",")) {
            contents.remove(contents.size() - 1);
            contents.add(content.substring(0, content.length() - 1));
        }
        contents.add(indent + rightClose);
        return contents;
    }

    protected String wrapDependency(String configurationName, String group, String name, boolean optional, boolean transitive, String version) {
        StringBuilder sb = new StringBuilder();
        sb.append('\t');
        sb.append(configurationName);
        sb.append(" group: \"");
        sb.append(group);
        sb.append("\", name: \"");
        sb.append(name);
        sb.append('\"');
        if (optional) {
            sb.append(", ");
            sb.append(OptionalBasePlugin.getOPTIONAL_IDENTIFIER());
        }
        if (!transitive) {
            sb.append(", transitive: false");
        }
        sb.append(", version: \"");
        sb.append(version);
        sb.append('\"');
        return sb.toString();
    }

    protected String wrapDependency(String configurationName, String group, String name, boolean transitive, String version) {
        return this.wrapDependency(configurationName, group, name, false, transitive, version);
    }

    protected String wrapProjectDependency(String configurationName, String projectPath) {
        StringBuilder sb = new StringBuilder();
        sb.append('\t');
        sb.append(configurationName);
        sb.append(" project(\"");
        sb.append(projectPath);
        sb.append("\")");
        return sb.toString();
    }

    protected String wrapProperty(int indentCount, String name, boolean quoteValue, String value) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indentCount; ++i) {
            sb.append('\t');
        }
        sb.append(name);
        sb.append(" = ");
        if (quoteValue) {
            sb.append('\"');
        }
        sb.append(value);
        if (quoteValue) {
            sb.append('\"');
        }
        return sb.toString();
    }

    protected String wrapProperty(int indentCount, String name, String value) {
        return this.wrapProperty(indentCount, name, true, value);
    }

    protected String wrapPropertyFile(String name, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append('\t');
        sb.append(name);
        sb.append(" = file(\"");
        sb.append(value);
        sb.append("\")");
        return sb.toString();
    }

    protected String wrapServiceJarDependency(String configurationName, String serviceJarFileName) {
        StringBuilder sb = new StringBuilder();
        sb.append('\t');
        sb.append(configurationName);
        sb.append(" files(\"");
        sb.append(serviceJarFileName);
        sb.append("\")");
        return sb.toString();
    }
}

