/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import com.liferay.gradle.plugins.tasks.BasePortalImplToolsTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;

public class DirectDeployTask
extends BasePortalImplToolsTask {
    private File _appServerDeployDir;
    private File _appServerDir;
    private String _appServerType;
    private String _argAppServerType;
    private boolean _customPortletXml;
    private boolean _unpackWar = true;
    private File _webAppFile;
    private String _webAppType;

    public File getAppServerDeployDir() {
        return this._appServerDeployDir;
    }

    public File getAppServerDir() {
        return this._appServerDir;
    }

    public String getAppServerType() {
        return this._appServerType;
    }

    public String getArgAppServerType() {
        String argAppServerType = this._argAppServerType;
        if (Validator.isNull((String)argAppServerType)) {
            argAppServerType = this.getAppServerType();
        }
        return this._argAppServerType;
    }

    @Override
    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>(3);
        File appServerLibPortalDir = this.getAppServerLibPortalDir();
        String path = appServerLibPortalDir.getAbsolutePath();
        args.add(path + "/util-bridges.jar");
        args.add(path + "/util-java.jar");
        args.add(path + "/util-taglib.jar");
        return args;
    }

    public List<String> getJvmArgs() {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        File webAppFile = this.getWebAppFile();
        jvmArgs.add("-Ddeployer.app.server.type=" + this.getArgAppServerType());
        jvmArgs.add("-Ddeployer.base.dir=" + FileUtil.getAbsolutePath((File)webAppFile.getParentFile()));
        jvmArgs.add("-Ddeployer.dest.dir=" + FileUtil.getAbsolutePath((File)this.getAppServerDeployDir()));
        jvmArgs.add("-Ddeployer.file.pattern=" + webAppFile.getName());
        jvmArgs.add("-Ddeployer.unpack.war=" + this.isUnpackWar());
        jvmArgs.add("-Dexternal-properties=com/liferay/portal/tools/dependencies/portal-tools.properties");
        jvmArgs.add("-Dliferay.lib.portal.dir=" + FileUtil.getAbsolutePath((File)this.getAppServerLibPortalDir()));
        String webAppType = this.getWebAppType();
        if (!webAppType.equals("layouttpl")) {
            jvmArgs.add("-Ddeployer.tomcat.lib.dir=" + FileUtil.getAbsolutePath((File)this.getAppServerLibGlobalDir()));
        }
        String tldPath = FileUtil.getAbsolutePath((File)new File(this.getAppServerPortalDir(), "WEB-INF/tld"));
        if (webAppType.equals("portlet") || webAppType.equals("theme")) {
            jvmArgs.add("-Ddeployer.theme.taglib.dtd=" + tldPath + "/liferay-theme.tld");
            jvmArgs.add("-Ddeployer.ui.taglib.dtd=" + tldPath + "/liferay-ui.tld");
        }
        if (webAppType.equals("portlet")) {
            jvmArgs.add("-Ddeployer.aui.taglib.dtd=" + tldPath + "/liferay-aui.tld");
            jvmArgs.add("-Ddeployer.custom.portlet.xml=" + this.isCustomPortletXml());
            jvmArgs.add("-Ddeployer.portlet-ext.taglib.dtd=" + tldPath + "/liferay-portlet-ext.tld");
            jvmArgs.add("-Ddeployer.portlet.taglib.dtd=" + tldPath + "/liferay-portlet.tld");
            jvmArgs.add("-Ddeployer.security.taglib.dtd=" + tldPath + "/liferay-security.tld");
            jvmArgs.add("-Ddeployer.staging.taglib.dtd=util-taglib/classes/META-INF/liferay-staging.tld");
            jvmArgs.add("-Ddeployer.util.taglib.dtd=" + tldPath + "/liferay-util.tld");
        }
        return jvmArgs;
    }

    @Override
    public String getMain() {
        String webAppType = this.getWebAppType();
        if (webAppType.equals("layouttpl")) {
            webAppType = "layout";
        }
        return "com.liferay.portal.tools.deploy." + StringUtil.capitalize((String)webAppType) + "Deployer";
    }

    public File getWebAppFile() {
        return this._webAppFile;
    }

    public String getWebAppType() {
        return this._webAppType;
    }

    public boolean isCustomPortletXml() {
        return this._customPortletXml;
    }

    public boolean isUnpackWar() {
        return this._unpackWar;
    }

    public void setAppServerDeployDir(File appServerDeployDir) {
        this._appServerDeployDir = appServerDeployDir;
    }

    public void setAppServerDir(File appServerDir) {
        this._appServerDir = appServerDir;
    }

    public void setAppServerType(String appServerType) {
        this._appServerType = appServerType;
    }

    public void setArgAppServerType(String actualAppServerType) {
        this._argAppServerType = actualAppServerType;
    }

    public void setCustomPortletXml(boolean customPortletXml) {
        this._customPortletXml = customPortletXml;
    }

    public void setUnpackWar(boolean unpackWar) {
        this._unpackWar = unpackWar;
    }

    public void setWebAppFile(File webAppFile) {
        this._webAppFile = webAppFile;
    }

    public void setWebAppType(String webAppType) {
        this._webAppType = webAppType;
    }

    @Override
    protected void addDependencies() {
        super.addDependencies();
        String appServerType = this.getAppServerType();
        if (appServerType.equals("jonas")) {
            File dir = new File(this.getAppServerDir(), "lib/endorsed");
            GradleUtil.addDependency((Project)this.project, (String)this.getConfigurationName(), (FileCollection)this.getJarsFileTree(dir));
        }
    }

    @Override
    protected String getToolName() {
        return "Deployer";
    }
}

